/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.OptionChartsView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.AbstractGroupController;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.GroupChartArgument;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TopNItem;
import com.intel.stl.ui.performance.item.TrendItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;

public class CompactGroupController
extends AbstractGroupController<GroupSource> {
    private ChartsCard trendCard;
    private ChartsCard auxCard;

    public CompactGroupController(MBassador<IAppEvent> eventBus, String name, TrendItem<GroupSource> trendItem, AbstractPerformanceItem<GroupSource> histogramItem, TopNItem topNItem, HistoryType[] historyTypes) {
        super(eventBus, name, new IPerformanceItem[]{trendItem, histogramItem, topNItem});
        this.installTimeScopes(historyTypes);
    }

    @Override
    protected List<ChartsCard> initCards(Map<String, DatasetDescription> map) {
        ArrayList<ChartsCard> res = new ArrayList<ChartsCard>();
        if (this.allItems[0] != null) {
            this.trendCard = this.createTrendCard(this.allItems[0], map);
            res.add(this.trendCard);
        }
        if (this.allItems[1] != null || this.allItems[2] != null) {
            this.auxCard = this.createAuxCard(new IPerformanceItem[]{this.allItems[2], this.allItems[1]}, map);
            res.add(this.auxCard);
        }
        return res;
    }

    public void setHelpIDs(String trendHelpID, String auxHelpID) {
        if (this.trendCard != null) {
            this.trendCard.setHelpID(trendHelpID);
        }
        if (this.auxCard != null) {
            this.auxCard.setHelpID(auxHelpID);
        }
    }

    protected ChartsCard createTrendCard(IPerformanceItem<GroupSource> item, Map<String, DatasetDescription> map) {
        return this.createOptionCard(item, map, true, false);
    }

    protected ChartsCard createAuxCard(IPerformanceItem<GroupSource>[] items, Map<String, DatasetDescription> map) {
        return this.createCard(items, map);
    }

    protected void installTimeScopes(HistoryType ... types) {
        ChartsView view;
        if (this.group != null && (view = this.group.getChartView()) instanceof OptionChartsView) {
            ((OptionChartsView)view).setHistoryTypes(types);
        }
    }

    @Override
    protected ChartsView getItemView(IPerformanceItem<GroupSource> item) {
        if (this.allItems[0] == item) {
            return (ChartsView)this.trendCard.getView();
        }
        if (this.allItems[1] == item || this.allItems[2] == item) {
            return (ChartsView)this.auxCard.getView();
        }
        return null;
    }

    @Override
    protected ChartArgument<GroupSource> getChartArgument(IPerformanceItem<GroupSource> item) {
        GroupChartArgument arg = new GroupChartArgument();
        String name = item.getName();
        arg.setName(name);
        arg.setFullName(item.getFullName());
        arg.setProvider(item.getCurrentProviderName().name());
        if (item.getType() != null) {
            arg.setDataType(item.getType());
        }
        if (item.getHistoryType() != null) {
            arg.setHistoryType(item.getHistoryType());
        }
        arg.setSources((GroupSource[])item.getSources());
        return arg;
    }
}

