/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.VFSource;
import com.intel.stl.ui.performance.provider.DataProviderName;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class GroupChartArgument
extends ChartArgument<GroupSource> {
    private static final long serialVersionUID = -4053098986435251698L;
    public static final String GROUPS = "Groups";
    public static final String VFS = "VFs";

    public void setSources(GroupSource[] groups) {
        String[] tmp = new String[groups.length];
        String key = null;
        for (int i = 0; i < tmp.length; ++i) {
            if (key == null && groups[i] instanceof VFSource) {
                key = VFS;
            }
            tmp[i] = groups[i].getGroup();
        }
        if (key == null) {
            key = GROUPS;
        }
        this.put(key, this.toString(tmp));
    }

    public GroupSource[] getSources() {
        String str = this.getProperty(VFS);
        if (str != null) {
            String[] groups = this.toArray(str);
            GroupSource[] res = new VFSource[groups.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new VFSource(groups[i]);
            }
            return res;
        }
        str = this.getProperty(GROUPS);
        if (str != null) {
            String[] groups = this.toArray(str);
            GroupSource[] res = new GroupSource[groups.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new GroupSource(groups[i]);
            }
            return res;
        }
        return null;
    }

    @Override
    public Map<String, String> getSourceDescription() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        String provider = this.getProvider();
        if (provider != null && provider.equals(DataProviderName.VIRTUAL_FABRIC.name())) {
            String key = STLConstants.K0116_VIRTUAL_FABRIC.getValue();
            res.put(key, this.getProperty(VFS));
        } else {
            String key = STLConstants.K1030_GROUP_NAME.getValue();
            res.put(key, this.getProperty(GROUPS));
        }
        return res;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.getSources());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupChartArgument other = (GroupChartArgument)obj;
        return Arrays.equals(this.getSources(), other.getSources());
    }
}

