/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.PortSourceName;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class PortChartArgument<S extends PortSourceName>
extends ChartArgument<S> {
    private static final long serialVersionUID = -6818285518643166649L;
    protected static final String DELIMITER = ":";
    public static final String VF_NAME = "VF Name";
    public static final String NODE_DESC = "Node Desc.";
    public static final String NODE_LID = "Node LID";
    public static final String PORT_NUM = "Port Num.";

    public String getVfName() {
        return this.getProperty(VF_NAME);
    }

    public String getNodeDesc() {
        return this.getProperty(NODE_DESC);
    }

    public int getLid() {
        String str = this.getProperty(NODE_LID);
        if (str != null) {
            return Integer.parseInt(str);
        }
        throw new RuntimeException("No LID found!");
    }

    public short getPortNum() {
        String str = this.getProperty(PORT_NUM);
        if (str != null) {
            return Short.parseShort(str);
        }
        throw new RuntimeException("No PortNum found!");
    }

    public void setSource(String nodeDesc, int lid, short portNum) {
        if (nodeDesc != null) {
            if (nodeDesc.contains(DELIMITER)) {
                throw new IllegalArgumentException("Node desc cannot contains the DELIMITER ':'");
            }
            this.put(NODE_DESC, nodeDesc);
        }
        this.put(NODE_LID, Integer.toString(lid));
        this.put(PORT_NUM, Short.toString(portNum));
    }

    public void setSource(String vfName, String nodeDesc, int lid, short portNum) {
        if (vfName != null) {
            if (vfName.contains(DELIMITER)) {
                throw new IllegalArgumentException("VF name cannot contains the DELIMITER ':'");
            }
            this.put(VF_NAME, vfName);
        }
        this.setSource(nodeDesc, lid, portNum);
    }

    public void setSource(String sourceName) {
        String[] segs = sourceName.split(DELIMITER);
        if (segs.length == 3) {
            this.put(NODE_DESC, segs[0]);
            this.put(NODE_LID, segs[1]);
            this.put(PORT_NUM, segs[2]);
        } else if (segs.length == 4) {
            this.put(VF_NAME, segs[0]);
            this.put(NODE_DESC, segs[1]);
            this.put(NODE_LID, segs[2]);
            this.put(PORT_NUM, segs[3]);
        } else {
            throw new IllegalArgumentException("Invalid source name '" + sourceName + "'");
        }
    }

    @Override
    public S[] getSources() {
        PortSourceName source = new PortSourceName(this.getVfName(), this.getNodeDesc(), this.getLid(), this.getPortNum());
        return new PortSourceName[]{source};
    }

    @Override
    public Map<String, String> getSourceDescription() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        String vfName = this.getProperty(VF_NAME);
        if (vfName != null) {
            res.put(STLConstants.K0116_VIRTUAL_FABRIC.getValue(), vfName);
        }
        res.put(STLConstants.K1035_CONFIGURATION_PORT.getValue(), this.getNodeDesc() + DELIMITER + this.getPortNum());
        return res;
    }

    @Override
    public void setSources(S[] sources) {
        this.setSource(((PortSourceName)sources[0]).getVfName(), ((PortSourceName)sources[0]).getNodeDesc(), ((PortSourceName)sources[0]).getLid(), ((PortSourceName)sources[0]).getPortNum());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.getSources());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortChartArgument other = (PortChartArgument)obj;
        return Arrays.equals(this.getSources(), other.getSources());
    }
}

