/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance;

import com.intel.stl.ui.common.ChartsCard;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.view.ChartsView;
import com.intel.stl.ui.common.view.IChartCreator;
import com.intel.stl.ui.common.view.OptionChartsView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.UndoHandler;
import com.intel.stl.ui.main.view.IDataTypeListener;
import com.intel.stl.ui.model.DatasetDescription;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.monitor.ChartScaleGroupManager;
import com.intel.stl.ui.monitor.DataChartScaleGroupManager;
import com.intel.stl.ui.monitor.PacketChartScaleGroupManager;
import com.intel.stl.ui.performance.AbstractGroupController;
import com.intel.stl.ui.performance.ChartArgument;
import com.intel.stl.ui.performance.PortCounterChartArgument;
import com.intel.stl.ui.performance.PortCounterChartsCreator;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.UndoableChartHistorySelection;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.PCDataItem;
import com.intel.stl.ui.performance.item.PCErrItem;
import com.intel.stl.ui.performance.item.PCPacketItem;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.engio.mbassy.bus.MBassador;
import org.jfree.data.time.TimePeriodValuesCollection;

public class PortCounterGroupController
extends AbstractGroupController<PortCounterSourceName> {
    private ChartsCard portCounterChartCard;
    private final PacketChartScaleGroupManager packetScaleManager;
    private final DataChartScaleGroupManager dataScaleManager;
    private OptionChartsView optionChartsView;
    private PortCounterFieldItem oldSelectedItem;
    PCErrItem errItem;
    PCDataItem dataItem;
    PCPacketItem packetItem;

    public PortCounterGroupController(MBassador<IAppEvent> eventBus, String name, PCErrItem errItem, PCDataItem dataItem, PCPacketItem packetItem, HistoryType[] historyTypes) {
        super(eventBus, name, new IPerformanceItem[]{errItem, dataItem, packetItem});
        this.errItem = errItem;
        this.dataItem = dataItem;
        this.packetItem = packetItem;
        this.installTimeScopes(historyTypes);
        this.packetScaleManager = PacketChartScaleGroupManager.getInstance();
        if (this.portCounterChartCard != null) {
            this.packetScaleManager.addChart(((ChartsView)this.portCounterChartCard.getView()).getChart(packetItem.getName()), (TimePeriodValuesCollection)packetItem.getDataset());
        }
        packetItem.setScaleManager(this.packetScaleManager);
        this.dataScaleManager = DataChartScaleGroupManager.getInstance();
        if (this.portCounterChartCard != null) {
            this.dataScaleManager.addChart(((ChartsView)this.portCounterChartCard.getView()).getChart(dataItem.getName()), (TimePeriodValuesCollection)dataItem.getDataset());
        }
        dataItem.setScaleManager(this.dataScaleManager);
    }

    protected void installTimeScopes(HistoryType ... types) {
        if (this.optionChartsView != null) {
            this.optionChartsView.setHistoryTypes(types);
        }
    }

    @Override
    protected List<ChartsCard> initCards(Map<String, DatasetDescription> map) {
        ArrayList<ChartsCard> res = new ArrayList<ChartsCard>();
        this.portCounterChartCard = this.createCard(this.allItems, map);
        res.add(this.portCounterChartCard);
        return res;
    }

    @Override
    protected ChartsCard createCard(final IPerformanceItem<PortCounterSourceName>[] items, Map<String, DatasetDescription> map) {
        this.optionChartsView = new OptionChartsView("", this.getChartCreator()){

            @Override
            protected void setChartNames(List<DatasetDescription> datasets) {
            }
        };
        String[] names = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            names[i] = this.getItemName(items[i]);
        }
        ChartsCard chartsCard = this.createChartsCard(this.optionChartsView, map, names);
        this.optionChartsView.setHistoryTypeListener(new IDataTypeListener<HistoryType>(){

            @Override
            public void onDataTypeChange(HistoryType oldType, HistoryType newType) {
                PortCounterGroupController.this.optionChartsView.setHistoryType(newType);
                for (int i = 0; i < items.length; ++i) {
                    items[i].setHistoryType(newType, false);
                }
                UndoHandler undoHandler = PortCounterGroupController.this.getUndoHandler();
                if (undoHandler != null && !undoHandler.isInProgress()) {
                    UndoableChartHistorySelection sel = new UndoableChartHistorySelection(items, PortCounterGroupController.this.optionChartsView, oldType, newType);
                    undoHandler.addUndoAction(sel);
                }
            }
        });
        return chartsCard;
    }

    @Override
    protected void clearPin(ChartsCard pinCard, IPerformanceItem<PortCounterSourceName> pinItem) {
        super.clearPin(pinCard, pinItem);
        ChartScaleGroupManager<TimePeriodValuesCollection> scaleMgr = ((PortCounterFieldItem)pinItem).getScaleManager();
        if (scaleMgr != null) {
            scaleMgr.removeChart(((ChartsView)pinCard.getView()).getChart(pinItem.getName()));
        }
    }

    @Override
    protected ChartsCard getPinCard(ChartArgument<PortCounterSourceName> arg, IPerformanceItem<PortCounterSourceName> source) {
        ChartScaleGroupManager scaleMgr;
        ChartsCard res = super.getPinCard(arg, source);
        PortCounterFieldItem pinItem = (PortCounterFieldItem)this.pinItems.get(arg);
        if (pinItem != null && (scaleMgr = pinItem.getScaleManager()) == null) {
            if (source.getName().equals(this.allItems[2].getName())) {
                scaleMgr = this.packetScaleManager;
            } else if (source.getName().equals(this.allItems[1].getName())) {
                scaleMgr = this.dataScaleManager;
            }
            if (scaleMgr != null) {
                scaleMgr.addChart(((ChartsView)res.getView()).getChart(arg.getName()), (TimePeriodValuesCollection)pinItem.getDataset());
                pinItem.setScaleManager(scaleMgr);
                scaleMgr.updateChartsRange();
            }
        }
        return res;
    }

    @Override
    protected IChartCreator getChartCreator() {
        return PortCounterChartsCreator.instance();
    }

    public void onFieldNameChange(String label) {
        if (STLConstants.K0728_RX_CUMULATIVE_PACKETS.getValue().equals(label) || STLConstants.K0734_TX_CUMULATIVE_PACKETS.getValue().equals(label) || STLConstants.K0834_RX_MULTICAST_PACKETS.getValue().equals(label) || STLConstants.K0833_TX_MULTICAST_PACKETS.getValue().equals(label)) {
            this.packetItem.setFieldName(label);
            if (!(this.oldSelectedItem instanceof PCPacketItem)) {
                this.portCounterChartCard.onSelectChart(this.packetItem.getName());
            } else {
                this.packetItem.clear();
            }
            this.oldSelectedItem = this.packetItem;
        } else if (STLConstants.K0730_RX_CUMULATIVE_DATA.getValue().equals(label) || STLConstants.K0732_TX_CUMULATIVE_DATA.getValue().equals(label)) {
            this.dataItem.setFieldName(label);
            if (!(this.oldSelectedItem instanceof PCDataItem)) {
                this.portCounterChartCard.onSelectChart(this.dataItem.getName());
            } else {
                this.dataItem.clear();
            }
            this.oldSelectedItem = this.dataItem;
        } else {
            this.errItem.setFieldName(label);
            if (!(this.oldSelectedItem instanceof PCErrItem)) {
                this.portCounterChartCard.onSelectChart(this.errItem.getName());
            } else {
                this.errItem.clear();
            }
            this.oldSelectedItem = this.errItem;
        }
        ((ChartsView)this.portCounterChartCard.getView()).setTitle(label);
        this.resetViews();
    }

    @Override
    protected ChartArgument<PortCounterSourceName> getChartArgument(IPerformanceItem<PortCounterSourceName> item) {
        Object[] sourceNames;
        PortCounterChartArgument arg = new PortCounterChartArgument();
        String name = item.getName();
        arg.setName(name);
        arg.setFullName(item.getFullName());
        arg.setProvider(item.getCurrentProviderName().name());
        if (item.getType() != null) {
            arg.setDataType(item.getType());
        }
        if (item.getHistoryType() != null) {
            arg.setHistoryType(item.getHistoryType());
        }
        if ((sourceNames = (PortCounterSourceName[])item.getSources()) == null || sourceNames.length != 1) {
            throw new RuntimeException("Strange performance item with sources: " + Arrays.toString(sourceNames));
        }
        arg.setSources((PortCounterSourceName[])item.getSources());
        return arg;
    }

    @Override
    protected ChartsView getItemView(IPerformanceItem<PortCounterSourceName> item) {
        if (this.portCounterChartCard != null) {
            return (ChartsView)this.portCounterChartCard.getView();
        }
        return null;
    }

    public ChartsCard getPortCounterChartCard() {
        return this.portCounterChartCard;
    }
}

