/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.TrendSeries;
import com.intel.stl.ui.model.UtilDataset;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PmaNoRespGroupSource;
import com.intel.stl.ui.performance.TopoNoRespGroupSource;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.UtilTrendDataObserver;
import com.intel.stl.ui.performance.observer.VFUtilTrendDataObserver;
import com.intel.stl.ui.performance.provider.CombinedGroupInfoProvider;
import com.intel.stl.ui.performance.provider.CombinedVFInfoProvider;
import com.intel.stl.ui.performance.provider.DataProviderName;
import java.util.List;
import org.jfree.data.time.TimePeriodValuesCollection;

public class BWTrendItem
extends TrendItem<GroupSource> {
    public BWTrendItem() {
        this(100);
    }

    public BWTrendItem(int maxDataPoints) {
        super(STLConstants.K0851_SHORT_BW_TREND.getValue(), STLConstants.K0871_BANDWIDTH_TREND.getValue(), maxDataPoints);
    }

    public BWTrendItem(BWTrendItem item) {
        super(item);
    }

    @Override
    protected void initDataProvider() {
        CombinedGroupInfoProvider provider = new CombinedGroupInfoProvider();
        UtilTrendDataObserver observer = new UtilTrendDataObserver(this){

            @Override
            protected long getValue(UtilStatsBean util) {
                return util.getTotalMBps();
            }
        };
        this.registerDataProvider(DataProviderName.PORT_GROUP, provider, observer);
        CombinedVFInfoProvider vfProvider = new CombinedVFInfoProvider();
        VFUtilTrendDataObserver vfObserver = new VFUtilTrendDataObserver(this){

            @Override
            protected long getValue(UtilStatsBean util) {
                return util.getTotalMBps();
            }
        };
        this.registerDataProvider(DataProviderName.VIRTUAL_FABRIC, vfProvider, vfObserver);
    }

    @Override
    protected TimePeriodValuesCollection createTrendDataset() {
        return new UtilDataset();
    }

    protected List<TrendSeries> createTrendSeries(GroupSource[] series) {
        if (series != null) {
            GroupSource[] newSeries = new GroupSource[series.length * 3];
            int i = 0;
            for (GroupSource gs : series) {
                newSeries[i++] = gs;
                newSeries[i++] = new PmaNoRespGroupSource(gs);
                newSeries[i++] = new TopoNoRespGroupSource(gs);
            }
            series = newSeries;
        }
        return super.createTrendSeries((ISource[])series);
    }

    @Override
    public IPerformanceItem<GroupSource> copy() {
        return new BWTrendItem(this);
    }
}

