/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class HistogramItem
extends AbstractPerformanceItem<GroupSource> {
    protected XYSeriesCollection dataset;
    private final Object copyCritical = new Object();

    public HistogramItem(String shortName, String fullName) {
        this(shortName, fullName, 100);
    }

    public HistogramItem(String shortName, String fullName, int maxDataPoints) {
        super(STLConstants.K0079_HISTOGRAM.getValue(), shortName, fullName, maxDataPoints);
        this.initDataProvider();
        this.initDataset();
    }

    public HistogramItem(HistogramItem item) {
        super(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyDataset(AbstractPerformanceItem<GroupSource> item) {
        try {
            HistogramItem hi = (HistogramItem)item;
            Object object = hi.copyCritical;
            synchronized (object) {
                this.dataset = (XYSeriesCollection)hi.dataset.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    protected void initDataset() {
        this.dataset = this.createHistogramDataset();
    }

    protected XYSeriesCollection createHistogramDataset() {
        return new XYSeriesCollection();
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    protected boolean isJumpable() {
        return false;
    }

    public void updateHistogram(final int[] values, final double range) {
        if (this.dataset == null || values == null || values.length <= 1) {
            return;
        }
        final XYSeries xyseries = new XYSeries((Comparable)((Object)this.name));
        double x = 0.0;
        double step = range / (double)values.length;
        for (int i = 0; i < values.length; ++i) {
            xyseries.add(x, (double)values[i]);
            x += step;
        }
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = HistogramItem.this.copyCritical;
                synchronized (object) {
                    HistogramItem.this.dataset.setNotify(false);
                    HistogramItem.this.dataset.removeAllSeries();
                    HistogramItem.this.dataset.addSeries(xyseries);
                    HistogramItem.this.dataset.setIntervalPositionFactor(0.0);
                    HistogramItem.this.dataset.setIntervalWidth(range / (double)values.length);
                    HistogramItem.this.dataset.setNotify(true);
                }
            }
        });
    }

    @Override
    public void clear() {
        Util.runInEDT(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = HistogramItem.this.copyCritical;
                synchronized (object) {
                    if (HistogramItem.this.dataset != null) {
                        HistogramItem.this.dataset.removeAllSeries();
                    }
                }
            }
        });
    }
}

