/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.item;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.model.HistoryType;
import com.intel.stl.ui.performance.ISource;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.AbstractPerformanceItem;
import com.intel.stl.ui.performance.item.IPerformanceItem;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import com.intel.stl.ui.performance.observer.IDataObserver;
import com.intel.stl.ui.performance.observer.IFieldObserver;
import com.intel.stl.ui.performance.observer.PCDataObserver;
import com.intel.stl.ui.performance.observer.VFPCDataObserver;
import com.intel.stl.ui.performance.provider.DataProviderName;
import com.intel.stl.ui.performance.provider.PortCounterFieldProvider;
import com.intel.stl.ui.performance.provider.VFPortCounterFieldProvider;

public class PCDataItem
extends PortCounterFieldItem {
    public PCDataItem() {
        this(100);
    }

    public PCDataItem(int maxDataPoints) {
        super(STLConstants.K0880_PC_DATA.getValue(), STLConstants.K0880_PC_DATA.getValue(), STLConstants.K0880_PC_DATA.getValue(), maxDataPoints);
    }

    public PCDataItem(PCDataItem item) {
        super(item);
    }

    @Override
    protected void copyPreparation(AbstractPerformanceItem<PortCounterSourceName> item) {
        PortCounterFieldProvider provider = new PortCounterFieldProvider();
        PCDataObserver dataObserver = new PCDataObserver(this);
        this.registerDataProvider(DataProviderName.PORT, provider, dataObserver);
        VFPortCounterFieldProvider vfProvider = new VFPortCounterFieldProvider();
        VFPCDataObserver dataVfObserver = new VFPCDataObserver(this);
        this.registerDataProvider(DataProviderName.VF_PORT, vfProvider, dataVfObserver);
    }

    @Override
    protected void copyDataObserver(AbstractPerformanceItem<PortCounterSourceName> item) {
        IDataObserver<?> curObserver;
        String field = null;
        if (item.getSources() != null) {
            field = ((PortCounterSourceName[])item.getSources())[0].getFieldName();
        }
        if ((curObserver = item.getCurrentObserver()) != null) {
            DataType type = curObserver.getType();
            for (IDataObserver observer : this.observers.values()) {
                observer.setType(type);
                if (field == null) continue;
                if (observer instanceof PCDataObserver) {
                    ((PCDataObserver)observer).setFieldName(field);
                    continue;
                }
                ((VFPCDataObserver)observer).setFieldName(field);
            }
        }
    }

    @Override
    public IPerformanceItem<PortCounterSourceName> copy() {
        return new PCDataItem(this);
    }

    public synchronized void setFieldName(String name) {
        for (PortCounterSourceName sn : (PortCounterSourceName[])this.sourceNames) {
            sn.setFieldName(name);
        }
        for (IDataObserver observer : this.observers.values()) {
            if (!(observer instanceof IFieldObserver)) continue;
            ((IFieldObserver)((Object)observer)).setFieldName(name);
        }
        HistoryType currentType = this.getHistoryType();
        if (currentType != null && currentType != HistoryType.CURRENT) {
            this.setHistoryType(currentType, true);
        }
    }

    public void setSources(PortCounterSourceName[] sourceNames) {
        super.setSources((ISource[])sourceNames);
        if (this.sameSources(sourceNames)) {
            this.onRefresh(null);
            return;
        }
        this.setFieldName(sourceNames[0].getFieldName());
    }
}

