/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.performance.IPortCountersProcessor;
import com.intel.stl.ui.performance.PortCounterSourceName;
import com.intel.stl.ui.performance.item.PortCounterFieldItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import com.intel.stl.ui.performance.observer.IFieldObserver;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PCErrObserver
extends AbstractDataObserver<PortCountersBean, PortCounterFieldItem>
implements IFieldObserver {
    private final Map<String, IPortCountersProcessor> processorMap = new HashMap<String, IPortCountersProcessor>();
    private String field;

    public PCErrObserver(PortCounterFieldItem controller) {
        super(controller);
        this.initProcessorMap();
    }

    private void initProcessorMap() {
        this.processorMap.put(STLConstants.K0519_RX_ERRORS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvErrors();
            }
        });
        this.processorMap.put(STLConstants.K0522_RX_PORT_CONSTRAINT.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvConstraintErrors();
            }
        });
        this.processorMap.put(STLConstants.K0717_REC_SW_REL_ERR.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvSwitchRelayErrors();
            }
        });
        this.processorMap.put(STLConstants.K0520_RX_REMOTE_PHY_ERRORS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvRemotePhysicalErrors();
            }
        });
        this.processorMap.put(STLConstants.K0837_RX_FECN.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvFECN();
            }
        });
        this.processorMap.put(STLConstants.K0838_RX_BECN.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvBECN();
            }
        });
        this.processorMap.put(STLConstants.K0842_RX_BUBBLE.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortRcvBubble();
            }
        });
        this.processorMap.put(STLConstants.K0714_TRAN_DISCARDS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitDiscards();
            }
        });
        this.processorMap.put(STLConstants.K0521_TX_PORT_CONSTRAINT.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitConstraintErrors();
            }
        });
        this.processorMap.put(STLConstants.K0836_TX_WAIT.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitWait();
            }
        });
        this.processorMap.put(STLConstants.K0839_TX_TIME_CONG.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitTimeCong();
            }
        });
        this.processorMap.put(STLConstants.K0840_TX_WASTED_BW.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitWastedBW();
            }
        });
        this.processorMap.put(STLConstants.K0841_TX_WAIT_DATA.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortXmitWaitData();
            }
        });
        this.processorMap.put(STLConstants.K0718_LOCAL_LINK_INTEG_ERR.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getLocalLinkIntegrityErrors();
            }
        });
        this.processorMap.put(STLConstants.K0720_FM_CONFIG_ERR.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getFmConfigErrors();
            }
        });
        this.processorMap.put(STLConstants.K0719_EXCESS_BUFF_OVERRUNS.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getExcessiveBufferOverruns();
            }
        });
        this.processorMap.put(STLConstants.K0835_SW_PORT_CONG.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getSwPortCongestion();
            }
        });
        this.processorMap.put(STLConstants.K0843_MARK_FECN.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getPortMarkFECN();
            }
        });
        this.processorMap.put(STLConstants.K0517_LINK_RECOVERIES.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getLinkErrorRecovery();
            }
        });
        this.processorMap.put(STLConstants.K0518_LINK_DOWN.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getLinkDowned();
            }
        });
        this.processorMap.put(STLConstants.K0716_UNCORR_ERR.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getUncorrectableErrors();
            }
        });
        this.processorMap.put(STLConstants.K2068_LINK_QUALITY.getValue(), new IPortCountersProcessor(){

            @Override
            public long getValue(PortCountersBean bean) {
                return bean.getLinkQualityIndicator();
            }
        });
    }

    @Override
    public synchronized void processData(PortCountersBean bean) {
        IPortCountersProcessor processor;
        if (bean == null) {
            return;
        }
        PortCounterSourceName sourceName = new PortCounterSourceName(bean.getNodeLid(), bean.getPortNumber(), this.field);
        Date time = bean.getTimestampDate();
        int interval = bean.getImageInterval();
        if (this.field != null && (processor = this.processorMap.get(this.field)) != null) {
            ((PortCounterFieldItem)this.controller).updateTrend((double)processor.getValue(bean), time, interval, sourceName);
        }
    }

    @Override
    public synchronized void setFieldName(String name) {
        this.field = name;
    }
}

