/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.observer;

import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.VFInfoBean;
import com.intel.stl.ui.model.DataType;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.item.TrendItem;
import com.intel.stl.ui.performance.observer.AbstractDataObserver;
import java.util.Date;

public abstract class VFErrorDataObserver
extends AbstractDataObserver<VFInfoBean[], TrendItem<GroupSource>> {
    public VFErrorDataObserver(TrendItem<GroupSource> controller) {
        this(controller, DataType.ALL);
    }

    public VFErrorDataObserver(TrendItem<GroupSource> controller, DataType type) {
        super(controller, type);
    }

    @Override
    public void processData(VFInfoBean[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        for (VFInfoBean bean : data) {
            if (bean == null) continue;
            Date time = bean.getTimestampDate();
            int interval = bean.getImageInterval();
            CategoryStatBean[] errors = this.getCategoryStatBeans(bean, this.type);
            long value = 0L;
            for (CategoryStatBean error : errors) {
                value += this.getValue(error);
            }
            GroupSource sourceName = new GroupSource(bean.getVfName());
            ((TrendItem)this.controller).updateTrend(value, time, interval, sourceName);
        }
    }

    protected abstract long getValue(CategoryStatBean var1);
}

