/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.performance.provider;

import com.intel.stl.api.performance.FocusPortsRspBean;
import com.intel.stl.api.subnet.Selection;
import com.intel.stl.ui.performance.GroupSource;
import com.intel.stl.ui.performance.provider.SimpleDataProvider;
import com.intel.stl.ui.publisher.ICallback;
import com.intel.stl.ui.publisher.Task;
import com.intel.stl.ui.publisher.subscriber.FocusPortCounterSubscriber;
import com.intel.stl.ui.publisher.subscriber.SubscriberType;
import java.util.List;
import java.util.concurrent.Future;

public class FocusPortProvider
extends SimpleDataProvider<List<FocusPortsRspBean>, GroupSource> {
    private final Selection selection;
    private final int range;

    public FocusPortProvider(Selection selection, int range) {
        this.selection = selection;
        this.range = range;
    }

    @Override
    protected List<FocusPortsRspBean> refresh(GroupSource sourceName) {
        return this.scheduler.getPerformanceApi().getFocusPorts(sourceName.getGroup(), this.selection, this.range);
    }

    @Override
    protected Task<List<FocusPortsRspBean>> registerTask(GroupSource sourceName, ICallback<List<FocusPortsRspBean>> callback) {
        FocusPortCounterSubscriber focusPortCounterSubscriber = (FocusPortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.FOCUS_PORTS);
        return focusPortCounterSubscriber.registerFocusPorts(sourceName.getGroup(), this.selection, this.range, callback);
    }

    @Override
    protected void deregisterTask(Task<List<FocusPortsRspBean>> task, ICallback<List<FocusPortsRspBean>> callback) {
        FocusPortCounterSubscriber focusPortCounterSubscriber = (FocusPortCounterSubscriber)this.scheduler.getSubscriber(SubscriberType.FOCUS_PORTS);
        focusPortCounterSubscriber.deregisterFocusPorts(task, callback);
    }

    @Override
    protected Future<Void> initHistory(GroupSource sourceName, ICallback<List<FocusPortsRspBean>[]> callback) {
        throw new UnsupportedOperationException();
    }
}

