/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.publisher;

import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.publisher.CancellableCall;
import com.intel.stl.ui.publisher.ICallback;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTaskManager {
    private static final Logger log = LoggerFactory.getLogger(SingleTaskManager.class);
    private static final boolean DEBUG = false;
    private SwingWorker<?, ?> worker;
    private boolean mayInterruptIfRunning = true;

    public boolean isMayInterruptIfRunning() {
        return this.mayInterruptIfRunning;
    }

    public void setMayInterruptIfRunning(boolean mayInterruptIfRunning) {
        this.mayInterruptIfRunning = mayInterruptIfRunning;
    }

    public synchronized <V> void submit(final CancellableCall<V> caller, final ICallback<V> callback) {
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(this.mayInterruptIfRunning);
        }
        this.worker = new SwingWorker<V, Void>(){

            @Override
            protected V doInBackground() throws Exception {
                if (this.isCancelled()) {
                    log.info("Cancelled task caller " + caller + " callback " + callback);
                    return null;
                }
                if (caller != null) {
                    Object res = caller.call();
                    return res;
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    Object result = this.get();
                    if (callback != null) {
                        callback.onDone(result);
                    }
                }
                catch (InterruptedException result) {
                }
                catch (CancellationException e) {
                    log.info("Cancelled task caller " + caller + " callback " + callback);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof CancellationException)) {
                        e.printStackTrace();
                        e.getCause().printStackTrace();
                        if (callback != null) {
                            callback.onError(e.getCause());
                        }
                    }
                }
                finally {
                    if (callback != null) {
                        callback.onFinally();
                    }
                }
            }
        };
        final ICancelIndicator indicator = caller.getCancelIndicator();
        caller.setCancelIndicator(new ICancelIndicator(){

            @Override
            public boolean isCancelled() {
                return SingleTaskManager.this.worker.isCancelled() || indicator != null && indicator.isCancelled();
            }
        });
        this.worker.execute();
    }
}

