/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.wizards.impl.preferences;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.wizards.impl.IMultinetWizardListener;
import com.intel.stl.ui.wizards.impl.IMultinetWizardTask;
import com.intel.stl.ui.wizards.impl.IWizardListener;
import com.intel.stl.ui.wizards.impl.InteractionType;
import com.intel.stl.ui.wizards.impl.WizardValidationException;
import com.intel.stl.ui.wizards.impl.preferences.PreferencesInputValidator;
import com.intel.stl.ui.wizards.impl.preferences.PreferencesValidatorError;
import com.intel.stl.ui.wizards.model.IModelChangeListener;
import com.intel.stl.ui.wizards.model.IWizardModel;
import com.intel.stl.ui.wizards.model.MultinetWizardModel;
import com.intel.stl.ui.wizards.model.preferences.PreferencesModel;
import com.intel.stl.ui.wizards.view.preferences.PreferencesWizardView;
import javax.swing.JComponent;

public class PreferencesWizardController
implements IMultinetWizardTask,
IModelChangeListener<IWizardModel> {
    private final PreferencesWizardView view;
    private PreferencesModel preferencesModel;
    private IWizardListener wizardController;
    private IMultinetWizardListener multinetWizardController;
    private boolean done;
    private PreferencesInputValidator validator;
    private boolean firstPass = true;
    private boolean connectable;

    public PreferencesWizardController(PreferencesWizardView view) {
        this.view = view;
    }

    public PreferencesWizardController(PreferencesWizardView view, PreferencesModel preferencesModel) {
        this(view);
        view.setDirty(false);
        this.preferencesModel = preferencesModel;
    }

    @Override
    public String getName() {
        return STLConstants.K3005_PREFERENCES.getValue();
    }

    @Override
    public JComponent getView() {
        return this.view;
    }

    @Override
    public void init() {
        this.validator = PreferencesInputValidator.getInstance();
        if (this.firstPass || this.multinetWizardController.isNewWizard()) {
            this.view.resetPanel();
        }
        this.firstPass = false;
        this.view.setDirty(false);
        this.done = false;
    }

    @Override
    public void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateUserEntry() throws WizardValidationException {
        boolean success = false;
        int sweepInterval = 0;
        if (!this.connectable) {
            PreferencesValidatorError error = PreferencesValidatorError.UNABLE_TO_VALIDATE;
            throw new WizardValidationException(error.getLabel());
        }
        try {
            PMConfigBean pmConfig = null;
            pmConfig = this.multinetWizardController.getPMConfig();
            if (pmConfig != null) {
                sweepInterval = pmConfig.getSweepInterval();
            }
        }
        catch (ConfigurationException pmConfig) {
        }
        catch (Exception e) {
            Util.showError(this.view, e);
            return false;
        }
        this.updateModel();
        int errorCode = this.validator.validate(this.preferencesModel, sweepInterval);
        if (errorCode != PreferencesValidatorError.OK.getId()) {
            this.view.logMessage(PreferencesValidatorError.getValue(errorCode));
            IMessage message = PreferencesValidatorError.getMessage(errorCode);
            if (message == null) throw new WizardValidationException();
            throw new WizardValidationException(message, PreferencesValidatorError.getData(errorCode));
        }
        success = true;
        if (!success) return false;
        if (!this.connectable) return false;
        return true;
    }

    @Override
    public void onPrevious() {
    }

    @Override
    public void onReset() {
        this.view.resetPanel();
        this.view.setDirty(false);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void selectStep(String taskName) {
        this.multinetWizardController.selectStep(taskName);
    }

    @Override
    public boolean isDirty() {
        return this.view.isDirty();
    }

    @Override
    public void setDirty(boolean dirty) {
        this.view.setDirty(dirty);
        this.multinetWizardController.setDirty(dirty);
    }

    @Override
    public void doInteractiveAction(InteractionType action, Object ... data) {
        switch (action) {
            case CHANGE_WIZARDS: {
                if (data == null) {
                    return;
                }
                String taskName = (String)data[0];
                if (taskName == null) break;
                this.onReset();
                this.view.closeStatusPanel();
                this.selectStep(taskName);
                break;
            }
            case SAVE_LOGGING: {
                break;
            }
        }
    }

    @Override
    public void updateModel() {
        this.preferencesModel.setRefreshRate(this.view.getRefreshRate());
        this.preferencesModel.setRefreshRateUnits(this.view.getRefreshRateUnits());
        this.preferencesModel.setTimingWindowInSeconds(this.view.getTimeWindowInSeconds());
        this.preferencesModel.setNumWorstNodes(this.view.getNumWorstNodes());
        this.preferencesModel.setMailRecipients(this.view.getEmailList());
    }

    @Override
    public void promoteModel(MultinetWizardModel topModel) {
        topModel.setPreferencesModel(this.preferencesModel);
    }

    @Override
    public void onModelChange(IWizardModel m) {
        MultinetWizardModel model = (MultinetWizardModel)m;
        this.view.updateView(model);
    }

    @Override
    public void setWizardController(IMultinetWizardListener controller) {
        this.multinetWizardController = controller;
    }

    @Override
    public void setWizardController(IWizardListener controller) {
        this.wizardController = controller;
    }

    @Override
    public void clear() {
        this.view.clearPanel();
        this.preferencesModel.clear();
    }

    @Override
    public void setConnectable(boolean connectable) {
        this.connectable = connectable;
    }

    @Override
    public boolean isEditValid() {
        return this.view.isEditValid();
    }

    public void onEmailTest(String recipients) {
        this.multinetWizardController.onEmailTest(recipients);
    }
}

