/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.xml;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.xml.ActionName;
import com.intel.stl.xml.ActionType;
import com.intel.stl.xml.EventRuleType;
import com.intel.stl.xml.EventRules;
import com.intel.stl.xml.RuleSeverity;
import com.intel.stl.xml.RuleType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class EventRulesAdapter
extends XmlAdapter<EventRules, List<EventRule>> {
    public List<EventRule> unmarshal(EventRules rules) throws Exception {
        ArrayList<EventRule> eventRulesList = new ArrayList<EventRule>();
        for (EventRuleType rule : rules.getEventRuleTypes()) {
            ArrayList<EventRuleAction> eventActions = new ArrayList<EventRuleAction>();
            for (ActionType action : rule.getActions()) {
                eventActions.add(EventRuleAction.getEventAction(action.getName().name()));
            }
            eventRulesList.add(new EventRule(EventType.getEventType(rule.getType().name()), NoticeSeverity.getNoticeSeverity(rule.getSeverity().name()), eventActions));
        }
        return eventRulesList;
    }

    public EventRules marshal(List<EventRule> eventRulesList) throws Exception {
        EventRules eventRules = new EventRules();
        List<EventRuleType> eventTypeList = eventRules.getEventRuleTypes();
        if (eventRulesList != null) {
            for (EventRule rule : eventRulesList) {
                EventRuleType eventType = new EventRuleType();
                eventType.setType(RuleType.fromValue(rule.getEventType().name()));
                eventType.setSeverity(RuleSeverity.fromValue(rule.getEventSeverity().name()));
                ArrayList<ActionType> actionTypes = new ArrayList<ActionType>();
                for (EventRuleAction action : rule.getEventActions()) {
                    ActionType actionType = new ActionType();
                    actionType.setName(ActionName.fromValue(action.name()));
                    actionTypes.add(actionType);
                }
                eventType.setActions(actionTypes);
                eventTypeList.add(eventType);
            }
        }
        return eventRules;
    }
}

