/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.MemoryRAFFile;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactoryOn12;
import com.sun.java.help.search.Utilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;

class RAFFileFactory {
    static RAFFileFactory theFactory;
    private int memoryCacheLimit = 10000;
    private static final boolean debug = false;

    private RAFFileFactory() {
    }

    public static synchronized RAFFileFactory create() {
        if (theFactory == null) {
            theFactory = new RAFFileFactory();
        }
        return theFactory;
    }

    private boolean isFileURL(URL url) {
        return url.getProtocol().equalsIgnoreCase("file");
    }

    public int getMemoryCacheLimit() {
        return this.memoryCacheLimit;
    }

    public void setMemoryCacheLimit(int limit) {
        this.memoryCacheLimit = limit;
    }

    public synchronized RAFFile get(URL url, boolean update) throws IOException {
        RAFFile result = null;
        if (this.isFileURL(url)) {
            try {
                String f = url.getFile();
                f = Utilities.URLDecoder(f);
                result = new RAFFile(f, update);
                RAFFileFactory.debug("Opened Dict file with file protocol:" + f);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = RAFFileFactory.createLocalRAFFile(url);
        }
        if (result == null) {
            throw new FileNotFoundException(url.toString());
        }
        return result;
    }

    private static RAFFile createLocalRAFFile(URL url) throws IOException {
        RAFFile result = null;
        URLConnection connection = url.openConnection();
        try {
            Class[] types = new Class[]{};
            Method m = URLConnection.class.getMethod("getPermission", types);
            result = RAFFileFactoryOn12.get(connection);
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (result == null) {
            result = new MemoryRAFFile(connection);
            RAFFileFactory.debug("Opening a Dict file in Memory");
        }
        return result;
    }

    private static void debug(String msg) {
    }
}

