/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpHistoryModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.event.EventListenerList;
import javax.help.event.HelpHistoryModelEvent;
import javax.help.event.HelpHistoryModelListener;
import javax.help.event.HelpModelEvent;

public class DefaultHelpHistoryModel
implements HelpHistoryModel {
    protected Vector history = new Vector();
    protected int historyIndex = -1;
    protected HelpModel helpModel;
    protected EventListenerList listenerList = new EventListenerList();
    protected JHelp help;
    private static boolean debug = false;

    public DefaultHelpHistoryModel(JHelp help) {
        this.help = help;
        if (help != null) {
            this.setHelpModel(help.getModel());
        }
    }

    public void setHelpModel(HelpModel model) {
        if (model == this.helpModel) {
            return;
        }
        this.discard();
        if (this.helpModel != null) {
            this.helpModel.removeHelpModelListener(this);
        }
        if (model != null) {
            model.addHelpModelListener(this);
        }
        this.helpModel = model;
    }

    public void removeHelpHistoryModelListener(HelpHistoryModelListener l) {
        this.listenerList.remove(HelpHistoryModelListener.class, l);
    }

    public void addHelpHistoryModelListener(HelpHistoryModelListener l) {
        this.listenerList.add(HelpHistoryModelListener.class, l);
    }

    public void discard() {
        this.history.setSize(0);
        this.historyIndex = -1;
        this.fireHistoryChanged(this, false, false);
    }

    public Vector getHistory() {
        return this.history;
    }

    public void removeLastEntry() {
        int size = this.history.size();
        if (size > 0) {
            this.history.removeElementAt(this.history.size() - 1);
        }
    }

    public int getIndex() {
        return this.historyIndex;
    }

    public void goForward() {
        this.setHistoryEntry(this.historyIndex + 1);
    }

    public void goBack() {
        this.setHistoryEntry(this.historyIndex - 1);
    }

    public Vector getForwardHistory() {
        Vector historyCopy = (Vector)this.history.clone();
        Vector forwardHistory = new Vector();
        int size = historyCopy.size();
        DefaultHelpHistoryModel.debug(" forward size : " + size);
        for (int i = this.historyIndex + 1; i < size; ++i) {
            forwardHistory.addElement(historyCopy.elementAt(i));
        }
        return forwardHistory;
    }

    public Vector getBackwardHistory() {
        Vector backwardHistory = new Vector();
        Vector historyCopy = (Vector)this.history.clone();
        DefaultHelpHistoryModel.debug(" backward size : " + historyCopy.size());
        DefaultHelpHistoryModel.debug(" backward index : " + this.historyIndex);
        if (historyCopy != null) {
            for (int i = 0; i < this.historyIndex; ++i) {
                backwardHistory.addElement(historyCopy.elementAt(i));
            }
        }
        return backwardHistory;
    }

    public void setHistoryEntry(int index) {
        DefaultHelpHistoryModel.debug("setHistoryEntry(" + index + ")");
        if (this.helpModel == null) {
            return;
        }
        if (index < 0 || index >= this.history.size()) {
            this.discard();
            return;
        }
        HelpModelEvent e = (HelpModelEvent)this.history.elementAt(index);
        this.historyIndex = index - 1;
        Map.ID id = e.getID();
        URL url = e.getURL();
        JHelpNavigator navigator = e.getNavigator();
        if (id != null) {
            try {
                DefaultHelpHistoryModel.debug("  setCurrentID" + id);
                this.helpModel.setCurrentID(id, e.getHistoryName(), e.getNavigator());
                if (navigator != null) {
                    this.help.setCurrentNavigator(navigator);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url != null) {
            try {
                DefaultHelpHistoryModel.debug("  setCurrentURL" + url);
                this.helpModel.setCurrentURL(url, e.getHistoryName(), e.getNavigator());
                if (navigator != null) {
                    this.help.setCurrentNavigator(navigator);
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.discard();
    }

    protected void fireHistoryChanged(Object source, boolean previous, boolean next) {
        Object[] listeners = this.listenerList.getListenerList();
        HelpHistoryModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$event$HelpHistoryModelListener == null ? DefaultHelpHistoryModel.class$("javax.help.event.HelpHistoryModelListener") : class$javax$help$event$HelpHistoryModelListener)) continue;
            if (e == null) {
                e = new HelpHistoryModelEvent(source, previous, next);
            }
            DefaultHelpHistoryModel.debug("fireHistoryChanged: ");
            DefaultHelpHistoryModel.debug("  " + listeners[i + 1]);
            DefaultHelpHistoryModel.debug("  previous=" + e.isPrevious() + " next=" + e.isNext());
            ((HelpHistoryModelListener)listeners[i + 1]).historyChanged(e);
        }
    }

    public void idChanged(HelpModelEvent e) {
        DefaultHelpHistoryModel.debug("idChanged(" + e + ")");
        DefaultHelpHistoryModel.debug("  historyIndex==" + this.historyIndex);
        DefaultHelpHistoryModel.debug("  history.size==" + this.history.size());
        if (this.historyIndex == this.history.size() - 1) {
            this.history.addElement(e);
            ++this.historyIndex;
            this.fireHistoryChanged(this, this.historyIndex > 0, this.historyIndex < this.history.size() - 1);
            return;
        }
        if (this.historyIndex >= -1 && this.historyIndex < this.history.size() - 1) {
            ++this.historyIndex;
            HelpModelEvent h = (HelpModelEvent)this.history.elementAt(this.historyIndex);
            if (h == null) {
                this.discard();
                return;
            }
            if (h.getID() != null && e.getID() != null && h.getID().equals(e.getID())) {
                this.fireHistoryChanged(this, this.historyIndex > 0, this.historyIndex < this.history.size() - 1);
                return;
            }
            if (h.getURL() != null && e.getURL() != null && h.getURL().sameFile(e.getURL())) {
                this.fireHistoryChanged(this, this.historyIndex > 0, this.historyIndex < this.history.size() - 1);
                return;
            }
            this.history.setSize(this.historyIndex);
            this.history.addElement(e);
            this.fireHistoryChanged(this, this.historyIndex > 0, this.historyIndex < this.history.size() - 1);
        }
    }

    public void removeHelpSet(HelpSet hs) {
        Enumeration e = this.history.elements();
        DefaultHelpHistoryModel.debug(" size before " + this.history.size());
        if (debug) {
            System.err.println("before : ");
            for (int j = 0; j < this.history.size(); ++j) {
                System.err.println(((HelpModelEvent)this.history.elementAt(j)).getID());
            }
        }
        int size = this.history.size();
        Vector newHistory = new Vector();
        int index = this.historyIndex;
        for (int i = 0; i < size; ++i) {
            Map.ID idcan;
            HelpModelEvent evt = (HelpModelEvent)this.history.elementAt(i);
            Map.ID id = evt.getID();
            DefaultHelpHistoryModel.debug(" update id " + id);
            URL url = evt.getURL();
            DefaultHelpHistoryModel.debug(" update url " + url);
            if (id != null && id.hs != hs) {
                DefaultHelpHistoryModel.debug(" remain - " + id);
                newHistory.addElement(this.history.elementAt(i));
                continue;
            }
            if (url == null || (idcan = hs.getCombinedMap().getIDFromURL(url)) != null) continue;
            DefaultHelpHistoryModel.debug(" remain > " + idcan);
            newHistory.addElement(this.history.elementAt(i));
        }
        this.history = newHistory;
        this.historyIndex = this.history.size() - 1;
        DefaultHelpHistoryModel.debug(" size after " + this.history.size());
        if (debug) {
            System.err.println("after : ");
            for (int j = 0; j < this.history.size(); ++j) {
                System.err.println(((HelpModelEvent)this.history.elementAt(j)).getID());
            }
        }
        this.setHistoryEntry(this.historyIndex);
    }

    protected HelpModel getModel() {
        return this.helpModel;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicHelpUI: " + str);
        }
    }
}

