/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.TitleAnchor;
import com.orsoncharts.table.GridElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.util.Anchor2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;

public class TitleUtils {
    public static final Font DEFAULT_TITLE_FONT = new Font("Dialog", 1, 20);
    public static final Paint DEFAULT_TITLE_PAINT = Color.BLACK;
    public static final Font DEFAULT_SUBTITLE_FONT = new Font("Dialog", 0, 12);

    private TitleUtils() {
    }

    public static TableElement createTitle(String title) {
        return TitleUtils.createTitle(title, null);
    }

    public static TableElement createTitle(String title, String subtitle) {
        return TitleUtils.createTitle(title, subtitle, TitleAnchor.TOP_LEFT);
    }

    public static TableElement createTitle(String title, String subtitle, Anchor2D anchor) {
        HAlign alignment = HAlign.LEFT;
        if (anchor.getRefPt().isHorizontalCenter()) {
            alignment = HAlign.CENTER;
        } else if (anchor.getRefPt().isRight()) {
            alignment = HAlign.RIGHT;
        }
        return TitleUtils.createTitle(title, DEFAULT_TITLE_FONT, subtitle, DEFAULT_SUBTITLE_FONT, alignment);
    }

    public static TableElement createTitle(String title, Font titleFont, String subtitle, Font subtitleFont, HAlign alignment) {
        TextElement t = new TextElement(title, titleFont);
        t.setHorizontalAligment(alignment);
        t.setForegroundPaint(DEFAULT_TITLE_PAINT);
        if (subtitle == null) {
            return t;
        }
        GridElement compositeTitle = new GridElement();
        Font stf = subtitleFont != null ? subtitleFont : DEFAULT_SUBTITLE_FONT;
        TextElement st = new TextElement(subtitle, stf);
        st.setHorizontalAligment(alignment);
        st.setForegroundPaint(DEFAULT_TITLE_PAINT);
        compositeTitle.setElement(t, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        compositeTitle.setElement(st, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        return compositeTitle;
    }
}

