/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.Range;
import com.orsoncharts.data.Values;
import com.orsoncharts.data.Values3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.util.ArgChecks;

public class DataUtils {
    private DataUtils() {
    }

    public static double total(Values<Number> values) {
        double result = 0.0;
        for (int i = 0; i < values.getItemCount(); ++i) {
            Number n = values.getValue(i);
            if (n == null) continue;
            result += n.doubleValue();
        }
        return result;
    }

    public static Range findValueRange(Values3D data) {
        return DataUtils.findValueRange(data, Double.NaN);
    }

    public static Range findValueRange(Values3D data, double base) {
        ArgChecks.nullNotPermitted(data, "data");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int series = 0; series < data.getSeriesCount(); ++series) {
            for (int row = 0; row < data.getRowCount(); ++row) {
                for (int col = 0; col < data.getColumnCount(); ++col) {
                    double d = data.getDoubleValue(series, row, col);
                    if (Double.isNaN(d)) continue;
                    min = Math.min(min, d);
                    max = Math.max(max, d);
                }
            }
        }
        if (!Double.isNaN(base)) {
            min = Math.min(min, base);
            max = Math.max(max, base);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findStackedValueRange(Values3D data) {
        return DataUtils.findStackedValueRange(data, 0.0);
    }

    public static Range findStackedValueRange(Values3D data, double base) {
        ArgChecks.nullNotPermitted(data, "data");
        double min = base;
        double max = base;
        int seriesCount = data.getSeriesCount();
        for (int row = 0; row < data.getRowCount(); ++row) {
            for (int col = 0; col < data.getColumnCount(); ++col) {
                double[] total = DataUtils.stackSubTotal(data, base, seriesCount, row, col);
                min = Math.min(min, total[0]);
                max = Math.max(max, total[1]);
            }
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static double[] stackSubTotal(Values3D data, double base, int series, int row, int column) {
        double neg = base;
        double pos = base;
        for (int s = 0; s < series; ++s) {
            double v = data.getDoubleValue(s, row, column);
            if (v > 0.0) {
                pos += v;
                continue;
            }
            if (!(v < 0.0)) continue;
            neg -= v;
        }
        return new double[]{neg, pos};
    }

    public static Range findXRange(XYZDataset dataset) {
        return DataUtils.findXRange(dataset, Double.NaN);
    }

    public static Range findXRange(XYZDataset dataset, double inc) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double x = dataset.getX(s, i);
                if (Double.isNaN(x)) continue;
                min = Math.min(x, min);
                max = Math.max(x, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset, Double.NaN);
    }

    public static Range findYRange(XYZDataset dataset, double inc) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double y = dataset.getY(s, i);
                if (Double.isNaN(y)) continue;
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }

    public static Range findZRange(XYZDataset dataset) {
        return DataUtils.findZRange(dataset, Double.NaN);
    }

    public static Range findZRange(XYZDataset dataset, double inc) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int s = 0; s < dataset.getSeriesCount(); ++s) {
            for (int i = 0; i < dataset.getItemCount(s); ++i) {
                double z = dataset.getZ(s, i);
                if (Double.isNaN(z)) continue;
                min = Math.min(z, min);
                max = Math.max(z, max);
            }
        }
        if (!Double.isNaN(inc)) {
            min = Math.min(inc, min);
            max = Math.max(inc, max);
        }
        if (min <= max) {
            return new Range(min, max);
        }
        return null;
    }
}

