/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.data.AbstractDataset3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XYZSeriesCollection
extends AbstractDataset3D
implements XYZDataset,
Serializable {
    private List<XYZSeries> series = new ArrayList<XYZSeries>();

    @Override
    public int getSeriesCount() {
        return this.series.size();
    }

    @Override
    public int getSeriesIndex(Comparable key) {
        ArgChecks.nullNotPermitted(key, "key");
        return this.getSeriesKeys().indexOf(key);
    }

    @Override
    public List<Comparable> getSeriesKeys() {
        ArrayList<Comparable> result = new ArrayList<Comparable>();
        for (XYZSeries s : this.series) {
            result.add(s.getKey());
        }
        return result;
    }

    public void add(XYZSeries series) {
        ArgChecks.nullNotPermitted(series, "series");
        if (this.getSeriesIndex(series.getKey()) >= 0) {
            throw new IllegalArgumentException("Another series with the same key already exists within the collection.");
        }
        this.series.add(series);
    }

    @Override
    public int getItemCount(int seriesIndex) {
        ArgChecks.nullNotPermitted(this, null);
        XYZSeries s = this.series.get(seriesIndex);
        return s.getItemCount();
    }

    @Override
    public double getX(int seriesIndex, int itemIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getXValue(itemIndex);
    }

    @Override
    public double getY(int seriesIndex, int itemIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getYValue(itemIndex);
    }

    @Override
    public double getZ(int seriesIndex, int itemIndex) {
        XYZSeries s = this.series.get(seriesIndex);
        return s.getZValue(itemIndex);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZSeriesCollection)) {
            return false;
        }
        XYZSeriesCollection that = (XYZSeriesCollection)obj;
        return this.series.equals(that.series);
    }
}

