/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class World {
    private double sunX;
    private double sunY;
    private double sunZ;
    private List<Object3D> objects;

    public World() {
        this.sunY = this.sunX = -1.0 / Math.sqrt(3.0);
        this.sunZ = -this.sunY;
        this.objects = new ArrayList<Object3D>();
    }

    public double getSunX() {
        return this.sunX;
    }

    public double getSunY() {
        return this.sunY;
    }

    public double getSunZ() {
        return this.sunZ;
    }

    public void add(Object3D object) {
        ArgChecks.nullNotPermitted(object, "object");
        this.objects.add(object);
    }

    public void addAll(Collection<Object3D> objects) {
        ArgChecks.nullNotPermitted(objects, "objects");
        for (Object3D object : objects) {
            this.add(object);
        }
    }

    public int getVertexCount() {
        int count = 0;
        for (Object3D object : this.objects) {
            count += object.getVertexCount();
        }
        return count;
    }

    public Point3D[] calculateEyeCoordinates(ViewPoint3D vp) {
        Point3D[] result = new Point3D[this.getVertexCount()];
        int index = 0;
        for (Object3D object : this.objects) {
            Point3D[] vertices = object.calculateEyeCoordinates(vp);
            System.arraycopy(vertices, 0, result, index, vertices.length);
            index += vertices.length;
        }
        return result;
    }

    public Point2D[] calculateProjectedPoints(ViewPoint3D vp, float d) {
        Point2D[] result = new Point2D[this.getVertexCount()];
        int index = 0;
        for (Object3D object : this.objects) {
            Point2D[] pts = object.calculateProjectedPoints(vp, d);
            System.arraycopy(pts, 0, result, index, pts.length);
            index += pts.length;
        }
        return result;
    }

    public List<Face> getFaces() {
        ArrayList<Face> result = new ArrayList<Face>();
        int offset = 0;
        for (Object3D object : this.objects) {
            for (Face f : object.getFaces()) {
                f.setOffset(offset);
            }
            offset += object.getVertexCount();
            result.addAll(object.getFaces());
        }
        return result;
    }
}

