/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d.swing;

import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Drawable3D;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JPanel;

public class Panel3D
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Drawable3D drawable;
    private float minViewingDistance;
    private double margin;
    private double panIncrement;
    private double rotateIncrement;
    private double rollIncrement;
    private Point lastClickPoint;
    private Point lastMovePoint;
    private Offset2D offsetAtMousePressed;

    public Panel3D(Drawable3D drawable) {
        super(new BorderLayout());
        ArgChecks.nullNotPermitted(drawable, "drawable");
        this.drawable = drawable;
        this.margin = 0.25;
        this.minViewingDistance = (float)drawable.getDimensions().getDiagonalLength();
        this.panIncrement = 0.05235987755982988;
        this.rotateIncrement = 0.05235987755982988;
        this.rollIncrement = 0.05235987755982988;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public Drawable3D getDrawable() {
        return this.drawable;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public float getMinViewingDistance() {
        return this.minViewingDistance;
    }

    public double getPanIncrement() {
        return this.panIncrement;
    }

    public void setPanIncrement(double panIncrement) {
        this.panIncrement = panIncrement;
    }

    public double getRotateIncrement() {
        return this.rotateIncrement;
    }

    public void setRotateIncrement(double rotateIncrement) {
        this.rotateIncrement = rotateIncrement;
    }

    public double getRollIncrement() {
        return this.rollIncrement;
    }

    public void setRollIncrement(double rollIncrement) {
        this.rollIncrement = rollIncrement;
    }

    public ViewPoint3D getViewPoint() {
        return this.drawable.getViewPoint();
    }

    public void setViewPoint(ViewPoint3D vp) {
        ArgChecks.nullNotPermitted(vp, "vp");
        this.drawable.setViewPoint(vp);
        this.repaint();
    }

    protected Point getLastClickPoint() {
        return this.lastClickPoint;
    }

    public void panLeftRight(double angle) {
        this.drawable.getViewPoint().panLeftRight(angle);
        this.repaint();
    }

    public void zoomToFit() {
        this.zoomToFit(this.getSize());
    }

    public void zoomToFit(Dimension2D size) {
        int w = (int)(size.getWidth() * (1.0 - this.margin));
        int h = (int)(size.getHeight() * (1.0 - this.margin));
        Dimension target = new Dimension(w, h);
        Dimension3D d3d = this.drawable.getDimensions();
        float distance = this.drawable.getViewPoint().optimalDistance(target, d3d);
        this.drawable.getViewPoint().setRho(distance);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform saved = g2.getTransform();
        Dimension size = this.getSize();
        Rectangle drawArea = new Rectangle(size.width, size.height);
        this.drawable.draw(g2, drawArea);
        g2.setTransform(saved);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMovePoint = this.lastClickPoint = e.getPoint();
        this.offsetAtMousePressed = this.drawable.getTranslate2D();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isAltDown()) {
            Point currPt = e.getPoint();
            Offset2D offset = this.offsetAtMousePressed;
            Point lastPt = this.getLastClickPoint();
            double dx = offset.getDX() + (double)(currPt.x - lastPt.x);
            double dy = offset.getDY() + (double)(currPt.y - lastPt.y);
            this.drawable.setTranslate2D(new Offset2D(dx, dy));
        } else {
            Point currPt = e.getPoint();
            int dx = currPt.x - this.lastMovePoint.x;
            int dy = currPt.y - this.lastMovePoint.y;
            this.lastMovePoint = currPt;
            this.drawable.getViewPoint().panLeftRight((double)(-dx) * Math.PI / 120.0);
            this.drawable.getViewPoint().moveUpDown((double)(-dy) * Math.PI / 120.0);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        float units = mwe.getUnitsToScroll();
        double valRho = Math.max((double)this.minViewingDistance, this.drawable.getViewPoint().getRho() + (double)units);
        this.drawable.getViewPoint().setRho(valRho);
        this.repaint();
    }

    boolean isOrsonPDFAvailable() {
        Class<?> pdfDocumentClass = null;
        try {
            pdfDocumentClass = Class.forName("com.orsonpdf.PDFDocument");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return pdfDocumentClass != null;
    }

    void writeAsPDF(File file, int w, int h) {
        if (!this.isOrsonPDFAvailable()) {
            throw new IllegalStateException("OrsonPDF is not present on the classpath.");
        }
        ArgChecks.nullNotPermitted(file, "file");
        try {
            Class<?> pdfDocClass = Class.forName("com.orsonpdf.PDFDocument");
            Object pdfDoc = pdfDocClass.newInstance();
            Method m = pdfDocClass.getMethod("createPage", Rectangle2D.class);
            Rectangle rect = new Rectangle(w, h);
            Object page = m.invoke(pdfDoc, rect);
            Method m2 = page.getClass().getMethod("getGraphics2D", new Class[0]);
            Graphics2D g2 = (Graphics2D)m2.invoke(page, new Object[0]);
            Rectangle2D.Double drawArea = new Rectangle2D.Double(0.0, 0.0, w, h);
            this.drawable.draw(g2, drawArea);
            Method m3 = pdfDocClass.getMethod("writeToFile", File.class);
            m3.invoke(pdfDoc, file);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    boolean isJFreeSVGAvailable() {
        Class<?> svgClass = null;
        try {
            svgClass = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return svgClass != null;
    }

    void writeAsSVG(File file, int w, int h) {
        if (!this.isJFreeSVGAvailable()) {
            throw new IllegalStateException("JFreeSVG is not present on the classpath.");
        }
        ArgChecks.nullNotPermitted(file, "file");
        try {
            Class<?> svg2Class = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            Constructor<?> c1 = svg2Class.getConstructor(Integer.TYPE, Integer.TYPE);
            Graphics2D svg2 = (Graphics2D)c1.newInstance(w, h);
            Rectangle2D.Double drawArea = new Rectangle2D.Double(0.0, 0.0, w, h);
            this.drawable.draw(svg2, drawArea);
            Class<?> svgUtilsClass = Class.forName("org.jfree.graphics2d.svg.SVGUtils");
            Method m1 = svg2Class.getMethod("getSVGElement", null);
            String element = (String)m1.invoke((Object)svg2, (Object[])null);
            Method m2 = svgUtilsClass.getMethod("writeToSVG", File.class, String.class);
            m2.invoke(svgUtilsClass, file, element);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }
}

