/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d.swing;

import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ZoomInAction
extends AbstractAction {
    private Panel3D panel;

    public ZoomInAction(Panel3D panel, boolean fontAwesome) {
        super("\uf00e");
        ArgChecks.nullNotPermitted(panel, "panel");
        this.panel = panel;
        if (!fontAwesome) {
            this.putValue("Name", "Zoom In");
        }
        this.putValue("ActionCommandKey", "ZOOM_IN");
        this.putValue("ShortDescription", "Zoom in");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        float delta = 5.0f;
        ViewPoint3D viewPt = this.panel.getViewPoint();
        double valRho = Math.max((double)this.panel.getMinViewingDistance(), viewPt.getRho() - (double)delta);
        this.panel.getViewPoint().setRho(valRho);
        this.panel.repaint();
    }
}

