/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Range;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.Values3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.AbstractCategoryRenderer3D;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;

public class AreaRenderer3D
extends AbstractCategoryRenderer3D
implements Serializable {
    private double base = 0.0;
    private Color baseColor = null;
    private double depth = 0.6;

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.fireChangeEvent();
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color color) {
        this.baseColor = color;
        this.fireChangeEvent();
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.fireChangeEvent();
    }

    @Override
    public Range findValueRange(Values3D data) {
        return DataUtils.findValueRange(data, this.base);
    }

    @Override
    public void composeItem(CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        double y0 = dataset.getDoubleValue(series, row, column);
        if (Double.isNaN(y0)) {
            return;
        }
        CategoryPlot3D plot = this.getPlot();
        CategoryAxis3D xAxis = plot.getColumnAxis();
        CategoryAxis3D zAxis = plot.getRowAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        if (column < dataset.getColumnCount() - 1) {
            double y1 = dataset.getDoubleValue(series, row, column + 1);
            if (Double.isNaN(y1)) {
                return;
            }
            if (!valueAxis.getRange().intersects(this.base, y0) && !valueAxis.getRange().intersects(this.base, y1)) {
                return;
            }
            if (!this.isBaselineCrossed(y0, y1, this.base)) {
                this.composeItemWithoutCrossing(y0, y1, dataset, series, row, column, world, dimensions, xOffset, yOffset, zOffset);
            } else {
                double x0 = xAxis.getCategoryValue(dataset.getColumnKey(column));
                double x1 = xAxis.getCategoryValue(dataset.getColumnKey(column + 1));
                double ww = dimensions.getWidth();
                double hh = dimensions.getHeight();
                double wx0 = xAxis.translateToWorld(x0, ww) + xOffset;
                double wx1 = xAxis.translateToWorld(x1, ww) + xOffset;
                double wy0 = valueAxis.translateToWorld(y0, hh) + yOffset;
                double wy1 = valueAxis.translateToWorld(y1, hh) + yOffset;
                double wbase = valueAxis.translateToWorld(this.base, hh) + yOffset;
                double wz = zAxis.translateToWorld(zAxis.getCategoryValue(dataset.getRowKey(row)), dimensions.getDepth()) + zOffset;
                double wmin = valueAxis.translateToWorld(valueAxis.getRange().getMin(), hh) + yOffset;
                double wmax = valueAxis.translateToWorld(valueAxis.getRange().getMax(), hh) + yOffset;
                Color color = this.getColorSource().getColor(series, row, column);
                boolean openingFace = column == 0;
                boolean closingFace = column == dataset.getColumnCount() - 2;
                this.composeItemWithCrossing(world, wx0, wy0, wx1, wy1, wbase, wz, new Range(wmin, wmax), color, openingFace, closingFace);
            }
        }
    }

    private boolean isBaselineCrossed(double y0, double y1, double baseline) {
        return y0 > baseline && y1 < baseline || y0 < baseline && y1 > baseline;
    }

    private double fraction(double x, double x0, double x1) {
        double dist = Math.abs(x - x0);
        double length = Math.abs(x1 - x0);
        return dist / length;
    }

    private void composeItemWithoutCrossing(double y0, double y1, CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        boolean positive;
        CategoryPlot3D plot = this.getPlot();
        Color color = this.getColorSource().getColor(series, row, column);
        CategoryAxis3D rowAxis = plot.getRowAxis();
        CategoryAxis3D columnAxis = plot.getColumnAxis();
        ValueAxis3D valueAxis = plot.getValueAxis();
        Comparable rowKey = dataset.getRowKey(row);
        Comparable columnKey = dataset.getColumnKey(column);
        Comparable nextColumnKey = dataset.getColumnKey(column + 1);
        double x0 = columnAxis.getCategoryValue(columnKey);
        double x1 = columnAxis.getCategoryValue(nextColumnKey);
        Range range = valueAxis.getRange();
        double y00 = range.peggedValue(y0);
        double y11 = range.peggedValue(y1);
        double ybb = range.peggedValue(this.base);
        double ww = dimensions.getWidth();
        double hh = dimensions.getHeight();
        boolean bl = positive = y0 > this.base || y1 > this.base;
        if (positive) {
            double x00 = x0;
            if (y0 < range.getMin()) {
                x00 = x0 + (x1 - x0) * this.fraction(y00, y0, y1);
            }
            double x11 = x1;
            if (y1 < range.getMin()) {
                x11 = x1 - (x1 - x0) * this.fraction(y11, y1, y0);
            }
            double wx00 = columnAxis.translateToWorld(x00, ww) + xOffset;
            double wx11 = columnAxis.translateToWorld(x11, ww) + xOffset;
            double wy0 = valueAxis.translateToWorld(y0, hh) + yOffset;
            double wy1 = valueAxis.translateToWorld(y1, hh) + yOffset;
            double wymin = valueAxis.translateToWorld(range.getMin(), hh) + yOffset;
            double wymax = valueAxis.translateToWorld(range.getMax(), hh) + yOffset;
            double wbase = valueAxis.translateToWorld(ybb, hh) + yOffset;
            double wz = rowAxis.translateToWorld(rowAxis.getCategoryValue(rowKey), dimensions.getDepth()) + zOffset;
            world.add(this.createPositiveArea(color, wx00, wy0, wx11, wy1, wbase, wz, new Range(wymin, wymax), column == 0, column == dataset.getColumnCount() - 2));
        } else {
            double wz;
            double x00 = x0;
            if (y0 > range.getMax()) {
                x00 = x0 + (x1 - x0) * this.fraction(y00, y0, y1);
            }
            double x11 = x1;
            if (y1 > range.getMax()) {
                x11 = x1 - (x1 - x0) * this.fraction(y11, y1, y0);
            }
            double wx00 = columnAxis.translateToWorld(x00, ww) + xOffset;
            double wx11 = columnAxis.translateToWorld(x11, ww) + xOffset;
            double wy0 = valueAxis.translateToWorld(y0, hh) + yOffset;
            double wy1 = valueAxis.translateToWorld(y1, hh) + yOffset;
            double wymin = valueAxis.translateToWorld(range.getMin(), hh) + yOffset;
            double wymax = valueAxis.translateToWorld(range.getMax(), hh) + yOffset;
            double wbase = valueAxis.translateToWorld(ybb, hh) + yOffset;
            Object3D neg = this.createNegativeArea(color, wx00, wy0, wx11, wy1, wbase, wz = rowAxis.translateToWorld(rowAxis.getCategoryValue(rowKey), dimensions.getDepth()) + zOffset, new Range(wymin, wymax), column == 0, column == dataset.getColumnCount() - 2);
            if (neg != null) {
                world.add(neg);
            }
        }
    }

    private void composeItemWithCrossing(World world, double wx0, double wy0, double wx1, double wy1, double wbase, double wz, Range range, Color color, boolean openingFace, boolean closingFace) {
        double ydelta = Math.abs(wy1 - wy0);
        double factor = 0.0;
        if (ydelta != 0.0) {
            factor = Math.abs(wy0 - wbase) / ydelta;
        }
        double xcross = wx0 + factor * (wx1 - wx0);
        if (wy0 > wbase) {
            world.add(this.createPositiveArea(color, wx0, wy0, xcross, wbase, wbase, wz, range, openingFace, closingFace));
            Object3D neg = this.createNegativeArea(color, xcross, wbase, wx1, wy1, wbase, wz, range, openingFace, closingFace);
            if (neg != null) {
                world.add(neg);
            }
        } else {
            Object3D neg = this.createNegativeArea(color, wx0, wy0, xcross, wbase, wbase, wz, range, openingFace, closingFace);
            if (neg != null) {
                world.add(neg);
            }
            world.add(this.createPositiveArea(color, xcross, wbase, wx1, wy1, wbase, wz, range, openingFace, closingFace));
        }
    }

    private Object3D createPositiveArea(Color color, double wx0, double wy0, double wx1, double wy1, double wbase, double wz, Range range, boolean openingFace, boolean closingFace) {
        int vertices;
        if (!range.intersects(wy0, wbase) && !range.intersects(wy1, wbase)) {
            return null;
        }
        double wy00 = range.peggedValue(wy0);
        double wy11 = range.peggedValue(wy1);
        double wbb = range.peggedValue(wbase);
        double wx00 = wx0;
        if (wy0 < range.getMin()) {
            wx00 = wx0 + (wx1 - wx0) * this.fraction(wy00, wy0, wy1);
        }
        double wx11 = wx1;
        if (wy1 < range.getMin()) {
            wx11 = wx1 - (wx1 - wx0) * this.fraction(wy11, wy1, wy0);
        }
        double wx22 = Double.NaN;
        boolean p2required = Utils2D.spans(range.getMax(), wy0, wy1);
        if (p2required) {
            wx22 = wx0 + (wx1 - wx0) * this.fraction(range.getMax(), wy0, wy1);
        }
        double delta = this.depth / 2.0;
        Object3D obj = new Object3D();
        obj.addVertex(wx00, wbb, wz - delta);
        obj.addVertex(wx00, wbb, wz + delta);
        boolean leftSide = false;
        if (wy00 != wbb) {
            leftSide = true;
            obj.addVertex(wx00, wy00, wz - delta);
            obj.addVertex(wx00, wy00, wz + delta);
        }
        if (p2required) {
            obj.addVertex(wx22, range.getMax(), wz - delta);
            obj.addVertex(wx22, range.getMax(), wz + delta);
        }
        obj.addVertex(wx11, wy11, wz - delta);
        obj.addVertex(wx11, wy11, wz + delta);
        boolean rightSide = false;
        if (wy11 != wbb) {
            rightSide = true;
            obj.addVertex(wx11, wbb, wz - delta);
            obj.addVertex(wx11, wbb, wz + delta);
        }
        if ((vertices = obj.getVertexCount()) == 10) {
            obj.addFace(new int[]{0, 2, 4, 6, 8}, color, true);
            obj.addFace(new int[]{1, 9, 7, 5, 3}, color, true);
            obj.addFace(new int[]{0, 8, 9, 1}, color, true);
            obj.addFace(new int[]{2, 3, 5, 4}, color, true);
            obj.addFace(new int[]{4, 5, 7, 6}, color, true);
            if (openingFace) {
                obj.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            if (closingFace) {
                obj.addFace(new int[]{6, 7, 9, 8}, color, true);
            }
        } else if (vertices == 8) {
            obj.addFace(new int[]{0, 2, 4, 6}, color, true);
            obj.addFace(new int[]{7, 5, 3, 1}, color, true);
            if (!leftSide) {
                obj.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            obj.addFace(new int[]{2, 3, 5, 4}, color, true);
            if (!rightSide) {
                obj.addFace(new int[]{4, 5, 7, 6}, color, true);
            }
            obj.addFace(new int[]{1, 0, 6, 7}, color, true);
            if (openingFace) {
                obj.addFace(new int[]{0, 1, 3, 2}, color, true);
            }
            if (closingFace) {
                obj.addFace(new int[]{4, 5, 7, 6}, color, true);
            }
        } else if (vertices == 6) {
            obj.addFace(new int[]{0, 2, 4}, color, true);
            obj.addFace(new int[]{5, 3, 1}, color, true);
            if (leftSide) {
                obj.addFace(new int[]{3, 5, 4, 2}, color, true);
                if (openingFace) {
                    obj.addFace(new int[]{0, 1, 3, 2}, color, true);
                }
            } else {
                obj.addFace(new int[]{0, 1, 3, 2}, color, true);
                if (closingFace) {
                    obj.addFace(new int[]{2, 3, 5, 4}, color, true);
                }
            }
            obj.addFace(new int[]{0, 4, 5, 1}, color, true);
        } else {
            obj.addFace(new int[]{0, 1, 3, 2}, color, true);
            obj.addFace(new int[]{2, 3, 1, 0}, color, true);
        }
        return obj;
    }

    private Object3D createNegativeArea(Color color, double wx0, double wy0, double wx1, double wy1, double wbase, double wz, Range range, boolean openingFace, boolean closingFace) {
        int vertices;
        if (!range.intersects(wy0, wbase) && !range.intersects(wy1, wbase)) {
            return null;
        }
        double wy00 = range.peggedValue(wy0);
        double wy11 = range.peggedValue(wy1);
        double wbb = range.peggedValue(wbase);
        double wx00 = wx0;
        if (wy0 > range.getMax()) {
            wx00 = wx0 + (wx1 - wx0) * this.fraction(wy00, wy0, wy1);
        }
        double wx11 = wx1;
        if (wy1 > range.getMax()) {
            wx11 = wx1 - (wx1 - wx0) * this.fraction(wy11, wy1, wy0);
        }
        double wx22 = (wx00 + wx11) / 2.0;
        boolean p2required = Utils2D.spans(range.getMin(), wy0, wy1);
        if (p2required) {
            wx22 = wx0 + (wx1 - wx0) * this.fraction(range.getMin(), wy0, wy1);
        }
        double delta = this.depth / 2.0;
        Object3D obj = new Object3D();
        obj.addVertex(wx00, wbb, wz - delta);
        obj.addVertex(wx00, wbb, wz + delta);
        boolean leftSide = false;
        if (wy00 != wbb) {
            leftSide = true;
            obj.addVertex(wx00, wy00, wz - delta);
            obj.addVertex(wx00, wy00, wz + delta);
        }
        if (p2required) {
            obj.addVertex(wx22, range.getMin(), wz - delta);
            obj.addVertex(wx22, range.getMin(), wz + delta);
        }
        obj.addVertex(wx11, wy11, wz - delta);
        obj.addVertex(wx11, wy11, wz + delta);
        boolean rightSide = false;
        if (wy11 != wbb) {
            obj.addVertex(wx11, wbb, wz - delta);
            obj.addVertex(wx11, wbb, wz + delta);
        }
        if ((vertices = obj.getVertexCount()) == 10) {
            obj.addFace(new int[]{8, 6, 4, 2, 0}, color, true);
            obj.addFace(new int[]{1, 3, 5, 7, 9}, color, true);
            obj.addFace(new int[]{1, 9, 8, 0}, color, true);
            obj.addFace(new int[]{4, 5, 3, 2}, color, true);
            obj.addFace(new int[]{6, 7, 5, 4}, color, true);
            if (openingFace) {
                obj.addFace(new int[]{2, 3, 1, 0}, color, true);
            }
            if (closingFace) {
                obj.addFace(new int[]{8, 9, 7, 6}, color, true);
            }
        } else if (vertices == 8) {
            obj.addFace(new int[]{2, 0, 6, 4}, color, true);
            obj.addFace(new int[]{1, 3, 5, 7}, color, true);
            obj.addFace(new int[]{0, 1, 7, 6}, color, true);
            if (!leftSide) {
                obj.addFace(new int[]{2, 3, 1, 0}, color, true);
            }
            obj.addFace(new int[]{3, 2, 4, 5}, color, true);
            if (!rightSide) {
                obj.addFace(new int[]{6, 7, 5, 4}, color, true);
            }
            if (openingFace) {
                obj.addFace(new int[]{1, 0, 2, 3}, color, true);
            }
            if (closingFace) {
                obj.addFace(new int[]{5, 4, 6, 7}, color, true);
            }
        } else if (vertices == 6) {
            obj.addFace(new int[]{4, 2, 0}, color, true);
            obj.addFace(new int[]{1, 3, 5}, color, true);
            if (leftSide) {
                obj.addFace(new int[]{4, 5, 3, 2}, color, true);
                if (openingFace) {
                    obj.addFace(new int[]{1, 0, 2, 3}, color, true);
                }
            } else {
                obj.addFace(new int[]{2, 3, 1, 0}, color, true);
                if (closingFace) {
                    obj.addFace(new int[]{3, 2, 4, 5}, color, true);
                }
            }
            obj.addFace(new int[]{0, 1, 5, 4}, color, true);
        } else {
            obj.addFace(new int[]{0, 1, 3, 2}, color, true);
            obj.addFace(new int[]{2, 3, 1, 0}, color, true);
        }
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AreaRenderer3D)) {
            return false;
        }
        AreaRenderer3D that = (AreaRenderer3D)obj;
        if (this.base != that.base) {
            return false;
        }
        if (!ObjectUtils.equals(this.baseColor, that.baseColor)) {
            return false;
        }
        if (this.depth != that.depth) {
            return false;
        }
        return super.equals(obj);
    }
}

