/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Colors;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;

public final class StandardCategoryColorSource
implements CategoryColorSource,
Serializable {
    private Color[] colors;

    public StandardCategoryColorSource() {
        this(Colors.getDefaultColors());
    }

    public StandardCategoryColorSource(Color color) {
        this(new Color[]{color});
    }

    public StandardCategoryColorSource(Color[] colors) {
        ArgChecks.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i] != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.colors = (Color[])colors.clone();
    }

    @Override
    public Color getColor(int series, int row, int column) {
        return this.colors[series % this.colors.length];
    }

    @Override
    public Color getLegendColor(int series) {
        return this.colors[series % this.colors.length];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryColorSource)) {
            return false;
        }
        StandardCategoryColorSource that = (StandardCategoryColorSource)obj;
        return Arrays.equals(this.colors, that.colors);
    }
}

