/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.xyz;

import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.AbstractXYZRenderer;
import com.orsoncharts.renderer.xyz.XYZRenderer;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;
import java.io.Serializable;

public class ScatterXYZRenderer
extends AbstractXYZRenderer
implements XYZRenderer,
Serializable {
    private double size = 0.1;

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        ArgChecks.positiveRequired(size, "size");
        this.size = size;
        this.fireChangeEvent();
    }

    @Override
    public void composeItem(XYZDataset dataset, int series, int item, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        double x = dataset.getX(series, item);
        double y = dataset.getY(series, item);
        double z = dataset.getZ(series, item);
        XYZPlot plot = this.getPlot();
        ValueAxis3D xAxis = plot.getXAxis();
        ValueAxis3D yAxis = plot.getYAxis();
        ValueAxis3D zAxis = plot.getZAxis();
        double delta = this.size / 2.0;
        Dimension3D dim = plot.getDimensions();
        double xx = xAxis.translateToWorld(x, dim.getWidth());
        double xmin = Math.max(0.0, xx - delta);
        double xmax = Math.min(dim.getWidth(), xx + delta);
        double yy = yAxis.translateToWorld(y, dim.getHeight());
        double ymin = Math.max(0.0, yy - delta);
        double ymax = Math.min(dim.getHeight(), yy + delta);
        double zz = zAxis.translateToWorld(z, dim.getDepth());
        double zmin = Math.max(0.0, zz - delta);
        double zmax = Math.min(dim.getDepth(), zz + delta);
        if (xmin >= xmax || ymin >= ymax || zmin >= zmax) {
            return;
        }
        Color color = this.getColorSource().getColor(series, item);
        Object3D cube = Object3D.createBox((xmax + xmin) / 2.0 + xOffset, xmax - xmin, (ymax + ymin) / 2.0 + yOffset, ymax - ymin, (zmax + zmin) / 2.0 + zOffset, zmax - zmin, color);
        world.add(cube);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScatterXYZRenderer)) {
            return false;
        }
        ScatterXYZRenderer that = (ScatterXYZRenderer)obj;
        if (this.size != that.size) {
            return false;
        }
        return super.equals(obj);
    }
}

