/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.xyz;

import com.orsoncharts.renderer.xyz.XYZColorSource;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.io.Serializable;

public class StandardXYZColorSource
implements XYZColorSource,
Serializable {
    private Color[] colors;

    public StandardXYZColorSource() {
        this(new Color[]{Color.RED, Color.BLUE, Color.YELLOW, Color.GRAY, Color.GREEN});
    }

    public StandardXYZColorSource(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.colors = new Color[]{color};
    }

    public StandardXYZColorSource(Color[] colors) {
        ArgChecks.nullNotPermitted(colors, "colors");
        this.colors = colors;
    }

    @Override
    public Color getColor(int series, int item) {
        return this.colors[series % this.colors.length];
    }

    @Override
    public Color getLegendColor(int series) {
        return this.colors[series % this.colors.length];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYZColorSource)) {
            return false;
        }
        StandardXYZColorSource that = (StandardXYZColorSource)obj;
        if (this.colors.length != that.colors.length) {
            return false;
        }
        for (int i = 0; i < this.colors.length; ++i) {
            if (ObjectUtils.equalsPaint(this.colors[i], that.colors[i])) continue;
            return false;
        }
        return true;
    }
}

