/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.hsqldb.auth.AuthBeanMultiplexer;
import org.hsqldb.auth.DenyException;
import org.hsqldb.auth.LdapAuthBean;

public class LdapAuthBeanTester {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("SYNTAX:  java " + AuthBeanMultiplexer.class.getName() + " path/to/file.properties <USERNAME> <PASSWORD>");
        }
        File file = new File(stringArray[0]);
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + file.getAbsolutePath());
        }
        Properties properties = new Properties();
        Object object = new FileInputStream(file);
        Object object2 = null;
        try {
            properties.load((InputStream)object);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
            }
        }
        object = properties.getProperty("trustStore");
        object2 = properties.getProperty("startTls");
        String string = properties.getProperty("ldapPort");
        String string2 = properties.getProperty("roleSchemaValuePattern");
        String string3 = properties.getProperty("accessValuePattern");
        String string4 = properties.getProperty("securityMechanism");
        String string5 = properties.getProperty("ldapHost");
        String string6 = properties.getProperty("principalTemplate");
        String string7 = properties.getProperty("initialContextFactory");
        String string8 = properties.getProperty("saslRealm");
        String string9 = properties.getProperty("parentDn");
        String string10 = properties.getProperty("rdnAttribute");
        String string11 = properties.getProperty("rolesSchemaAttribute");
        String string12 = properties.getProperty("accessAttribute");
        if (object != null) {
            if (!new File((String)object).isFile()) {
                throw new IllegalArgumentException("Specified trust store is not a file: " + (String)object);
            }
            System.setProperty("javax.net.ssl.trustStore", (String)object);
        }
        LdapAuthBean ldapAuthBean = new LdapAuthBean();
        if (object2 != null) {
            ldapAuthBean.setStartTls(Boolean.parseBoolean((String)object2));
        }
        if (string != null) {
            ldapAuthBean.setLdapPort(Integer.parseInt(string));
        }
        if (string2 != null) {
            ldapAuthBean.setRoleSchemaValuePatternString(string2);
        }
        if (string3 != null) {
            ldapAuthBean.setAccessValuePatternString(string3);
        }
        if (string4 != null) {
            ldapAuthBean.setSecurityMechanism(string4);
        }
        if (string5 != null) {
            ldapAuthBean.setLdapHost(string5);
        }
        if (string6 != null) {
            ldapAuthBean.setPrincipalTemplate(string6);
        }
        if (string7 != null) {
            ldapAuthBean.setInitialContextFactory(string7);
        }
        if (string8 != null) {
            ldapAuthBean.setSaslRealm(string8);
        }
        if (string9 != null) {
            ldapAuthBean.setParentDn(string9);
        }
        if (string10 != null) {
            ldapAuthBean.setRdnAttribute(string10);
        }
        if (string11 != null) {
            ldapAuthBean.setRolesSchemaAttribute(string11);
        }
        if (string12 != null) {
            ldapAuthBean.setAccessAttribute(string12);
        }
        ldapAuthBean.init();
        Object[] objectArray = null;
        try {
            objectArray = ldapAuthBean.authenticate(stringArray[1], stringArray[2]);
        }
        catch (DenyException denyException) {
            System.out.println("<DENY ACCESS>");
            return;
        }
        if (objectArray == null) {
            System.out.println("<ALLOW ACCESS w/ local Roles+Schema>");
        } else {
            System.out.println(Integer.toString(objectArray.length) + " Roles/Schema: " + Arrays.toString(objectArray));
        }
    }
}

