/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialogCommon {
    private static String[][] connTypes;
    private static final String[][] sJDBCTypes;
    private static final String fileName = "hsqlprefs.dat";
    private static File recentSettings;
    static String emptySettingName;
    private static String homedir;

    ConnectionDialogCommon() {
    }

    static String[][] getTypes() {
        return sJDBCTypes;
    }

    static synchronized Hashtable loadRecentConnectionSettings() throws IOException {
        Hashtable<String, ConnectionSetting> hashtable = new Hashtable<String, ConnectionSetting>();
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return hashtable;
                }
                recentSettings = new File(homedir, fileName);
                if (!recentSettings.exists()) {
                    recentSettings.createNewFile();
                    return hashtable;
                }
            }
        }
        catch (Throwable throwable) {
            return hashtable;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(recentSettings);
            Throwable throwable = null;
            try {
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    Throwable throwable2 = null;
                    try {
                        try {
                            hashtable.clear();
                            while (true) {
                                ConnectionSetting connectionSetting;
                                if (emptySettingName.equals((connectionSetting = (ConnectionSetting)objectInputStream.readObject()).getName())) {
                                    continue;
                                }
                                hashtable.put(connectionSetting.getName(), connectionSetting);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (objectInputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    objectInputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                            } else {
                                objectInputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                if (fileInputStream != null) {
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
                throw throwable7;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Unrecognized class type " + classNotFoundException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unrecognized class type " + classCastException.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    static void addToRecentConnectionSettings(Hashtable hashtable, ConnectionSetting connectionSetting) throws IOException {
        hashtable.put(connectionSetting.getName(), connectionSetting);
        ConnectionDialogCommon.storeRecentConnectionSettings(hashtable);
    }

    private static void storeRecentConnectionSettings(Hashtable hashtable) {
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return;
                }
                recentSettings = new File(homedir, fileName);
                if (!recentSettings.exists()) {
                    // empty if block
                }
            }
            if (hashtable == null || hashtable.size() == 0) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(recentSettings);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                objectOutputStream.writeObject(enumeration.nextElement());
            }
            objectOutputStream.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void deleteRecentConnectionSettings() {
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return;
                }
                recentSettings = new File(homedir, fileName);
            }
            if (!recentSettings.exists()) {
                recentSettings = null;
                return;
            }
            recentSettings.delete();
            recentSettings = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setHomeDir() {
        if (homedir == null) {
            try {
                Class<?> clazz = Class.forName("sun.security.action.GetPropertyAction");
                Constructor<?> constructor = clazz.getConstructor(String.class);
                PrivilegedAction privilegedAction = (PrivilegedAction)constructor.newInstance("user.home");
                homedir = (String)AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                System.err.println("No access to home directory.  Continuing without...");
            }
        }
    }

    static {
        sJDBCTypes = new String[][]{{"HSQL Database Engine In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:."}, {"HSQL Database Engine Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:file:\u00abdatabase/path?\u00bb"}, {"HSQL Database Engine Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost/"}, {"HSQL Database Engine WebServer", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://\u00abhostname/?\u00bb"}, {"JDBC-ODBC Bridge from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:\u00abdatabase?\u00bb"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://\u00abhost?\u00bb:1099/jdbc:cloudscape:\u00abdatabase?\u00bb;create=true"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:\u00abdatabase?\u00bb"}, {"IBM DB2 (thin)", "COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2://\u00abhost?\u00bb:6789/\u00abdatabase?\u00bb"}, {"Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://\u00abhost?\u00bb:1533/\u00abdatabase?\u00bb:INFORMIXSERVER=\u00abserver?\u00bb"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:\u00abdatabase?\u00bb.prp"}, {"MySQL Connector/J", "com.mysql.jdbc.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"MM.MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@\u00abdatabase?\u00bb"}, {"Oracle (thin)", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@\u00abhost?\u00bb:1521:\u00abdatabase?\u00bb"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL v6.5", "postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}};
        recentSettings = null;
        emptySettingName = "Recent settings...";
        homedir = null;
    }
}

