#!/usr/bin/python
#Copyright (c) 2018, Intel Corporation All Rights Reserved.

#The source code, information and material ("Material") contained herein is owned by Intel Corporation 
#or its suppliers or licensors, and title to such Material remains with Intel Corporation or its 
#suppliers or licensors. The Material contains proprietary information of Intel or its suppliers 
#and licensors. The Material is protected by worldwide copyright laws #and treaty provisions. No part of 
#the Material may be used, copied, reproduced, modified, published, uploaded, posted, transmitted, 
#distributed or disclosed in any way without Intel's prior express written permission. 
#No license under any patent, copyright or other intellectual property rights in the Material is granted 
#to or conferred upon you, either expressly, by implication, inducement, estoppel or otherwise. Any 
#license under such intellectual property rights must be express and approved by Intel in writing.

#Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other 
#notice embedded in Materials by Intel or Intels suppliers or licensors in any way.


target_fps=30.0
script_root = "/mnt/vvvalidation/tools/h264/scripts/"
input_root = "/mnt/vvvalidation/tools/h264/input/"
output_root = "/mnt/vvvalidation/tools/h264/output/"
bin_root = "/mnt/vvvalidation/tools/h264/bin/"
stat_root = "/mnt/vvvalidation/tools/h264/stats/"
par_root = "/mnt/vvvalidation/tools/h264/parfiles/"
job_root = "/mnt/vvvalidation/tools/h264/jobfiles/"
log_root = "/mnt/vvvalidation/tools/h264/logs/"


#### Configuration section End ######

### DO NOT edit below this for configuration ######################
import re, sys, argparse, os, subprocess
import socket, fcntl,struct
import logging
import datetime

global inputfile, density, auto, max_density
inputfile = ''
density=0
auto=False
actual_fps=0.0
drv_txt =  'Driver version:'
time_txt =  'Common transcoding time is'
frame_txt = 'frames'
#frame_txt = 'Number of processed frames:'
time = 0.0
frames = 0
ip_addr =' '
max_density = 0

def get_ip_address(ifname):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    return socket.inet_ntoa(fcntl.ioctl(
        s.fileno(),
        0x8915,  # SIOCGIFADDR
        struct.pack('256s', ifname[:15])
    )[20:24])


def parse_cmdln(argv):
	parser = argparse.ArgumentParser()
	parser.add_argument("-i", "--infile", help="input file name")
	parser.add_argument("-d", "--density", help="Num of streams to run concurrently", type=int)
	parser.add_argument("--auto",  help=" start with the given streams (via -d) and find the maximum density", action="store_true")
	args = parser.parse_args()
	global density, inputfile, auto, max_density
	density = args.density
	max_density=density
	inputfile = os.path.basename(args.infile)
	auto = args.auto
	print "file = %s, real time density = %d auto = %s" %(inputfile, density, auto)

def extract_number_2(s):
    num = re.sub("[^0-9.]", "", s)
#('Driver version: (.+?)-ubit', s).group(1)
    num1 = num[:4]
    if re.search("\.", num1):
        return float(num1)
    else:
        return int(num1)

def extract_number_1(s):
    num = re.search('sec, (.+?) frames', s).group(1)
    if re.search("\.", num):
        return float(num)
    else:
        return int(num)

def extract_number(s):
    num = re.sub("[^0-9.]", " ", s)
    if re.search("\.", num):
        return float(num)
    else:
        return int(num)

def find_fps(time, num_frames):
	return float (int(num_frames) / float(time) )
	
def extract_num_from_file_2(file, str):
        in_file = open(file, 'r')

        while True:
                test = in_file.readline()
                if str in test:
                        time = extract_number_2(test)
                        break
        return(time)

def extract_num_from_file_1(file, str):
	in_file = open(file, 'r')

	while True:
		test = in_file.readline()
		if str in test:
			time = extract_number_1(test)
			break
	return(time)

def extract_num_from_file(file, str):
	in_file = open(file, 'r')

	while True:
		test = in_file.readline()
		if str in test:
			time = extract_number(test)
			break
	return(time)


def tx_density_prework():
        logfile = log_root + ip_addr + "_MSS_verify.log"
        pv4="pv3"
        drv_ver=extract_num_from_file_2(logfile, drv_txt)
        print drv_ver
        
        if (drv_ver >= 16.8):
            pv4="pv4"
        if (drv_ver >= 16.9):
            pv4="pv5"
        parfile = script_root +  "generate_parfile_jobfile  " + str(density) + "  " + input_root + inputfile +  "   " + output_root + " " + ip_addr + " " + pv4
	print parfile
	subprocess.call(parfile, shell=True)
	cp_src_cmd = script_root + "copy_files " + input_root + inputfile + " " + input_root + " " + ip_addr  + " " + str(density)
	print cp_src_cmd
	subprocess.call(cp_src_cmd, shell=True)
def tx_run():
	tx_cmd = job_root +   ip_addr + "/jobfile_" + str(density) + ".sh"
	print tx_cmd
        os.environ.copy()
	subprocess.call(tx_cmd, shell=True)

def find_density():
	global auto, max_density, density, ip_addr
	tx_density_prework()
	tx_run()
	if check_density():
		print "Real time density is achieved for %d streams in %s" %(density, ip_addr)
		if auto and max_density <= density:
			max_density = density
			density = density+1
			print "Now trying the density %d  in %s" %(density, ip_addr)
			find_density()
		else:
			print "Real time density is achieved for %d streams in %s" %(max_density, ip_addr)
			return
		
	else:
		print "Real time density is failed for %d streams in %s" %(density, ip_addr)
		if auto and max_density >= density:
			max_density = density
			density = density-1
			print "Now trying the density %d  in %s" %(density, ip_addr)
			find_density()
		else:
			print "Real time density is achieved for %d streams in %s" %(max_density, ip_addr)
			return

def main(argv):
	global ip_addr, max_density
	ip_addr = get_ip_address('eth0')
	print ip_addr
	ipaddr=ip_addr.strip()
        lpath="/mnt/vvvalidation/tools/h264/logs/"
        LOGNAME=lpath+str(ip_addr)+"_results.txt"
        logging.basicConfig(filename=LOGNAME,level=logging.DEBUG,filemode='w')
	parse_cmdln(argv)
	find_density()


def check_density():
	global stat_root, ip_addr
	stat_file_path = stat_root + ip_addr + '/'
	dirs = os.listdir(stat_file_path)
	for file in dirs:
		print file
		time = extract_num_from_file(stat_file_path+file, time_txt)
		frames = extract_num_from_file_1(stat_file_path+file, frame_txt)
		actual_fps =  find_fps(time,frames) 
                logging.info("target: "+str(target_fps)+" achieved "+str(actual_fps)+" density "+str(density))
		print "Expected FPS: %f, achieved FPS = %f, using density = %d" %(target_fps, actual_fps, density)
		if actual_fps <  target_fps:
			return False
			 
	return True 
	

if __name__ == "__main__":
   main(sys.argv[1:])
