/*******************************************************************************
*
* Copyright (c) 2015-2017 Intel Corporation.  All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses.  You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* COPYING in the main directory of this source tree, or the
* OpenFabrics.org BSD license below:
*
*   Redistribution and use in source and binary forms, with or
*   without modification, are permitted provided that the following
*   conditions are met:
*
*    - Redistributions of source code must retain the above
*	copyright notice, this list of conditions and the following
*	disclaimer.
*
*    - Redistributions in binary form must reproduce the above
*	copyright notice, this list of conditions and the following
*	disclaimer in the documentation and/or other materials
*	provided with the distribution.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
* BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
* ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
*******************************************************************************/
/*$FreeBSD$*/

#ifndef _I40IW_OSDEP_H_
#define _I40IW_OSDEP_H_

#include <linux/list.h>
#include <linux/timer.h>
#include <linux/spinlock.h>
#include <linux/mutex.h>
#include <linux/workqueue.h>
#include <linux/if_ether.h>
#include <linux/etherdevice.h>
#include <linux/fs.h>
#include <linux/io.h>
#include <linux/random.h>

#include <sys/bus.h>
#include <machine/bus.h>

#define IOMEM
#define OS_TIMER timer_list
#define ATOMIC atomic_t
#define i40iw_get_virt_to_phy vtophys

#define I40IW_NTOHS(a) ntohs(a)

#define CPU_TO_LE16(o)	htole16(o)
#define CPU_TO_LE32(s)	htole32(s)
#define CPU_TO_LE64(h)	htole64(h)
#define LE16_TO_CPU(a)	le16toh(a)
#define LE32_TO_CPU(c)	le32toh(c)
#define LE64_TO_CPU(k)	le64toh(k)

#define i40iw_memcpy(a, b, c)  memcpy((a), (b), (c))
#define i40iw_memset(a, b, c)  memset((a), (b), (c))

#define i40iw_mb()	mb()
#define i40iw_wmb()	wmb()

#define i40iw_usec_delay(x) DELAY(x)
#define mdelay(x) DELAY((x) * 1000)

typedef unsigned long *i40iw_bits_t;
typedef uintptr_t i40iw_uintptr;

typedef __be16 BE16;
typedef __be32 BE32;

#define I40IW_NTOHL(a) ntohl(a)

#define i40iw_free_dma_mem(hw, dma_mem) ixliw_free_dma_mem(dma_mem)

#define rd32(a, reg)		i40iw_rd32((a)->dev_context, (reg))
#define wr32(a, reg, value)	i40iw_wr32((a)->dev_context, (reg), (value))

#define rd64(a, reg)		i40iw_rd64((a)->dev_context, (reg))
#define wr64(a, reg, value)	i40iw_wr64((a)->dev_context, (reg), (value))

#define db_wr32(value, a)	writel((value), (a))

#define i40iw_debug(h, m, s, ...)           \
do {                                        \
	if (((m) & (h)->debug_mask))            \
		printf("i40iw " s, ##__VA_ARGS__);  \
} while (0)

struct i40iw_dev_ctx;
struct i40iw_sc_dev;
struct i40iw_sc_qp;
struct i40iw_sc_vsi;
struct i40iw_update_sds_info;

struct i40iw_dma_mem {
	void  *va;
	u64    pa;
	bus_dma_tag_t tag;
	bus_dmamap_t map;
	bus_dma_segment_t seg;
	bus_size_t size;
	int    nseg;
	int    flags;
};

struct i40iw_virt_mem {
	void  *va;
	u32    size;
};

u8    *i40iw_get_hw_addr(void *par);
enum i40iw_status_code i40iw_cqp_sds_cmd(struct i40iw_sc_dev *, struct i40iw_update_sds_info *);
void  *i40iw_remove_head(struct list_head *list);

void   i40iw_hw_stats_start_timer(struct i40iw_sc_vsi *vsi);
void   i40iw_hw_stats_stop_timer(struct i40iw_sc_vsi *vsi);

void   ixliw_free_dma_mem(struct i40iw_dma_mem *mem);

u32    i40iw_rd32(struct i40iw_dev_ctx *dev_ctx, u32 reg);
void   i40iw_wr32(struct i40iw_dev_ctx *dev_ctx, u32 reg, u32 value);
u64    i40iw_rd64(struct i40iw_dev_ctx *dev_ctx, u32 reg);
void   i40iw_wr64(struct i40iw_dev_ctx *dev_ctx, u32 reg, u64 value);

void   i40iw_term_modify_qp(struct i40iw_sc_qp *qp, u8 next_state, u8 term, u8 term_len);
void   i40iw_terminate_done(struct i40iw_sc_qp *qp, int timeout_occurred);
void   i40iw_terminate_start_timer(struct i40iw_sc_qp *qp);
void   i40iw_terminate_del_timer(struct i40iw_sc_qp *qp);

static inline void
set_64bit_val(u64 *wqe_words, u32 byte_index, u64 value)
{
	wqe_words[byte_index >> 3] = value;
}

/**
 * set_32bit_val - set 32 value to hw wqe
 * @wqe_words: wqe addr to write
 * @byte_index: index in wqe
 * @value: value to write
 **/
static inline void
set_32bit_val(u32 *wqe_words, u32 byte_index, u32 value)
{
	wqe_words[byte_index >> 2] = value;
}

/**
 * get_64bit_val - read 64 bit value from wqe
 * @wqe_words: wqe addr
 * @byte_index: index to read from
 * @value: read value
 **/
static inline void
get_64bit_val(u64 *wqe_words, u32 byte_index, u64 *value)
{
	*value = wqe_words[byte_index >> 3];
}

#endif				/* _I40IW_OSDEP_H_ */
