/*******************************************************************************
*
* Copyright (c) 2015-2017 Intel Corporation.  All rights reserved.
*
* This software is available to you under a choice of one of two
* licenses.  You may choose to be licensed under the terms of the GNU
* General Public License (GPL) Version 2, available from the file
* COPYING in the main directory of this source tree, or the
* OpenFabrics.org BSD license below:
*
*   Redistribution and use in source and binary forms, with or
*   without modification, are permitted provided that the following
*   conditions are met:
*
*    - Redistributions of source code must retain the above
*	copyright notice, this list of conditions and the following
*	disclaimer.
*
*    - Redistributions in binary form must reproduce the above
*	copyright notice, this list of conditions and the following
*	disclaimer in the documentation and/or other materials
*	provided with the distribution.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
* BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
* ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
*******************************************************************************/

#ifndef I40IW_D_H
#define I40IW_D_H

#define I40IW_FIRST_USER_QP_ID	2

#define I40IW_DB_ADDR_OFFSET    (4 * 1024 * 1024 - 64 * 1024)
#define I40IW_VF_DB_ADDR_OFFSET (64 * 1024)

#define I40IW_PUSH_OFFSET       (4 * 1024 * 1024)
#define I40IW_PF_FIRST_PUSH_PAGE_INDEX 16
#define I40IW_VF_PUSH_OFFSET    ((8 + 64) * 1024)
#define I40IW_VF_FIRST_PUSH_PAGE_INDEX 2

#define I40IW_PE_DB_SIZE_4M     1
#define I40IW_PE_DB_SIZE_8M     2

#define I40IW_DDP_VER 1
#define I40IW_RDMAP_VER 1

#define I40IW_RDMA_MODE_RDMAC 0
#define I40IW_RDMA_MODE_IETF  1

#define I40IW_QP_STATE_INVALID 0
#define I40IW_QP_STATE_IDLE 1
#define I40IW_QP_STATE_RTS 2
#define I40IW_QP_STATE_CLOSING 3
#define I40IW_QP_STATE_RESERVED 4
#define I40IW_QP_STATE_TERMINATE 5
#define I40IW_QP_STATE_ERROR 6

#define I40IW_STAG_STATE_INVALID 0
#define I40IW_STAG_STATE_VALID 1

#define I40IW_STAG_TYPE_SHARED 0
#define I40IW_STAG_TYPE_NONSHARED 1

#define I40IW_MAX_USER_PRIORITY 8
#define I40IW_MAX_STATS_COUNT 16
#define I40IW_FIRST_NON_PF_STAT	4

#define I40IW_MIN_MTU_IPV4		576
#define I40IW_MIN_MTU_IPV6		1280
#define I40IW_MTU_TO_MSS_IPV4		40
#define I40IW_MTU_TO_MSS_IPV6		60
#define I40IW_DEFAULT_MTU		1500

#define LS_64_1(val, bits)      ((u64)(uintptr_t)val << bits)
#define RS_64_1(val, bits)      ((u64)(uintptr_t)val >> bits)
#define LS_32_1(val, bits)      (u32)(val << bits)
#define RS_32_1(val, bits)      (u32)(val >> bits)
#define I40E_HI_DWORD(x)        ((u32)((((x) >> 16) >> 16) & 0xFFFFFFFF))

#define LS_64(val, field) (((u64)val << field ## _SHIFT) & (field ## _MASK))

#define RS_64(val, field) ((u64)(val & field ## _MASK) >> field ## _SHIFT)
#define LS_32(val, field) ((val << field ## _SHIFT) & (field ## _MASK))
#define RS_32(val, field) ((val & field ## _MASK) >> field ## _SHIFT)

#define TERM_DDP_LEN_TAGGED     14
#define TERM_DDP_LEN_UNTAGGED   18
#define TERM_RDMA_LEN           28
#define RDMA_OPCODE_MASK        0x0f
#define RDMA_READ_REQ_OPCODE    1
#define Q2_BAD_FRAME_OFFSET     72
#define Q2_FPSN_OFFSET          64
#define CQE_MAJOR_DRV           0x8000

#define I40IW_TERM_SENT 0x01
#define I40IW_TERM_RCVD 0x02
#define I40IW_TERM_DONE 0x04
#define I40IW_MAC_HLEN  14
#define I40IW_BYTE_0 0
#define I40IW_BYTE_8 8
#define I40IW_BYTE_16 16
#define I40IW_BYTE_24 24
#define I40IW_BYTE_32 32
#define I40IW_BYTE_40 40
#define I40IW_BYTE_48 48
#define I40IW_BYTE_56 56
#define I40IW_BYTE_64 64
#define I40IW_BYTE_72 72
#define I40IW_BYTE_80 80
#define I40IW_BYTE_88 88
#define I40IW_BYTE_96 96
#define I40IW_BYTE_104 104
#define I40IW_BYTE_112 112
#define I40IW_BYTE_120 120
#define I40IW_BYTE_128 128
#define I40IW_BYTE_136 136
#define I40IW_BYTE_144 144
#define I40IW_BYTE_152 152
#define I40IW_BYTE_160 160
#define I40IW_BYTE_168 168
#define I40IW_BYTE_176 176
#define I40IW_BYTE_184 184
#define I40IW_BYTE_192 192
#define I40IW_BYTE_200 200
#define I40IW_BYTE_208 208

#define I40IW_INVALID_WQE_INDEX 0xffffffff

#define I40IW_CQP_WAIT_POLL_REGS 1
#define I40IW_CQP_WAIT_POLL_CQ 2
#define I40IW_CQP_WAIT_EVENT 3

#define I40IW_CQP_INIT_WQE(wqe) memset(wqe, 0, 64)

#define I40IW_GET_CURRENT_CQ_ELEMENT(_cq) \
	( \
		&((_cq)->cq_base[I40IW_RING_GETCURRENT_HEAD((_cq)->cq_ring)])  \
	)
#define I40IW_GET_CURRENT_EXTENDED_CQ_ELEMENT(_cq) \
	( \
		&(((struct i40iw_extended_cqe *)        \
		   ((_cq)->cq_base))[I40IW_RING_GETCURRENT_HEAD((_cq)->cq_ring)]) \
	)

#define I40IW_GET_CURRENT_AEQ_ELEMENT(_aeq) \
	( \
		&_aeq->aeqe_base[I40IW_RING_GETCURRENT_TAIL(_aeq->aeq_ring)]   \
	)

#define I40IW_GET_CURRENT_CEQ_ELEMENT(_ceq) \
	( \
		&_ceq->ceqe_base[I40IW_RING_GETCURRENT_TAIL(_ceq->ceq_ring)]   \
	)

#define I40IW_AE_SOURCE_RSVD            0x0
#define I40IW_AE_SOURCE_RQ              0x1
#define I40IW_AE_SOURCE_RQ_0011         0x3

#define I40IW_AE_SOURCE_CQ              0x2
#define I40IW_AE_SOURCE_CQ_0110         0x6
#define I40IW_AE_SOURCE_CQ_1010         0xA
#define I40IW_AE_SOURCE_CQ_1110         0xE

#define I40IW_AE_SOURCE_SQ              0x5
#define I40IW_AE_SOURCE_SQ_0111         0x7

#define I40IW_AE_SOURCE_IN_RR_WR        0x9
#define I40IW_AE_SOURCE_IN_RR_WR_1011   0xB
#define I40IW_AE_SOURCE_OUT_RR          0xD
#define I40IW_AE_SOURCE_OUT_RR_1111     0xF

#define I40IW_TCP_STATE_NON_EXISTENT 0
#define I40IW_TCP_STATE_CLOSED 1
#define I40IW_TCP_STATE_LISTEN 2
#define I40IW_STATE_SYN_SEND 3
#define I40IW_TCP_STATE_SYN_RECEIVED 4
#define I40IW_TCP_STATE_ESTABLISHED 5
#define I40IW_TCP_STATE_CLOSE_WAIT 6
#define I40IW_TCP_STATE_FIN_WAIT_1 7
#define I40IW_TCP_STATE_CLOSING  8
#define I40IW_TCP_STATE_LAST_ACK 9
#define I40IW_TCP_STATE_FIN_WAIT_2 10
#define I40IW_TCP_STATE_TIME_WAIT 11
#define I40IW_TCP_STATE_RESERVED_1 12
#define I40IW_TCP_STATE_RESERVED_2 13
#define I40IW_TCP_STATE_RESERVED_3 14
#define I40IW_TCP_STATE_RESERVED_4 15

/* ILQ CQP hash table fields */
#define I40IW_CQPSQ_QHASH_VLANID_SHIFT 32
#define I40IW_CQPSQ_QHASH_VLANID_MASK \
	((u64)0xfff << I40IW_CQPSQ_QHASH_VLANID_SHIFT)

#define I40IW_CQPSQ_QHASH_QPN_SHIFT 32
#define I40IW_CQPSQ_QHASH_QPN_MASK \
	((u64)0x3ffff << I40IW_CQPSQ_QHASH_QPN_SHIFT)

#define I40IW_CQPSQ_QHASH_QS_HANDLE_SHIFT 0
#define I40IW_CQPSQ_QHASH_QS_HANDLE_MASK ((u64)0x3ff << I40IW_CQPSQ_QHASH_QS_HANDLE_SHIFT)

#define I40IW_CQPSQ_QHASH_SRC_PORT_SHIFT 16
#define I40IW_CQPSQ_QHASH_SRC_PORT_MASK \
	((u64)0xffff << I40IW_CQPSQ_QHASH_SRC_PORT_SHIFT)

#define I40IW_CQPSQ_QHASH_DEST_PORT_SHIFT 0
#define I40IW_CQPSQ_QHASH_DEST_PORT_MASK \
	((u64)0xffff << I40IW_CQPSQ_QHASH_DEST_PORT_SHIFT)

#define I40IW_CQPSQ_QHASH_ADDR0_SHIFT 32
#define I40IW_CQPSQ_QHASH_ADDR0_MASK \
	((u64)0xffffffff << I40IW_CQPSQ_QHASH_ADDR0_SHIFT)

#define I40IW_CQPSQ_QHASH_ADDR1_SHIFT 0
#define I40IW_CQPSQ_QHASH_ADDR1_MASK \
	((u64)0xffffffff << I40IW_CQPSQ_QHASH_ADDR1_SHIFT)

#define I40IW_CQPSQ_QHASH_ADDR2_SHIFT 32
#define I40IW_CQPSQ_QHASH_ADDR2_MASK \
	((u64)0xffffffff << I40IW_CQPSQ_QHASH_ADDR2_SHIFT)

#define I40IW_CQPSQ_QHASH_ADDR3_SHIFT 0
#define I40IW_CQPSQ_QHASH_ADDR3_MASK \
	((u64)0xffffffff << I40IW_CQPSQ_QHASH_ADDR3_SHIFT)

#define I40IW_CQPSQ_QHASH_WQEVALID_SHIFT 63
#define I40IW_CQPSQ_QHASH_WQEVALID_MASK \
	((u64)0x1 << I40IW_CQPSQ_QHASH_WQEVALID_SHIFT)
#define I40IW_CQPSQ_QHASH_OPCODE_SHIFT 32
#define I40IW_CQPSQ_QHASH_OPCODE_MASK \
	((u64)0x3f << I40IW_CQPSQ_QHASH_OPCODE_SHIFT)

#define I40IW_CQPSQ_QHASH_MANAGE_SHIFT 61
#define I40IW_CQPSQ_QHASH_MANAGE_MASK \
	((u64)0x3 << I40IW_CQPSQ_QHASH_MANAGE_SHIFT)

#define I40IW_CQPSQ_QHASH_IPV4VALID_SHIFT 60
#define I40IW_CQPSQ_QHASH_IPV4VALID_MASK \
	((u64)0x1 << I40IW_CQPSQ_QHASH_IPV4VALID_SHIFT)

#define I40IW_CQPSQ_QHASH_VLANVALID_SHIFT 59
#define I40IW_CQPSQ_QHASH_VLANVALID_MASK \
	((u64)0x1 << I40IW_CQPSQ_QHASH_VLANVALID_SHIFT)

#define I40IW_CQPSQ_QHASH_ENTRYTYPE_SHIFT 42
#define I40IW_CQPSQ_QHASH_ENTRYTYPE_MASK \
	((u64)0x7 << I40IW_CQPSQ_QHASH_ENTRYTYPE_SHIFT)
/* CQP Host Context */
#define I40IW_CQPHC_EN_DC_TCP_SHIFT 0
#define I40IW_CQPHC_EN_DC_TCP_MASK (1UL << I40IW_CQPHC_EN_DC_TCP_SHIFT)

#define I40IW_CQPHC_SQSIZE_SHIFT 8
#define I40IW_CQPHC_SQSIZE_MASK (0xfUL << I40IW_CQPHC_SQSIZE_SHIFT)

#define I40IW_CQPHC_CEQPERVF_SHIFT 32
#define I40IW_CQPHC_CEQPERVF_MASK (0xffULL << I40IW_CQPHC_CEQPERVF_SHIFT)

#define I40IW_CQPHC_DISABLE_PFPDUS_SHIFT 1
#define I40IW_CQPHC_DISABLE_PFPDUS_MASK (0x1UL << I40IW_CQPHC_DISABLE_PFPDUS_SHIFT)

#define I40IW_CQPHC_ENABLED_VFS_SHIFT 32
#define I40IW_CQPHC_ENABLED_VFS_MASK (0x3fULL << I40IW_CQPHC_ENABLED_VFS_SHIFT)

#define I40IW_CQPHC_HMC_PROFILE_SHIFT 0
#define I40IW_CQPHC_HMC_PROFILE_MASK (0x7ULL << I40IW_CQPHC_HMC_PROFILE_SHIFT)

#define I40IW_CQPHC_SVER_SHIFT 24
#define I40IW_CQPHC_SVER_MASK (0xffUL << I40IW_CQPHC_SVER_SHIFT)

#define I40IW_CQPHC_SQBASE_SHIFT 9
#define I40IW_CQPHC_SQBASE_MASK \
	(0xfffffffffffffeULL << I40IW_CQPHC_SQBASE_SHIFT)

#define I40IW_CQPHC_QPCTX_SHIFT 0
#define I40IW_CQPHC_QPCTX_MASK  \
	(0xffffffffffffffffULL << I40IW_CQPHC_QPCTX_SHIFT)
#define I40IW_CQPHC_SVER        1

#define I40IW_CQP_SW_SQSIZE_4 4
#define I40IW_CQP_SW_SQSIZE_2048 2048

/* iWARP QP Doorbell shadow area */
#define I40IW_QP_DBSA_HW_SQ_TAIL_SHIFT 0
#define I40IW_QP_DBSA_HW_SQ_TAIL_MASK \
	(0x3fffUL << I40IW_QP_DBSA_HW_SQ_TAIL_SHIFT)

/* Completion Queue Doorbell shadow area */
#define I40IW_CQ_DBSA_CQEIDX_SHIFT 0
#define I40IW_CQ_DBSA_CQEIDX_MASK (0xfffffUL << I40IW_CQ_DBSA_CQEIDX_SHIFT)

#define I40IW_CQ_DBSA_SW_CQ_SELECT_SHIFT 0
#define I40IW_CQ_DBSA_SW_CQ_SELECT_MASK \
	(0x3fffUL << I40IW_CQ_DBSA_SW_CQ_SELECT_SHIFT)

#define I40IW_CQ_DBSA_ARM_NEXT_SHIFT 14
#define I40IW_CQ_DBSA_ARM_NEXT_MASK (1UL << I40IW_CQ_DBSA_ARM_NEXT_SHIFT)

#define I40IW_CQ_DBSA_ARM_NEXT_SE_SHIFT 15
#define I40IW_CQ_DBSA_ARM_NEXT_SE_MASK (1UL << I40IW_CQ_DBSA_ARM_NEXT_SE_SHIFT)

#define I40IW_CQ_DBSA_ARM_SEQ_NUM_SHIFT 16
#define I40IW_CQ_DBSA_ARM_SEQ_NUM_MASK \
	(0x3UL << I40IW_CQ_DBSA_ARM_SEQ_NUM_SHIFT)

/* CQP and iWARP Completion Queue */
#define I40IW_CQ_QPCTX_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQ_QPCTX_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CCQ_OPRETVAL_SHIFT 0
#define I40IW_CCQ_OPRETVAL_MASK (0xffffffffUL << I40IW_CCQ_OPRETVAL_SHIFT)

#define I40IW_CQ_MINERR_SHIFT 0
#define I40IW_CQ_MINERR_MASK (0xffffUL << I40IW_CQ_MINERR_SHIFT)

#define I40IW_CQ_MAJERR_SHIFT 16
#define I40IW_CQ_MAJERR_MASK (0xffffUL << I40IW_CQ_MAJERR_SHIFT)

#define I40IW_CQ_WQEIDX_SHIFT 32
#define I40IW_CQ_WQEIDX_MASK (0x3fffULL << I40IW_CQ_WQEIDX_SHIFT)

#define I40IW_CQ_ERROR_SHIFT 55
#define I40IW_CQ_ERROR_MASK (1ULL << I40IW_CQ_ERROR_SHIFT)

#define I40IW_CQ_SQ_SHIFT 62
#define I40IW_CQ_SQ_MASK (1ULL << I40IW_CQ_SQ_SHIFT)

#define I40IW_CQ_VALID_SHIFT 63
#define I40IW_CQ_VALID_MASK (1ULL << I40IW_CQ_VALID_SHIFT)

#define I40IWCQ_PAYLDLEN_SHIFT 0
#define I40IWCQ_PAYLDLEN_MASK (0xffffffffUL << I40IWCQ_PAYLDLEN_SHIFT)

#define I40IWCQ_TCPSEQNUM_SHIFT 32
#define I40IWCQ_TCPSEQNUM_MASK (0xffffffffULL << I40IWCQ_TCPSEQNUM_SHIFT)

#define I40IWCQ_INVSTAG_SHIFT 0
#define I40IWCQ_INVSTAG_MASK (0xffffffffUL << I40IWCQ_INVSTAG_SHIFT)

#define I40IWCQ_QPID_SHIFT 32
#define I40IWCQ_QPID_MASK (0x3ffffULL << I40IWCQ_QPID_SHIFT)

#define I40IWCQ_PSHDROP_SHIFT 51
#define I40IWCQ_PSHDROP_MASK (1ULL << I40IWCQ_PSHDROP_SHIFT)

#define I40IWCQ_SRQ_SHIFT 52
#define I40IWCQ_SRQ_MASK (1ULL << I40IWCQ_SRQ_SHIFT)

#define I40IWCQ_STAG_SHIFT 53
#define I40IWCQ_STAG_MASK (1ULL << I40IWCQ_STAG_SHIFT)

#define I40IWCQ_SOEVENT_SHIFT 54
#define I40IWCQ_SOEVENT_MASK (1ULL << I40IWCQ_SOEVENT_SHIFT)

#define I40IWCQ_OP_SHIFT 56
#define I40IWCQ_OP_MASK (0x3fULL << I40IWCQ_OP_SHIFT)

/* CEQE format */
#define I40IW_CEQE_CQCTX_SHIFT 0
#define I40IW_CEQE_CQCTX_MASK   \
	(0x7fffffffffffffffULL << I40IW_CEQE_CQCTX_SHIFT)

#define I40IW_CEQE_VALID_SHIFT 63
#define I40IW_CEQE_VALID_MASK (1ULL << I40IW_CEQE_VALID_SHIFT)

/* AEQE format */
#define I40IW_AEQE_COMPCTX_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_AEQE_COMPCTX_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_AEQE_QPCQID_SHIFT 0
#define I40IW_AEQE_QPCQID_MASK (0x3ffffUL << I40IW_AEQE_QPCQID_SHIFT)

#define I40IW_AEQE_WQDESCIDX_SHIFT 18
#define I40IW_AEQE_WQDESCIDX_MASK (0x3fffULL << I40IW_AEQE_WQDESCIDX_SHIFT)

#define I40IW_AEQE_OVERFLOW_SHIFT 33
#define I40IW_AEQE_OVERFLOW_MASK (1ULL << I40IW_AEQE_OVERFLOW_SHIFT)

#define I40IW_AEQE_AECODE_SHIFT 34
#define I40IW_AEQE_AECODE_MASK (0xffffULL << I40IW_AEQE_AECODE_SHIFT)

#define I40IW_AEQE_AESRC_SHIFT 50
#define I40IW_AEQE_AESRC_MASK (0xfULL << I40IW_AEQE_AESRC_SHIFT)

#define I40IW_AEQE_IWSTATE_SHIFT 54
#define I40IW_AEQE_IWSTATE_MASK (0x7ULL << I40IW_AEQE_IWSTATE_SHIFT)

#define I40IW_AEQE_TCPSTATE_SHIFT 57
#define I40IW_AEQE_TCPSTATE_MASK (0xfULL << I40IW_AEQE_TCPSTATE_SHIFT)

#define I40IW_AEQE_Q2DATA_SHIFT 61
#define I40IW_AEQE_Q2DATA_MASK (0x3ULL << I40IW_AEQE_Q2DATA_SHIFT)

#define I40IW_AEQE_VALID_SHIFT 63
#define I40IW_AEQE_VALID_MASK (1ULL << I40IW_AEQE_VALID_SHIFT)

/* CQP SQ WQES */
#define I40IW_QP_TYPE_IWARP     1
#define I40IW_QP_TYPE_UDA       2
#define I40IW_QP_TYPE_CQP       4

#define I40IW_CQ_TYPE_IWARP     1
#define I40IW_CQ_TYPE_ILQ       2
#define I40IW_CQ_TYPE_IEQ       3
#define I40IW_CQ_TYPE_CQP       4

#define I40IWQP_TERM_SEND_TERM_AND_FIN          0
#define I40IWQP_TERM_SEND_TERM_ONLY             1
#define I40IWQP_TERM_SEND_FIN_ONLY              2
#define I40IWQP_TERM_DONOT_SEND_TERM_OR_FIN     3

#define I40IW_CQP_OP_CREATE_QP                  0
#define I40IW_CQP_OP_MODIFY_QP                  0x1
#define I40IW_CQP_OP_DESTROY_QP                 0x02
#define I40IW_CQP_OP_CREATE_CQ                  0x03
#define I40IW_CQP_OP_MODIFY_CQ                  0x04
#define I40IW_CQP_OP_DESTROY_CQ                 0x05
#define I40IW_CQP_OP_CREATE_SRQ                 0x06
#define I40IW_CQP_OP_MODIFY_SRQ                 0x07
#define I40IW_CQP_OP_DESTROY_SRQ                0x08
#define I40IW_CQP_OP_ALLOC_STAG                 0x09
#define I40IW_CQP_OP_REG_MR                     0x0a
#define I40IW_CQP_OP_QUERY_STAG                 0x0b
#define I40IW_CQP_OP_REG_SMR                    0x0c
#define I40IW_CQP_OP_DEALLOC_STAG               0x0d
#define I40IW_CQP_OP_MANAGE_LOC_MAC_IP_TABLE    0x0e
#define I40IW_CQP_OP_MANAGE_ARP                 0x0f
#define I40IW_CQP_OP_MANAGE_VF_PBLE_BP          0x10
#define I40IW_CQP_OP_MANAGE_PUSH_PAGES          0x11
#define I40IW_CQP_OP_MANAGE_PE_TEAM             0x12
#define I40IW_CQP_OP_UPLOAD_CONTEXT             0x13
#define I40IW_CQP_OP_ALLOCATE_LOC_MAC_IP_TABLE_ENTRY 0x14
#define I40IW_CQP_OP_MANAGE_HMC_PM_FUNC_TABLE   0x15
#define I40IW_CQP_OP_CREATE_CEQ                 0x16
#define I40IW_CQP_OP_DESTROY_CEQ                0x18
#define I40IW_CQP_OP_CREATE_AEQ                 0x19
#define I40IW_CQP_OP_DESTROY_AEQ                0x1b
#define I40IW_CQP_OP_CREATE_ADDR_VECT           0x1c
#define I40IW_CQP_OP_MODIFY_ADDR_VECT           0x1d
#define I40IW_CQP_OP_DESTROY_ADDR_VECT          0x1e
#define I40IW_CQP_OP_UPDATE_PE_SDS              0x1f
#define I40IW_CQP_OP_QUERY_FPM_VALUES           0x20
#define I40IW_CQP_OP_COMMIT_FPM_VALUES          0x21
#define I40IW_CQP_OP_FLUSH_WQES                 0x22
/* I40IW_CQP_OP_GEN_AE is the same value as I40IW_CQP_OP_FLUSH_WQES */
#define I40IW_CQP_OP_GEN_AE                     0x22
#define I40IW_CQP_OP_MANAGE_APBVT               0x23
#define I40IW_CQP_OP_NOP                        0x24
#define I40IW_CQP_OP_MANAGE_QUAD_HASH_TABLE_ENTRY 0x25
#define I40IW_CQP_OP_CREATE_UDA_MCAST_GROUP     0x26
#define I40IW_CQP_OP_MODIFY_UDA_MCAST_GROUP     0x27
#define I40IW_CQP_OP_DESTROY_UDA_MCAST_GROUP    0x28
#define I40IW_CQP_OP_SUSPEND_QP                 0x29
#define I40IW_CQP_OP_RESUME_QP                  0x2a
#define I40IW_CQP_OP_SHMC_PAGES_ALLOCATED       0x2b

#define I40IW_UDA_QPSQ_NEXT_HEADER_SHIFT 16
#define I40IW_UDA_QPSQ_NEXT_HEADER_MASK ((u64)0xff << I40IW_UDA_QPSQ_NEXT_HEADER_SHIFT)

#define I40IW_UDA_QPSQ_OPCODE_SHIFT 32
#define I40IW_UDA_QPSQ_OPCODE_MASK ((u64)0x3f << I40IW_UDA_QPSQ_OPCODE_SHIFT)

#define I40IW_UDA_QPSQ_MACLEN_SHIFT 56
#define I40IW_UDA_QPSQ_MACLEN_MASK \
	((u64)0x7f << I40IW_UDA_QPSQ_MACLEN_SHIFT)

#define I40IW_UDA_QPSQ_IPLEN_SHIFT 48
#define I40IW_UDA_QPSQ_IPLEN_MASK \
	((u64)0x7f << I40IW_UDA_QPSQ_IPLEN_SHIFT)

#define I40IW_UDA_QPSQ_L4T_SHIFT 30
#define I40IW_UDA_QPSQ_L4T_MASK \
	((u64)0x3 << I40IW_UDA_QPSQ_L4T_SHIFT)

#define I40IW_UDA_QPSQ_IIPT_SHIFT 28
#define I40IW_UDA_QPSQ_IIPT_MASK \
	((u64)0x3 << I40IW_UDA_QPSQ_IIPT_SHIFT)

#define I40IW_UDA_QPSQ_L4LEN_SHIFT 24
#define I40IW_UDA_QPSQ_L4LEN_MASK ((u64)0xf << I40IW_UDA_QPSQ_L4LEN_SHIFT)

#define I40IW_UDA_QPSQ_AVIDX_SHIFT 0
#define I40IW_UDA_QPSQ_AVIDX_MASK ((u64)0xffff << I40IW_UDA_QPSQ_AVIDX_SHIFT)

#define I40IW_UDA_QPSQ_VALID_SHIFT 63
#define I40IW_UDA_QPSQ_VALID_MASK \
	((u64)0x1 << I40IW_UDA_QPSQ_VALID_SHIFT)

#define I40IW_UDA_QPSQ_SIGCOMPL_SHIFT 62
#define I40IW_UDA_QPSQ_SIGCOMPL_MASK ((u64)0x1 << I40IW_UDA_QPSQ_SIGCOMPL_SHIFT)

#define I40IW_UDA_PAYLOADLEN_SHIFT 0
#define I40IW_UDA_PAYLOADLEN_MASK ((u64)0x3fff << I40IW_UDA_PAYLOADLEN_SHIFT)

#define I40IW_UDA_HDRLEN_SHIFT 16
#define I40IW_UDA_HDRLEN_MASK ((u64)0x1ff << I40IW_UDA_HDRLEN_SHIFT)

#define I40IW_VLAN_TAG_VALID_SHIFT 50
#define I40IW_VLAN_TAG_VALID_MASK ((u64)0x1 << I40IW_VLAN_TAG_VALID_SHIFT)

#define I40IW_UDA_L3PROTO_SHIFT 0
#define I40IW_UDA_L3PROTO_MASK ((u64)0x3 << I40IW_UDA_L3PROTO_SHIFT)

#define I40IW_UDA_L4PROTO_SHIFT 16
#define I40IW_UDA_L4PROTO_MASK ((u64)0x3 << I40IW_UDA_L4PROTO_SHIFT)

#define I40IW_UDA_QPSQ_DOLOOPBACK_SHIFT 44
#define I40IW_UDA_QPSQ_DOLOOPBACK_MASK \
	((u64)0x1 << I40IW_UDA_QPSQ_DOLOOPBACK_SHIFT)

/* CQP SQ WQE common fields */
#define I40IW_CQPSQ_OPCODE_SHIFT 32
#define I40IW_CQPSQ_OPCODE_MASK (0x3fULL << I40IW_CQPSQ_OPCODE_SHIFT)

#define I40IW_CQPSQ_WQEVALID_SHIFT 63
#define I40IW_CQPSQ_WQEVALID_MASK (1ULL << I40IW_CQPSQ_WQEVALID_SHIFT)

#define I40IW_CQPSQ_TPHVAL_SHIFT 0
#define I40IW_CQPSQ_TPHVAL_MASK (0xffUL << I40IW_CQPSQ_TPHVAL_SHIFT)

#define I40IW_CQPSQ_TPHEN_SHIFT 60
#define I40IW_CQPSQ_TPHEN_MASK (1ULL << I40IW_CQPSQ_TPHEN_SHIFT)

#define I40IW_CQPSQ_PBUFADDR_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_PBUFADDR_MASK I40IW_CQPHC_QPCTX_MASK

/* Create/Modify/Destroy QP */

#define I40IW_CQPSQ_QP_NEWMSS_SHIFT 32
#define I40IW_CQPSQ_QP_NEWMSS_MASK (0x3fffULL << I40IW_CQPSQ_QP_NEWMSS_SHIFT)

#define I40IW_CQPSQ_QP_TERMLEN_SHIFT 48
#define I40IW_CQPSQ_QP_TERMLEN_MASK (0xfULL << I40IW_CQPSQ_QP_TERMLEN_SHIFT)

#define I40IW_CQPSQ_QP_QPCTX_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_QP_QPCTX_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_QP_QPID_SHIFT 0
#define I40IW_CQPSQ_QP_QPID_MASK (0x3FFFFUL)
/* I40IWCQ_QPID_MASK */

#define I40IW_CQPSQ_QP_OP_SHIFT 32
#define I40IW_CQPSQ_QP_OP_MASK I40IWCQ_OP_MASK

#define I40IW_CQPSQ_QP_ORDVALID_SHIFT 42
#define I40IW_CQPSQ_QP_ORDVALID_MASK (1ULL << I40IW_CQPSQ_QP_ORDVALID_SHIFT)

#define I40IW_CQPSQ_QP_TOECTXVALID_SHIFT 43
#define I40IW_CQPSQ_QP_TOECTXVALID_MASK \
	(1ULL << I40IW_CQPSQ_QP_TOECTXVALID_SHIFT)

#define I40IW_CQPSQ_QP_CACHEDVARVALID_SHIFT 44
#define I40IW_CQPSQ_QP_CACHEDVARVALID_MASK      \
	(1ULL << I40IW_CQPSQ_QP_CACHEDVARVALID_SHIFT)

#define I40IW_CQPSQ_QP_VQ_SHIFT 45
#define I40IW_CQPSQ_QP_VQ_MASK (1ULL << I40IW_CQPSQ_QP_VQ_SHIFT)

#define I40IW_CQPSQ_QP_FORCELOOPBACK_SHIFT 46
#define I40IW_CQPSQ_QP_FORCELOOPBACK_MASK       \
	(1ULL << I40IW_CQPSQ_QP_FORCELOOPBACK_SHIFT)

#define I40IW_CQPSQ_QP_CQNUMVALID_SHIFT 47
#define I40IW_CQPSQ_QP_CQNUMVALID_MASK  \
	(1ULL << I40IW_CQPSQ_QP_CQNUMVALID_SHIFT)

#define I40IW_CQPSQ_QP_QPTYPE_SHIFT 48
#define I40IW_CQPSQ_QP_QPTYPE_MASK (0x3ULL << I40IW_CQPSQ_QP_QPTYPE_SHIFT)

#define I40IW_CQPSQ_QP_MSSCHANGE_SHIFT 52
#define I40IW_CQPSQ_QP_MSSCHANGE_MASK (1ULL << I40IW_CQPSQ_QP_MSSCHANGE_SHIFT)

#define I40IW_CQPSQ_QP_IGNOREMWBOUND_SHIFT 54
#define I40IW_CQPSQ_QP_IGNOREMWBOUND_MASK       \
	(1ULL << I40IW_CQPSQ_QP_IGNOREMWBOUND_SHIFT)

#define I40IW_CQPSQ_QP_REMOVEHASHENTRY_SHIFT 55
#define I40IW_CQPSQ_QP_REMOVEHASHENTRY_MASK     \
	(1ULL << I40IW_CQPSQ_QP_REMOVEHASHENTRY_SHIFT)

#define I40IW_CQPSQ_QP_TERMACT_SHIFT 56
#define I40IW_CQPSQ_QP_TERMACT_MASK (0x3ULL << I40IW_CQPSQ_QP_TERMACT_SHIFT)

#define I40IW_CQPSQ_QP_RESETCON_SHIFT 58
#define I40IW_CQPSQ_QP_RESETCON_MASK (1ULL << I40IW_CQPSQ_QP_RESETCON_SHIFT)

#define I40IW_CQPSQ_QP_ARPTABIDXVALID_SHIFT 59
#define I40IW_CQPSQ_QP_ARPTABIDXVALID_MASK      \
	(1ULL << I40IW_CQPSQ_QP_ARPTABIDXVALID_SHIFT)

#define I40IW_CQPSQ_QP_NEXTIWSTATE_SHIFT 60
#define I40IW_CQPSQ_QP_NEXTIWSTATE_MASK \
	(0x7ULL << I40IW_CQPSQ_QP_NEXTIWSTATE_SHIFT)

#define I40IW_CQPSQ_QP_DBSHADOWADDR_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_QP_DBSHADOWADDR_MASK I40IW_CQPHC_QPCTX_MASK

/* Create/Modify/Destroy CQ */
#define I40IW_CQPSQ_CQ_CQSIZE_SHIFT 0
#define I40IW_CQPSQ_CQ_CQSIZE_MASK (0x3ffffUL << I40IW_CQPSQ_CQ_CQSIZE_SHIFT)

#define I40IW_CQPSQ_CQ_CQCTX_SHIFT 0
#define I40IW_CQPSQ_CQ_CQCTX_MASK       \
	(0x7fffffffffffffffULL << I40IW_CQPSQ_CQ_CQCTX_SHIFT)

#define I40IW_CQPSQ_CQ_CQCTX_SHIFT 0
#define I40IW_CQPSQ_CQ_CQCTX_MASK       \
	(0x7fffffffffffffffULL << I40IW_CQPSQ_CQ_CQCTX_SHIFT)

#define I40IW_CQPSQ_CQ_SHADOW_READ_THRESHOLD_SHIFT 0
#define I40IW_CQPSQ_CQ_SHADOW_READ_THRESHOLD_MASK       \
	(0x3ffff << I40IW_CQPSQ_CQ_SHADOW_READ_THRESHOLD_SHIFT)

#define I40IW_CQPSQ_CQ_CEQID_SHIFT 24
#define I40IW_CQPSQ_CQ_CEQID_MASK (0x7fUL << I40IW_CQPSQ_CQ_CEQID_SHIFT)

#define I40IW_CQPSQ_CQ_OP_SHIFT 32
#define I40IW_CQPSQ_CQ_OP_MASK (0x3fULL << I40IW_CQPSQ_CQ_OP_SHIFT)

#define I40IW_CQPSQ_CQ_CQRESIZE_SHIFT 43
#define I40IW_CQPSQ_CQ_CQRESIZE_MASK (1ULL << I40IW_CQPSQ_CQ_CQRESIZE_SHIFT)

#define I40IW_CQPSQ_CQ_LPBLSIZE_SHIFT 44
#define I40IW_CQPSQ_CQ_LPBLSIZE_MASK (3ULL << I40IW_CQPSQ_CQ_LPBLSIZE_SHIFT)

#define I40IW_CQPSQ_CQ_CHKOVERFLOW_SHIFT 46
#define I40IW_CQPSQ_CQ_CHKOVERFLOW_MASK         \
	(1ULL << I40IW_CQPSQ_CQ_CHKOVERFLOW_SHIFT)

#define I40IW_CQPSQ_CQ_VIRTMAP_SHIFT 47
#define I40IW_CQPSQ_CQ_VIRTMAP_MASK (1ULL << I40IW_CQPSQ_CQ_VIRTMAP_SHIFT)

#define I40IW_CQPSQ_CQ_ENCEQEMASK_SHIFT 48
#define I40IW_CQPSQ_CQ_ENCEQEMASK_MASK  \
	(1ULL << I40IW_CQPSQ_CQ_ENCEQEMASK_SHIFT)

#define I40IW_CQPSQ_CQ_CEQIDVALID_SHIFT 49
#define I40IW_CQPSQ_CQ_CEQIDVALID_MASK  \
	(1ULL << I40IW_CQPSQ_CQ_CEQIDVALID_SHIFT)

#define I40IW_CQPSQ_CQ_AVOIDMEMCNFLCT_SHIFT 61
#define I40IW_CQPSQ_CQ_AVOIDMEMCNFLCT_MASK      \
	(1ULL << I40IW_CQPSQ_CQ_AVOIDMEMCNFLCT_SHIFT)

/* Create/Modify/Destroy Shared Receive Queue */

#define I40IW_CQPSQ_SRQ_RQSIZE_SHIFT 0
#define I40IW_CQPSQ_SRQ_RQSIZE_MASK (0xfUL << I40IW_CQPSQ_SRQ_RQSIZE_SHIFT)

#define I40IW_CQPSQ_SRQ_RQWQESIZE_SHIFT 4
#define I40IW_CQPSQ_SRQ_RQWQESIZE_MASK \
	(0x7UL << I40IW_CQPSQ_SRQ_RQWQESIZE_SHIFT)

#define I40IW_CQPSQ_SRQ_SRQLIMIT_SHIFT 32
#define I40IW_CQPSQ_SRQ_SRQLIMIT_MASK   \
	(0xfffULL << I40IW_CQPSQ_SRQ_SRQLIMIT_SHIFT)

#define I40IW_CQPSQ_SRQ_SRQCTX_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_SRQ_SRQCTX_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_SRQ_PDID_SHIFT 16
#define I40IW_CQPSQ_SRQ_PDID_MASK       \
	(0x7fffULL << I40IW_CQPSQ_SRQ_PDID_SHIFT)

#define I40IW_CQPSQ_SRQ_SRQID_SHIFT 0
#define I40IW_CQPSQ_SRQ_SRQID_MASK (0x7fffUL << I40IW_CQPSQ_SRQ_SRQID_SHIFT)

#define I40IW_CQPSQ_SRQ_LPBLSIZE_SHIFT I40IW_CQPSQ_CQ_LPBLSIZE_SHIFT
#define I40IW_CQPSQ_SRQ_LPBLSIZE_MASK I40IW_CQPSQ_CQ_LPBLSIZE_MASK

#define I40IW_CQPSQ_SRQ_VIRTMAP_SHIFT I40IW_CQPSQ_CQ_VIRTMAP_SHIFT
#define I40IW_CQPSQ_SRQ_VIRTMAP_MASK I40IW_CQPSQ_CQ_VIRTMAP_MASK

#define I40IW_CQPSQ_SRQ_TPHEN_SHIFT I40IW_CQPSQ_TPHEN_SHIFT
#define I40IW_CQPSQ_SRQ_TPHEN_MASK I40IW_CQPSQ_TPHEN_MASK

#define I40IW_CQPSQ_SRQ_ARMLIMITEVENT_SHIFT 61
#define I40IW_CQPSQ_SRQ_ARMLIMITEVENT_MASK      \
	(1ULL << I40IW_CQPSQ_SRQ_ARMLIMITEVENT_SHIFT)

#define I40IW_CQPSQ_SRQ_DBSHADOWAREA_SHIFT 6
#define I40IW_CQPSQ_SRQ_DBSHADOWAREA_MASK       \
	(0x3ffffffffffffffULL << I40IW_CQPSQ_SRQ_DBSHADOWAREA_SHIFT)

#define I40IW_CQPSQ_SRQ_FIRSTPMPBLIDX_SHIFT 0
#define I40IW_CQPSQ_SRQ_FIRSTPMPBLIDX_MASK      \
	(0xfffffffUL << I40IW_CQPSQ_SRQ_FIRSTPMPBLIDX_SHIFT)

/* Allocate/Register/Register Shared/Deallocate Stag */
#define I40IW_CQPSQ_STAG_VA_FBO_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_STAG_VA_FBO_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_STAG_STAGLEN_SHIFT 0
#define I40IW_CQPSQ_STAG_STAGLEN_MASK   \
	(0x3fffffffffffULL << I40IW_CQPSQ_STAG_STAGLEN_SHIFT)

#define I40IW_CQPSQ_STAG_PDID_SHIFT 48
#define I40IW_CQPSQ_STAG_PDID_MASK (0x7fffULL << I40IW_CQPSQ_STAG_PDID_SHIFT)

#define I40IW_CQPSQ_STAG_KEY_SHIFT 0
#define I40IW_CQPSQ_STAG_KEY_MASK (0xffUL << I40IW_CQPSQ_STAG_KEY_SHIFT)

#define I40IW_CQPSQ_STAG_IDX_SHIFT 8
#define I40IW_CQPSQ_STAG_IDX_MASK (0xffffffUL << I40IW_CQPSQ_STAG_IDX_SHIFT)

#define I40IW_CQPSQ_STAG_PARENTSTAGIDX_SHIFT 32
#define I40IW_CQPSQ_STAG_PARENTSTAGIDX_MASK     \
	(0xffffffULL << I40IW_CQPSQ_STAG_PARENTSTAGIDX_SHIFT)

#define I40IW_CQPSQ_STAG_MR_SHIFT 43
#define I40IW_CQPSQ_STAG_MR_MASK (1ULL << I40IW_CQPSQ_STAG_MR_SHIFT)

#define I40IW_CQPSQ_STAG_LPBLSIZE_SHIFT I40IW_CQPSQ_CQ_LPBLSIZE_SHIFT
#define I40IW_CQPSQ_STAG_LPBLSIZE_MASK I40IW_CQPSQ_CQ_LPBLSIZE_MASK

#define I40IW_CQPSQ_STAG_HPAGESIZE_SHIFT 46
#define I40IW_CQPSQ_STAG_HPAGESIZE_MASK \
	(1ULL << I40IW_CQPSQ_STAG_HPAGESIZE_SHIFT)

#define I40IW_CQPSQ_STAG_ARIGHTS_SHIFT 48
#define I40IW_CQPSQ_STAG_ARIGHTS_MASK   \
	(0x1fULL << I40IW_CQPSQ_STAG_ARIGHTS_SHIFT)

#define I40IW_CQPSQ_STAG_REMACCENABLED_SHIFT 53
#define I40IW_CQPSQ_STAG_REMACCENABLED_MASK     \
	(1ULL << I40IW_CQPSQ_STAG_REMACCENABLED_SHIFT)

#define I40IW_CQPSQ_STAG_VABASEDTO_SHIFT 59
#define I40IW_CQPSQ_STAG_VABASEDTO_MASK \
	(1ULL << I40IW_CQPSQ_STAG_VABASEDTO_SHIFT)

#define I40IW_CQPSQ_STAG_USEHMCFNIDX_SHIFT 60
#define I40IW_CQPSQ_STAG_USEHMCFNIDX_MASK       \
	(1ULL << I40IW_CQPSQ_STAG_USEHMCFNIDX_SHIFT)

#define I40IW_CQPSQ_STAG_USEPFRID_SHIFT 61
#define I40IW_CQPSQ_STAG_USEPFRID_MASK  \
	(1ULL << I40IW_CQPSQ_STAG_USEPFRID_SHIFT)

#define I40IW_CQPSQ_STAG_PBA_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_STAG_PBA_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_STAG_HMCFNIDX_SHIFT 0
#define I40IW_CQPSQ_STAG_HMCFNIDX_MASK \
	(0x3fUL << I40IW_CQPSQ_STAG_HMCFNIDX_SHIFT)

#define I40IW_CQPSQ_STAG_FIRSTPMPBLIDX_SHIFT 0
#define I40IW_CQPSQ_STAG_FIRSTPMPBLIDX_MASK     \
	(0xfffffffUL << I40IW_CQPSQ_STAG_FIRSTPMPBLIDX_SHIFT)

/* Query stag */
#define I40IW_CQPSQ_QUERYSTAG_IDX_SHIFT I40IW_CQPSQ_STAG_IDX_SHIFT
#define I40IW_CQPSQ_QUERYSTAG_IDX_MASK I40IW_CQPSQ_STAG_IDX_MASK

/* Allocate Local IP Address Entry */

/* Manage Local IP Address Table - MLIPA */
#define I40IW_CQPSQ_MLIPA_IPV6LO_SHIFT  I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_MLIPA_IPV6LO_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_MLIPA_IPV6HI_SHIFT  I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_MLIPA_IPV6HI_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_MLIPA_IPV4_SHIFT 0
#define I40IW_CQPSQ_MLIPA_IPV4_MASK \
	(0xffffffffUL << I40IW_CQPSQ_MLIPA_IPV4_SHIFT)

#define I40IW_CQPSQ_MLIPA_IPTABLEIDX_SHIFT 0
#define I40IW_CQPSQ_MLIPA_IPTABLEIDX_MASK       \
	(0x3fUL << I40IW_CQPSQ_MLIPA_IPTABLEIDX_SHIFT)

#define I40IW_CQPSQ_MLIPA_IPV4VALID_SHIFT 42
#define I40IW_CQPSQ_MLIPA_IPV4VALID_MASK        \
	(1ULL << I40IW_CQPSQ_MLIPA_IPV4VALID_SHIFT)

#define I40IW_CQPSQ_MLIPA_IPV6VALID_SHIFT 43
#define I40IW_CQPSQ_MLIPA_IPV6VALID_MASK        \
	(1ULL << I40IW_CQPSQ_MLIPA_IPV6VALID_SHIFT)

#define I40IW_CQPSQ_MLIPA_FREEENTRY_SHIFT 62
#define I40IW_CQPSQ_MLIPA_FREEENTRY_MASK        \
	(1ULL << I40IW_CQPSQ_MLIPA_FREEENTRY_SHIFT)

#define I40IW_CQPSQ_MLIPA_IGNORE_REF_CNT_SHIFT 61
#define I40IW_CQPSQ_MLIPA_IGNORE_REF_CNT_MASK   \
	(1ULL << I40IW_CQPSQ_MLIPA_IGNORE_REF_CNT_SHIFT)

#define I40IW_CQPSQ_MLIPA_MAC0_SHIFT 0
#define I40IW_CQPSQ_MLIPA_MAC0_MASK (0xffUL << I40IW_CQPSQ_MLIPA_MAC0_SHIFT)

#define I40IW_CQPSQ_MLIPA_MAC1_SHIFT 8
#define I40IW_CQPSQ_MLIPA_MAC1_MASK (0xffUL << I40IW_CQPSQ_MLIPA_MAC1_SHIFT)

#define I40IW_CQPSQ_MLIPA_MAC2_SHIFT 16
#define I40IW_CQPSQ_MLIPA_MAC2_MASK (0xffUL << I40IW_CQPSQ_MLIPA_MAC2_SHIFT)

#define I40IW_CQPSQ_MLIPA_MAC3_SHIFT 24
#define I40IW_CQPSQ_MLIPA_MAC3_MASK (0xffUL << I40IW_CQPSQ_MLIPA_MAC3_SHIFT)

#define I40IW_CQPSQ_MLIPA_MAC4_SHIFT 32
#define I40IW_CQPSQ_MLIPA_MAC4_MASK (0xffULL << I40IW_CQPSQ_MLIPA_MAC4_SHIFT)

#define I40IW_CQPSQ_MLIPA_MAC5_SHIFT 40
#define I40IW_CQPSQ_MLIPA_MAC5_MASK (0xffULL << I40IW_CQPSQ_MLIPA_MAC5_SHIFT)

/* Manage ARP Table  - MAT */
#define I40IW_CQPSQ_MAT_REACHMAX_SHIFT 0
#define I40IW_CQPSQ_MAT_REACHMAX_MASK   \
	(0xffffffffUL << I40IW_CQPSQ_MAT_REACHMAX_SHIFT)

#define I40IW_CQPSQ_MAT_MACADDR_SHIFT 0
#define I40IW_CQPSQ_MAT_MACADDR_MASK    \
	(0xffffffffffffULL << I40IW_CQPSQ_MAT_MACADDR_SHIFT)

#define I40IW_CQPSQ_MAT_ARPENTRYIDX_SHIFT 0
#define I40IW_CQPSQ_MAT_ARPENTRYIDX_MASK        \
	(0xfffUL << I40IW_CQPSQ_MAT_ARPENTRYIDX_SHIFT)

#define I40IW_CQPSQ_MAT_ENTRYVALID_SHIFT 42
#define I40IW_CQPSQ_MAT_ENTRYVALID_MASK \
	(1ULL << I40IW_CQPSQ_MAT_ENTRYVALID_SHIFT)

#define I40IW_CQPSQ_MAT_PERMANENT_SHIFT 43
#define I40IW_CQPSQ_MAT_PERMANENT_MASK  \
	(1ULL << I40IW_CQPSQ_MAT_PERMANENT_SHIFT)

#define I40IW_CQPSQ_MAT_QUERY_SHIFT 44
#define I40IW_CQPSQ_MAT_QUERY_MASK (1ULL << I40IW_CQPSQ_MAT_QUERY_SHIFT)

/* Manage VF PBLE Backing Pages - MVPBP*/
#define I40IW_CQPSQ_MVPBP_PD_ENTRY_CNT_SHIFT 0
#define I40IW_CQPSQ_MVPBP_PD_ENTRY_CNT_MASK \
	(0x3ffULL << I40IW_CQPSQ_MVPBP_PD_ENTRY_CNT_SHIFT)

#define I40IW_CQPSQ_MVPBP_FIRST_PD_INX_SHIFT 16
#define I40IW_CQPSQ_MVPBP_FIRST_PD_INX_MASK \
	(0x1ffULL << I40IW_CQPSQ_MVPBP_FIRST_PD_INX_SHIFT)

#define I40IW_CQPSQ_MVPBP_SD_INX_SHIFT 32
#define I40IW_CQPSQ_MVPBP_SD_INX_MASK \
	(0xfffULL << I40IW_CQPSQ_MVPBP_SD_INX_SHIFT)

#define I40IW_CQPSQ_MVPBP_INV_PD_ENT_SHIFT 62
#define I40IW_CQPSQ_MVPBP_INV_PD_ENT_MASK \
	(0x1ULL << I40IW_CQPSQ_MVPBP_INV_PD_ENT_SHIFT)

#define I40IW_CQPSQ_MVPBP_PD_PLPBA_SHIFT 3
#define I40IW_CQPSQ_MVPBP_PD_PLPBA_MASK \
	(0x1fffffffffffffffULL << I40IW_CQPSQ_MVPBP_PD_PLPBA_SHIFT)

/* Manage Push Page - MPP */
#define I40IW_INVALID_PUSH_PAGE_INDEX 0xffff

#define I40IW_CQPSQ_MPP_QS_HANDLE_SHIFT 0
#define I40IW_CQPSQ_MPP_QS_HANDLE_MASK (0xffffUL << \
					I40IW_CQPSQ_MPP_QS_HANDLE_SHIFT)

#define I40IW_CQPSQ_MPP_PPIDX_SHIFT 0
#define I40IW_CQPSQ_MPP_PPIDX_MASK (0x3ffUL << I40IW_CQPSQ_MPP_PPIDX_SHIFT)

#define I40IW_CQPSQ_MPP_FREE_PAGE_SHIFT 62
#define I40IW_CQPSQ_MPP_FREE_PAGE_MASK (1ULL << I40IW_CQPSQ_MPP_FREE_PAGE_SHIFT)

/* Upload Context - UCTX */
#define I40IW_CQPSQ_UCTX_QPCTXADDR_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IW_CQPSQ_UCTX_QPCTXADDR_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IW_CQPSQ_UCTX_QPID_SHIFT 0
#define I40IW_CQPSQ_UCTX_QPID_MASK (0x3ffffUL << I40IW_CQPSQ_UCTX_QPID_SHIFT)

#define I40IW_CQPSQ_UCTX_QPTYPE_SHIFT 48
#define I40IW_CQPSQ_UCTX_QPTYPE_MASK (0xfULL << I40IW_CQPSQ_UCTX_QPTYPE_SHIFT)

#define I40IW_CQPSQ_UCTX_RAWFORMAT_SHIFT 61
#define I40IW_CQPSQ_UCTX_RAWFORMAT_MASK \
	(1ULL << I40IW_CQPSQ_UCTX_RAWFORMAT_SHIFT)

#define I40IW_CQPSQ_UCTX_FREEZEQP_SHIFT 62
#define I40IW_CQPSQ_UCTX_FREEZEQP_MASK  \
	(1ULL << I40IW_CQPSQ_UCTX_FREEZEQP_SHIFT)

/* Manage HMC PM Function Table - MHMC */
#define I40IW_CQPSQ_MHMC_VFIDX_SHIFT 0
#define I40IW_CQPSQ_MHMC_VFIDX_MASK (0x7fUL << I40IW_CQPSQ_MHMC_VFIDX_SHIFT)

#define I40IW_CQPSQ_MHMC_FREEPMFN_SHIFT 62
#define I40IW_CQPSQ_MHMC_FREEPMFN_MASK  \
	(1ULL << I40IW_CQPSQ_MHMC_FREEPMFN_SHIFT)

/* Set HMC Resource Profile - SHMCRP */
#define I40IW_CQPSQ_SHMCRP_HMC_PROFILE_SHIFT 0
#define I40IW_CQPSQ_SHMCRP_HMC_PROFILE_MASK \
	(0x7ULL << I40IW_CQPSQ_SHMCRP_HMC_PROFILE_SHIFT)
#define I40IW_CQPSQ_SHMCRP_VFNUM_SHIFT 32
#define I40IW_CQPSQ_SHMCRP_VFNUM_MASK (0x3fULL << I40IW_CQPSQ_SHMCRP_VFNUM_SHIFT)

/* Create/Destroy CEQ */
#define I40IW_CQPSQ_CEQ_CEQSIZE_SHIFT 0
#define I40IW_CQPSQ_CEQ_CEQSIZE_MASK \
	(0x1ffffUL << I40IW_CQPSQ_CEQ_CEQSIZE_SHIFT)

#define I40IW_CQPSQ_CEQ_CEQID_SHIFT 0
#define I40IW_CQPSQ_CEQ_CEQID_MASK (0x7fUL << I40IW_CQPSQ_CEQ_CEQID_SHIFT)

#define I40IW_CQPSQ_CEQ_LPBLSIZE_SHIFT I40IW_CQPSQ_CQ_LPBLSIZE_SHIFT
#define I40IW_CQPSQ_CEQ_LPBLSIZE_MASK I40IW_CQPSQ_CQ_LPBLSIZE_MASK

#define I40IW_CQPSQ_CEQ_VMAP_SHIFT 47
#define I40IW_CQPSQ_CEQ_VMAP_MASK (1ULL << I40IW_CQPSQ_CEQ_VMAP_SHIFT)

#define I40IW_CQPSQ_CEQ_FIRSTPMPBLIDX_SHIFT 0
#define I40IW_CQPSQ_CEQ_FIRSTPMPBLIDX_MASK      \
	(0xfffffffUL << I40IW_CQPSQ_CEQ_FIRSTPMPBLIDX_SHIFT)

/* Create/Destroy AEQ */
#define I40IW_CQPSQ_AEQ_AEQECNT_SHIFT 0
#define I40IW_CQPSQ_AEQ_AEQECNT_MASK \
	(0x7ffffUL << I40IW_CQPSQ_AEQ_AEQECNT_SHIFT)

#define I40IW_CQPSQ_AEQ_LPBLSIZE_SHIFT I40IW_CQPSQ_CQ_LPBLSIZE_SHIFT
#define I40IW_CQPSQ_AEQ_LPBLSIZE_MASK I40IW_CQPSQ_CQ_LPBLSIZE_MASK

#define I40IW_CQPSQ_AEQ_VMAP_SHIFT 47
#define I40IW_CQPSQ_AEQ_VMAP_MASK (1ULL << I40IW_CQPSQ_AEQ_VMAP_SHIFT)

#define I40IW_CQPSQ_AEQ_FIRSTPMPBLIDX_SHIFT 0
#define I40IW_CQPSQ_AEQ_FIRSTPMPBLIDX_MASK      \
	(0xfffffffUL << I40IW_CQPSQ_AEQ_FIRSTPMPBLIDX_SHIFT)

/* Commit FPM Values - CFPM */
#define I40IW_CQPSQ_CFPM_HMCFNID_SHIFT 0
#define I40IW_CQPSQ_CFPM_HMCFNID_MASK (0x3fUL << I40IW_CQPSQ_CFPM_HMCFNID_SHIFT)

/* Flush WQEs - FWQE */
#define I40IW_CQPSQ_FWQE_AECODE_SHIFT 0
#define I40IW_CQPSQ_FWQE_AECODE_MASK (0xffffUL << I40IW_CQPSQ_FWQE_AECODE_SHIFT)

#define I40IW_CQPSQ_FWQE_AESOURCE_SHIFT 16
#define I40IW_CQPSQ_FWQE_AESOURCE_MASK \
	(0xfUL << I40IW_CQPSQ_FWQE_AESOURCE_SHIFT)

#define I40IW_CQPSQ_FWQE_RQMNERR_SHIFT 0
#define I40IW_CQPSQ_FWQE_RQMNERR_MASK \
	(0xffffUL << I40IW_CQPSQ_FWQE_RQMNERR_SHIFT)

#define I40IW_CQPSQ_FWQE_RQMJERR_SHIFT 16
#define I40IW_CQPSQ_FWQE_RQMJERR_MASK \
	(0xffffUL << I40IW_CQPSQ_FWQE_RQMJERR_SHIFT)

#define I40IW_CQPSQ_FWQE_SQMNERR_SHIFT 32
#define I40IW_CQPSQ_FWQE_SQMNERR_MASK   \
	(0xffffULL << I40IW_CQPSQ_FWQE_SQMNERR_SHIFT)

#define I40IW_CQPSQ_FWQE_SQMJERR_SHIFT 48
#define I40IW_CQPSQ_FWQE_SQMJERR_MASK   \
	(0xffffULL << I40IW_CQPSQ_FWQE_SQMJERR_SHIFT)

#define I40IW_CQPSQ_FWQE_QPID_SHIFT 0
#define I40IW_CQPSQ_FWQE_QPID_MASK (0x3ffffULL << I40IW_CQPSQ_FWQE_QPID_SHIFT)

#define I40IW_CQPSQ_FWQE_GENERATE_AE_SHIFT 59
#define I40IW_CQPSQ_FWQE_GENERATE_AE_MASK (1ULL <<      \
					   I40IW_CQPSQ_FWQE_GENERATE_AE_SHIFT)

#define I40IW_CQPSQ_FWQE_USERFLCODE_SHIFT 60
#define I40IW_CQPSQ_FWQE_USERFLCODE_MASK        \
	(1ULL << I40IW_CQPSQ_FWQE_USERFLCODE_SHIFT)

#define I40IW_CQPSQ_FWQE_FLUSHSQ_SHIFT 61
#define I40IW_CQPSQ_FWQE_FLUSHSQ_MASK (1ULL << I40IW_CQPSQ_FWQE_FLUSHSQ_SHIFT)

#define I40IW_CQPSQ_FWQE_FLUSHRQ_SHIFT 62
#define I40IW_CQPSQ_FWQE_FLUSHRQ_MASK (1ULL << I40IW_CQPSQ_FWQE_FLUSHRQ_SHIFT)

/* Manage Accelerated Port Table - MAPT */
#define I40IW_CQPSQ_MAPT_PORT_SHIFT 0
#define I40IW_CQPSQ_MAPT_PORT_MASK (0xffffUL << I40IW_CQPSQ_MAPT_PORT_SHIFT)

#define I40IW_CQPSQ_MAPT_ADDPORT_SHIFT 62
#define I40IW_CQPSQ_MAPT_ADDPORT_MASK (1ULL << I40IW_CQPSQ_MAPT_ADDPORT_SHIFT)

/* Update Protocol Engine SDs */
#define I40IW_CQPSQ_UPESD_SDCMD_SHIFT 0
#define I40IW_CQPSQ_UPESD_SDCMD_MASK (0xffffffffUL << I40IW_CQPSQ_UPESD_SDCMD_SHIFT)

#define I40IW_CQPSQ_UPESD_SDDATALOW_SHIFT 0
#define I40IW_CQPSQ_UPESD_SDDATALOW_MASK        \
	(0xffffffffUL << I40IW_CQPSQ_UPESD_SDDATALOW_SHIFT)

#define I40IW_CQPSQ_UPESD_SDDATAHI_SHIFT 32
#define I40IW_CQPSQ_UPESD_SDDATAHI_MASK \
	(0xffffffffULL << I40IW_CQPSQ_UPESD_SDDATAHI_SHIFT)
#define I40IW_CQPSQ_UPESD_HMCFNID_SHIFT 0
#define I40IW_CQPSQ_UPESD_HMCFNID_MASK  \
	(0x3fUL << I40IW_CQPSQ_UPESD_HMCFNID_SHIFT)

#define I40IW_CQPSQ_UPESD_ENTRY_VALID_SHIFT 63
#define I40IW_CQPSQ_UPESD_ENTRY_VALID_MASK      \
	((u64)1 << I40IW_CQPSQ_UPESD_ENTRY_VALID_SHIFT)

#define I40IW_CQPSQ_UPESD_ENTRY_COUNT_SHIFT 0
#define I40IW_CQPSQ_UPESD_ENTRY_COUNT_MASK      \
	(0xfUL << I40IW_CQPSQ_UPESD_ENTRY_COUNT_SHIFT)

#define I40IW_CQPSQ_UPESD_SKIP_ENTRY_SHIFT 7
#define I40IW_CQPSQ_UPESD_SKIP_ENTRY_MASK       \
	(0x1UL << I40IW_CQPSQ_UPESD_SKIP_ENTRY_SHIFT)

/* Suspend QP */
#define I40IW_CQPSQ_SUSPENDQP_QPID_SHIFT 0
#define I40IW_CQPSQ_SUSPENDQP_QPID_MASK (0x3FFFFUL)
/* I40IWCQ_QPID_MASK */

/* Resume QP */
#define I40IW_CQPSQ_RESUMEQP_QSHANDLE_SHIFT 0
#define I40IW_CQPSQ_RESUMEQP_QSHANDLE_MASK      \
	(0xffffffffUL << I40IW_CQPSQ_RESUMEQP_QSHANDLE_SHIFT)

#define I40IW_CQPSQ_RESUMEQP_QPID_SHIFT 0
#define I40IW_CQPSQ_RESUMEQP_QPID_MASK (0x3FFFFUL)
/* I40IWCQ_QPID_MASK */

/* IW QP Context */
#define I40IWQPC_DDP_VER_SHIFT 0
#define I40IWQPC_DDP_VER_MASK (3UL << I40IWQPC_DDP_VER_SHIFT)

#define I40IWQPC_SNAP_SHIFT 2
#define I40IWQPC_SNAP_MASK (1UL << I40IWQPC_SNAP_SHIFT)

#define I40IWQPC_IPV4_SHIFT 3
#define I40IWQPC_IPV4_MASK (1UL << I40IWQPC_IPV4_SHIFT)

#define I40IWQPC_NONAGLE_SHIFT 4
#define I40IWQPC_NONAGLE_MASK (1UL << I40IWQPC_NONAGLE_SHIFT)

#define I40IWQPC_INSERTVLANTAG_SHIFT 5
#define I40IWQPC_INSERTVLANTAG_MASK (1 << I40IWQPC_INSERTVLANTAG_SHIFT)

#define I40IWQPC_USESRQ_SHIFT 6
#define I40IWQPC_USESRQ_MASK (1UL << I40IWQPC_USESRQ_SHIFT)

#define I40IWQPC_TIMESTAMP_SHIFT 7
#define I40IWQPC_TIMESTAMP_MASK (1UL << I40IWQPC_TIMESTAMP_SHIFT)

#define I40IWQPC_RQWQESIZE_SHIFT 8
#define I40IWQPC_RQWQESIZE_MASK (3UL << I40IWQPC_RQWQESIZE_SHIFT)

#define I40IWQPC_INSERTL2TAG2_SHIFT 11
#define I40IWQPC_INSERTL2TAG2_MASK (1UL << I40IWQPC_INSERTL2TAG2_SHIFT)

#define I40IWQPC_LIMIT_SHIFT 12
#define I40IWQPC_LIMIT_MASK (3UL << I40IWQPC_LIMIT_SHIFT)

#define I40IWQPC_DROPOOOSEG_SHIFT 15
#define I40IWQPC_DROPOOOSEG_MASK (1UL << I40IWQPC_DROPOOOSEG_SHIFT)

#define I40IWQPC_DUPACK_THRESH_SHIFT 16
#define I40IWQPC_DUPACK_THRESH_MASK (7UL << I40IWQPC_DUPACK_THRESH_SHIFT)

#define I40IWQPC_ERR_RQ_IDX_VALID_SHIFT 19
#define I40IWQPC_ERR_RQ_IDX_VALID_MASK  (1UL << I40IWQPC_ERR_RQ_IDX_VALID_SHIFT)

#define I40IWQPC_DIS_VLAN_CHECKS_SHIFT 19
#define I40IWQPC_DIS_VLAN_CHECKS_MASK (7UL << I40IWQPC_DIS_VLAN_CHECKS_SHIFT)

#define I40IWQPC_RCVTPHEN_SHIFT 28
#define I40IWQPC_RCVTPHEN_MASK (1UL << I40IWQPC_RCVTPHEN_SHIFT)

#define I40IWQPC_XMITTPHEN_SHIFT 29
#define I40IWQPC_XMITTPHEN_MASK (1ULL << I40IWQPC_XMITTPHEN_SHIFT)

#define I40IWQPC_RQTPHEN_SHIFT 30
#define I40IWQPC_RQTPHEN_MASK (1UL << I40IWQPC_RQTPHEN_SHIFT)

#define I40IWQPC_SQTPHEN_SHIFT 31
#define I40IWQPC_SQTPHEN_MASK (1ULL << I40IWQPC_SQTPHEN_SHIFT)

#define I40IWQPC_PPIDX_SHIFT 32
#define I40IWQPC_PPIDX_MASK (0x3ffULL << I40IWQPC_PPIDX_SHIFT)

#define I40IWQPC_PMENA_SHIFT 47
#define I40IWQPC_PMENA_MASK (1ULL << I40IWQPC_PMENA_SHIFT)

#define I40IWQPC_RDMAP_VER_SHIFT 62
#define I40IWQPC_RDMAP_VER_MASK (3ULL << I40IWQPC_RDMAP_VER_SHIFT)

#define I40IWQPC_SQADDR_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPC_SQADDR_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IWQPC_RQADDR_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPC_RQADDR_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IWQPC_TTL_SHIFT 0
#define I40IWQPC_TTL_MASK (0xffUL << I40IWQPC_TTL_SHIFT)

#define I40IWQPC_RQSIZE_SHIFT 8
#define I40IWQPC_RQSIZE_MASK (0xfUL << I40IWQPC_RQSIZE_SHIFT)

#define I40IWQPC_SQSIZE_SHIFT 12
#define I40IWQPC_SQSIZE_MASK (0xfUL << I40IWQPC_SQSIZE_SHIFT)

#define I40IWQPC_SRCMACADDRIDX_SHIFT 16
#define I40IWQPC_SRCMACADDRIDX_MASK (0x3fUL << I40IWQPC_SRCMACADDRIDX_SHIFT)

#define I40IWQPC_AVOIDSTRETCHACK_SHIFT 23
#define I40IWQPC_AVOIDSTRETCHACK_MASK (1UL << I40IWQPC_AVOIDSTRETCHACK_SHIFT)

#define I40IWQPC_TOS_SHIFT 24
#define I40IWQPC_TOS_MASK (0xffUL << I40IWQPC_TOS_SHIFT)

#define I40IWQPC_SRCPORTNUM_SHIFT 32
#define I40IWQPC_SRCPORTNUM_MASK (0xffffULL << I40IWQPC_SRCPORTNUM_SHIFT)

#define I40IWQPC_DESTPORTNUM_SHIFT 48
#define I40IWQPC_DESTPORTNUM_MASK (0xffffULL << I40IWQPC_DESTPORTNUM_SHIFT)

#define I40IWQPC_DESTIPADDR0_SHIFT 32
#define I40IWQPC_DESTIPADDR0_MASK       \
	(0xffffffffULL << I40IWQPC_DESTIPADDR0_SHIFT)

#define I40IWQPC_DESTIPADDR1_SHIFT 0
#define I40IWQPC_DESTIPADDR1_MASK       \
	(0xffffffffULL << I40IWQPC_DESTIPADDR1_SHIFT)

#define I40IWQPC_DESTIPADDR2_SHIFT 32
#define I40IWQPC_DESTIPADDR2_MASK       \
	(0xffffffffULL << I40IWQPC_DESTIPADDR2_SHIFT)

#define I40IWQPC_DESTIPADDR3_SHIFT 0
#define I40IWQPC_DESTIPADDR3_MASK       \
	(0xffffffffULL << I40IWQPC_DESTIPADDR3_SHIFT)

#define I40IWQPC_SNDMSS_SHIFT 16
#define I40IWQPC_SNDMSS_MASK (0x3fffUL << I40IWQPC_SNDMSS_SHIFT)

#define I40IWQPC_MAXFRAMESIZE_SHIFT 16
#define I40IWQPC_MAXFRAMESIZE_MASK (0x3fffUL << I40IWQPC_MAXFRAMESIZE_SHIFT)

#define I40IWQPC_VLANTAG_SHIFT 32
#define I40IWQPC_VLANTAG_MASK (0xffffULL << I40IWQPC_VLANTAG_SHIFT)

#define I40IWQPC_ARPIDX_SHIFT 48
#define I40IWQPC_ARPIDX_MASK (0xffffULL << I40IWQPC_ARPIDX_SHIFT)

#define I40IWQPC_FLOWLABEL_SHIFT 0
#define I40IWQPC_FLOWLABEL_MASK (0xfffffUL << I40IWQPC_FLOWLABEL_SHIFT)

#define I40IWQPC_WSCALE_SHIFT 20
#define I40IWQPC_WSCALE_MASK (1UL << I40IWQPC_WSCALE_SHIFT)

#define I40IWQPC_KEEPALIVE_SHIFT 21
#define I40IWQPC_KEEPALIVE_MASK (1UL << I40IWQPC_KEEPALIVE_SHIFT)

#define I40IWQPC_IGNORE_TCP_OPT_SHIFT 22
#define I40IWQPC_IGNORE_TCP_OPT_MASK (1UL << I40IWQPC_IGNORE_TCP_OPT_SHIFT)

#define I40IWQPC_IGNORE_TCP_UNS_OPT_SHIFT 23
#define I40IWQPC_IGNORE_TCP_UNS_OPT_MASK        \
	(1UL << I40IWQPC_IGNORE_TCP_UNS_OPT_SHIFT)

#define I40IWQPC_TCPSTATE_SHIFT 28
#define I40IWQPC_TCPSTATE_MASK (0xfUL << I40IWQPC_TCPSTATE_SHIFT)

#define I40IWQPC_RCVSCALE_SHIFT 32
#define I40IWQPC_RCVSCALE_MASK (0xfULL << I40IWQPC_RCVSCALE_SHIFT)

#define I40IWQPC_SNDSCALE_SHIFT 40
#define I40IWQPC_SNDSCALE_MASK (0xfULL << I40IWQPC_SNDSCALE_SHIFT)

#define I40IWQPC_PDIDX_SHIFT 48
#define I40IWQPC_PDIDX_MASK (0x7fffULL << I40IWQPC_PDIDX_SHIFT)

#define I40IWQPC_KALIVE_TIMER_MAX_PROBES_SHIFT 16
#define I40IWQPC_KALIVE_TIMER_MAX_PROBES_MASK   \
	(0xffUL << I40IWQPC_KALIVE_TIMER_MAX_PROBES_SHIFT)

#define I40IWQPC_KEEPALIVE_INTERVAL_SHIFT 24
#define I40IWQPC_KEEPALIVE_INTERVAL_MASK        \
	(0xffUL << I40IWQPC_KEEPALIVE_INTERVAL_SHIFT)

#define I40IWQPC_TIMESTAMP_RECENT_SHIFT 0
#define I40IWQPC_TIMESTAMP_RECENT_MASK  \
	(0xffffffffUL << I40IWQPC_TIMESTAMP_RECENT_SHIFT)

#define I40IWQPC_TIMESTAMP_AGE_SHIFT 32
#define I40IWQPC_TIMESTAMP_AGE_MASK     \
	(0xffffffffULL << I40IWQPC_TIMESTAMP_AGE_SHIFT)

#define I40IWQPC_SNDNXT_SHIFT 0
#define I40IWQPC_SNDNXT_MASK (0xffffffffUL << I40IWQPC_SNDNXT_SHIFT)

#define I40IWQPC_SNDWND_SHIFT 32
#define I40IWQPC_SNDWND_MASK (0xffffffffULL << I40IWQPC_SNDWND_SHIFT)

#define I40IWQPC_RCVNXT_SHIFT 0
#define I40IWQPC_RCVNXT_MASK (0xffffffffUL << I40IWQPC_RCVNXT_SHIFT)

#define I40IWQPC_RCVWND_SHIFT 32
#define I40IWQPC_RCVWND_MASK (0xffffffffULL << I40IWQPC_RCVWND_SHIFT)

#define I40IWQPC_SNDMAX_SHIFT 0
#define I40IWQPC_SNDMAX_MASK (0xffffffffUL << I40IWQPC_SNDMAX_SHIFT)

#define I40IWQPC_SNDUNA_SHIFT 32
#define I40IWQPC_SNDUNA_MASK (0xffffffffULL << I40IWQPC_SNDUNA_SHIFT)

#define I40IWQPC_SRTT_SHIFT 0
#define I40IWQPC_SRTT_MASK (0xffffffffUL << I40IWQPC_SRTT_SHIFT)

#define I40IWQPC_RTTVAR_SHIFT 32
#define I40IWQPC_RTTVAR_MASK (0xffffffffULL << I40IWQPC_RTTVAR_SHIFT)

#define I40IWQPC_SSTHRESH_SHIFT 0
#define I40IWQPC_SSTHRESH_MASK (0xffffffffUL << I40IWQPC_SSTHRESH_SHIFT)

#define I40IWQPC_CWND_SHIFT 32
#define I40IWQPC_CWND_MASK (0xffffffffULL << I40IWQPC_CWND_SHIFT)

#define I40IWQPC_SNDWL1_SHIFT 0
#define I40IWQPC_SNDWL1_MASK (0xffffffffUL << I40IWQPC_SNDWL1_SHIFT)

#define I40IWQPC_SNDWL2_SHIFT 32
#define I40IWQPC_SNDWL2_MASK (0xffffffffULL << I40IWQPC_SNDWL2_SHIFT)

#define I40IWQPC_ERR_RQ_IDX_SHIFT 32
#define I40IWQPC_ERR_RQ_IDX_MASK  (0x3fffULL << I40IWQPC_ERR_RQ_IDX_SHIFT)

#define I40IWQPC_MAXSNDWND_SHIFT 0
#define I40IWQPC_MAXSNDWND_MASK (0xffffffffUL << I40IWQPC_MAXSNDWND_SHIFT)

#define I40IWQPC_REXMIT_THRESH_SHIFT 48
#define I40IWQPC_REXMIT_THRESH_MASK (0x3fULL << I40IWQPC_REXMIT_THRESH_SHIFT)

#define I40IWQPC_TXCQNUM_SHIFT 0
#define I40IWQPC_TXCQNUM_MASK (0x1ffffUL << I40IWQPC_TXCQNUM_SHIFT)

#define I40IWQPC_RXCQNUM_SHIFT 32
#define I40IWQPC_RXCQNUM_MASK (0x1ffffULL << I40IWQPC_RXCQNUM_SHIFT)

#define I40IWQPC_STAT_INDEX_SHIFT 0
#define I40IWQPC_STAT_INDEX_MASK (0x1fULL << I40IWQPC_STAT_INDEX_SHIFT)

#define I40IWQPC_Q2ADDR_SHIFT 0
#define I40IWQPC_Q2ADDR_MASK (0xffffffffffffff00ULL << I40IWQPC_Q2ADDR_SHIFT)

#define I40IWQPC_LASTBYTESENT_SHIFT 0
#define I40IWQPC_LASTBYTESENT_MASK (0xffUL << I40IWQPC_LASTBYTESENT_SHIFT)

#define I40IWQPC_SRQID_SHIFT 32
#define I40IWQPC_SRQID_MASK (0xffULL << I40IWQPC_SRQID_SHIFT)

#define I40IWQPC_ORDSIZE_SHIFT 0
#define I40IWQPC_ORDSIZE_MASK (0x7fUL << I40IWQPC_ORDSIZE_SHIFT)

#define I40IWQPC_IRDSIZE_SHIFT 16
#define I40IWQPC_IRDSIZE_MASK (0x3UL << I40IWQPC_IRDSIZE_SHIFT)

#define I40IWQPC_WRRDRSPOK_SHIFT 20
#define I40IWQPC_WRRDRSPOK_MASK (1UL << I40IWQPC_WRRDRSPOK_SHIFT)

#define I40IWQPC_RDOK_SHIFT 21
#define I40IWQPC_RDOK_MASK (1UL << I40IWQPC_RDOK_SHIFT)

#define I40IWQPC_SNDMARKERS_SHIFT 22
#define I40IWQPC_SNDMARKERS_MASK (1UL << I40IWQPC_SNDMARKERS_SHIFT)

#define I40IWQPC_BINDEN_SHIFT 23
#define I40IWQPC_BINDEN_MASK (1UL << I40IWQPC_BINDEN_SHIFT)

#define I40IWQPC_FASTREGEN_SHIFT 24
#define I40IWQPC_FASTREGEN_MASK (1UL << I40IWQPC_FASTREGEN_SHIFT)

#define I40IWQPC_PRIVEN_SHIFT 25
#define I40IWQPC_PRIVEN_MASK (1UL << I40IWQPC_PRIVEN_SHIFT)

#define I40IWQPC_USESTATSINSTANCE_SHIFT 26
#define I40IWQPC_USESTATSINSTANCE_MASK (1UL << I40IWQPC_USESTATSINSTANCE_SHIFT)

#define I40IWQPC_IWARPMODE_SHIFT 28
#define I40IWQPC_IWARPMODE_MASK (1UL << I40IWQPC_IWARPMODE_SHIFT)

#define I40IWQPC_RCVMARKERS_SHIFT 29
#define I40IWQPC_RCVMARKERS_MASK (1UL << I40IWQPC_RCVMARKERS_SHIFT)

#define I40IWQPC_ALIGNHDRS_SHIFT 30
#define I40IWQPC_ALIGNHDRS_MASK (1UL << I40IWQPC_ALIGNHDRS_SHIFT)

#define I40IWQPC_RCVNOMPACRC_SHIFT 31
#define I40IWQPC_RCVNOMPACRC_MASK (1UL << I40IWQPC_RCVNOMPACRC_SHIFT)

#define I40IWQPC_RCVMARKOFFSET_SHIFT 33
#define I40IWQPC_RCVMARKOFFSET_MASK (0x1ffULL << I40IWQPC_RCVMARKOFFSET_SHIFT)

#define I40IWQPC_SNDMARKOFFSET_SHIFT 48
#define I40IWQPC_SNDMARKOFFSET_MASK (0x1ffULL << I40IWQPC_SNDMARKOFFSET_SHIFT)

#define I40IWQPC_QPCOMPCTX_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPC_QPCOMPCTX_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IWQPC_SQTPHVAL_SHIFT 0
#define I40IWQPC_SQTPHVAL_MASK (0xffUL << I40IWQPC_SQTPHVAL_SHIFT)

#define I40IWQPC_RQTPHVAL_SHIFT 8
#define I40IWQPC_RQTPHVAL_MASK (0xffUL << I40IWQPC_RQTPHVAL_SHIFT)

#define I40IWQPC_QSHANDLE_SHIFT 16
#define I40IWQPC_QSHANDLE_MASK (0x3ffUL << I40IWQPC_QSHANDLE_SHIFT)

#define I40IWQPC_EXCEPTION_LAN_QUEUE_SHIFT 32
#define I40IWQPC_EXCEPTION_LAN_QUEUE_MASK (0xfffULL <<  \
					   I40IWQPC_EXCEPTION_LAN_QUEUE_SHIFT)

#define I40IWQPC_LOCAL_IPADDR3_SHIFT 0
#define I40IWQPC_LOCAL_IPADDR3_MASK \
	(0xffffffffUL << I40IWQPC_LOCAL_IPADDR3_SHIFT)

#define I40IWQPC_LOCAL_IPADDR2_SHIFT 32
#define I40IWQPC_LOCAL_IPADDR2_MASK     \
	(0xffffffffULL << I40IWQPC_LOCAL_IPADDR2_SHIFT)

#define I40IWQPC_LOCAL_IPADDR1_SHIFT 0
#define I40IWQPC_LOCAL_IPADDR1_MASK     \
	(0xffffffffUL << I40IWQPC_LOCAL_IPADDR1_SHIFT)

#define I40IWQPC_LOCAL_IPADDR0_SHIFT 32
#define I40IWQPC_LOCAL_IPADDR0_MASK     \
	(0xffffffffULL << I40IWQPC_LOCAL_IPADDR0_SHIFT)

/* wqe size considering 32 bytes per wqe*/
#define I40IW_QP_SW_MIN_WQSIZE 4		/*in WRs*/
#define I40IW_SQ_RSVD 2
#define I40IW_RQ_RSVD 1
#define I40IW_MAX_QUANTAS_PER_WR 2
#define I40IW_QP_SW_MAX_SQ_QUANTAS 2048
#define I40IW_QP_SW_MAX_RQ_QUANTAS 16384
#define I40IW_MAX_QP_WRS ((I40IW_QP_SW_MAX_SQ_QUANTAS / I40IW_MAX_QUANTAS_PER_WR) - 1)
#define I40IWQP_OP_RDMA_WRITE 0
#define I40IWQP_OP_RDMA_READ 1
#define I40IWQP_OP_RDMA_SEND 3
#define I40IWQP_OP_RDMA_SEND_INV 4
#define I40IWQP_OP_RDMA_SEND_SOL_EVENT 5
#define I40IWQP_OP_RDMA_SEND_SOL_EVENT_INV 6
#define I40IWQP_OP_BIND_MW 8
#define I40IWQP_OP_FAST_REGISTER 9
#define I40IWQP_OP_LOCAL_INVALIDATE 10
#define I40IWQP_OP_RDMA_READ_LOC_INV 11
#define I40IWQP_OP_NOP 12

#define I40IW_RSVD_SHIFT        41
#define I40IW_RSVD_MASK (0x7fffULL << I40IW_RSVD_SHIFT)

/* iwarp QP SQ WQE common fields */
#define I40IWQPSQ_OPCODE_SHIFT 32
#define I40IWQPSQ_OPCODE_MASK (0x3fULL << I40IWQPSQ_OPCODE_SHIFT)

#define I40IWQPSQ_ADDFRAGCNT_SHIFT 38
#define I40IWQPSQ_ADDFRAGCNT_MASK (0x7ULL << I40IWQPSQ_ADDFRAGCNT_SHIFT)

#define I40IWQPSQ_PUSHWQE_SHIFT 56
#define I40IWQPSQ_PUSHWQE_MASK (1ULL << I40IWQPSQ_PUSHWQE_SHIFT)

#define I40IWQPSQ_STREAMMODE_SHIFT 58
#define I40IWQPSQ_STREAMMODE_MASK (1ULL << I40IWQPSQ_STREAMMODE_SHIFT)

#define I40IWQPSQ_WAITFORRCVPDU_SHIFT 59
#define I40IWQPSQ_WAITFORRCVPDU_MASK (1ULL << I40IWQPSQ_WAITFORRCVPDU_SHIFT)

#define I40IWQPSQ_READFENCE_SHIFT 60
#define I40IWQPSQ_READFENCE_MASK (1ULL << I40IWQPSQ_READFENCE_SHIFT)

#define I40IWQPSQ_LOCALFENCE_SHIFT 61
#define I40IWQPSQ_LOCALFENCE_MASK (1ULL << I40IWQPSQ_LOCALFENCE_SHIFT)

#define I40IWQPSQ_SIGCOMPL_SHIFT 62
#define I40IWQPSQ_SIGCOMPL_MASK (1ULL << I40IWQPSQ_SIGCOMPL_SHIFT)

#define I40IWQPSQ_VALID_SHIFT 63
#define I40IWQPSQ_VALID_MASK (1ULL << I40IWQPSQ_VALID_SHIFT)

#define I40IWQPSQ_FRAG_TO_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPSQ_FRAG_TO_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IWQPSQ_FRAG_LEN_SHIFT 0
#define I40IWQPSQ_FRAG_LEN_MASK (0xffffffffUL << I40IWQPSQ_FRAG_LEN_SHIFT)

#define I40IWQPSQ_FRAG_STAG_SHIFT 32
#define I40IWQPSQ_FRAG_STAG_MASK (0xffffffffULL << I40IWQPSQ_FRAG_STAG_SHIFT)

#define I40IWQPSQ_REMSTAGINV_SHIFT 0
#define I40IWQPSQ_REMSTAGINV_MASK (0xffffffffUL << I40IWQPSQ_REMSTAGINV_SHIFT)

#define I40IWQPSQ_INLINEDATAFLAG_SHIFT 57
#define I40IWQPSQ_INLINEDATAFLAG_MASK (1ULL << I40IWQPSQ_INLINEDATAFLAG_SHIFT)

#define I40IWQPSQ_INLINEDATALEN_SHIFT 48
#define I40IWQPSQ_INLINEDATALEN_MASK    \
	(0x7fULL << I40IWQPSQ_INLINEDATALEN_SHIFT)

/* iwarp send with push mode */
#define I40IWQPSQ_WQDESCIDX_SHIFT 0
#define I40IWQPSQ_WQDESCIDX_MASK (0x3fffUL << I40IWQPSQ_WQDESCIDX_SHIFT)

/* rdma write */
#define I40IWQPSQ_REMSTAG_SHIFT 0
#define I40IWQPSQ_REMSTAG_MASK (0xffffffffUL << I40IWQPSQ_REMSTAG_SHIFT)

#define I40IWQPSQ_REMTO_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPSQ_REMTO_MASK I40IW_CQPHC_QPCTX_MASK

/* memory window */
#define I40IWQPSQ_STAGRIGHTS_SHIFT 48
#define I40IWQPSQ_STAGRIGHTS_MASK (0x1fULL << I40IWQPSQ_STAGRIGHTS_SHIFT)

#define I40IWQPSQ_VABASEDTO_SHIFT 53
#define I40IWQPSQ_VABASEDTO_MASK (1ULL << I40IWQPSQ_VABASEDTO_SHIFT)

#define I40IWQPSQ_MWLEN_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPSQ_MWLEN_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IWQPSQ_PARENTMRSTAG_SHIFT 0
#define I40IWQPSQ_PARENTMRSTAG_MASK \
	(0xffffffffUL << I40IWQPSQ_PARENTMRSTAG_SHIFT)

#define I40IWQPSQ_MWSTAG_SHIFT 32
#define I40IWQPSQ_MWSTAG_MASK (0xffffffffULL << I40IWQPSQ_MWSTAG_SHIFT)

#define I40IWQPSQ_BASEVA_TO_FBO_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPSQ_BASEVA_TO_FBO_MASK I40IW_CQPHC_QPCTX_MASK

/* Local Invalidate */
#define I40IWQPSQ_LOCSTAG_SHIFT 32
#define I40IWQPSQ_LOCSTAG_MASK (0xffffffffULL << I40IWQPSQ_LOCSTAG_SHIFT)

/* Fast Register */
#define I40IWQPSQ_STAGKEY_SHIFT 0
#define I40IWQPSQ_STAGKEY_MASK (0xffUL << I40IWQPSQ_STAGKEY_SHIFT)

#define I40IWQPSQ_STAGINDEX_SHIFT 8
#define I40IWQPSQ_STAGINDEX_MASK (0xffffffUL << I40IWQPSQ_STAGINDEX_SHIFT)

#define I40IWQPSQ_COPYHOSTPBLS_SHIFT 43
#define I40IWQPSQ_COPYHOSTPBLS_MASK (1ULL << I40IWQPSQ_COPYHOSTPBLS_SHIFT)

#define I40IWQPSQ_LPBLSIZE_SHIFT 44
#define I40IWQPSQ_LPBLSIZE_MASK (3ULL << I40IWQPSQ_LPBLSIZE_SHIFT)

#define I40IWQPSQ_HPAGESIZE_SHIFT 46
#define I40IWQPSQ_HPAGESIZE_MASK (3ULL << I40IWQPSQ_HPAGESIZE_SHIFT)

#define I40IWQPSQ_STAGLEN_SHIFT 0
#define I40IWQPSQ_STAGLEN_MASK (0x1ffffffffffULL << I40IWQPSQ_STAGLEN_SHIFT)

#define I40IWQPSQ_FIRSTPMPBLIDXLO_SHIFT 48
#define I40IWQPSQ_FIRSTPMPBLIDXLO_MASK  \
	(0xffffULL << I40IWQPSQ_FIRSTPMPBLIDXLO_SHIFT)

#define I40IWQPSQ_FIRSTPMPBLIDXHI_SHIFT 0
#define I40IWQPSQ_FIRSTPMPBLIDXHI_MASK  \
	(0xfffUL << I40IWQPSQ_FIRSTPMPBLIDXHI_SHIFT)

#define I40IWQPSQ_PBLADDR_SHIFT 12
#define I40IWQPSQ_PBLADDR_MASK (0xfffffffffffffULL << I40IWQPSQ_PBLADDR_SHIFT)

/*  iwarp QP RQ WQE common fields */
#define I40IWQPRQ_ADDFRAGCNT_SHIFT I40IWQPSQ_ADDFRAGCNT_SHIFT
#define I40IWQPRQ_ADDFRAGCNT_MASK I40IWQPSQ_ADDFRAGCNT_MASK

#define I40IWQPRQ_VALID_SHIFT I40IWQPSQ_VALID_SHIFT
#define I40IWQPRQ_VALID_MASK I40IWQPSQ_VALID_MASK

#define I40IWQPRQ_COMPLCTX_SHIFT I40IW_CQPHC_QPCTX_SHIFT
#define I40IWQPRQ_COMPLCTX_MASK I40IW_CQPHC_QPCTX_MASK

#define I40IWQPRQ_FRAG_LEN_SHIFT I40IWQPSQ_FRAG_LEN_SHIFT
#define I40IWQPRQ_FRAG_LEN_MASK I40IWQPSQ_FRAG_LEN_MASK

#define I40IWQPRQ_STAG_SHIFT I40IWQPSQ_FRAG_STAG_SHIFT
#define I40IWQPRQ_STAG_MASK I40IWQPSQ_FRAG_STAG_MASK

#define I40IWQPRQ_TO_SHIFT I40IWQPSQ_FRAG_TO_SHIFT
#define I40IWQPRQ_TO_MASK I40IWQPSQ_FRAG_TO_MASK

/* Query FPM CQP buf */
#define I40IW_QUERY_FPM_MAX_CQS_SHIFT 0
#define I40IW_QUERY_FPM_MAX_CQS_MASK               \
	(0x3ffffUL << I40IW_QUERY_FPM_MAX_CQS_SHIFT)

#define I40IW_QUERY_FPM_FIRST_PE_SD_INDEX_SHIFT 0
#define I40IW_QUERY_FPM_FIRST_PE_SD_INDEX_MASK  \
	(0x3fffUL << I40IW_QUERY_FPM_FIRST_PE_SD_INDEX_SHIFT)

#define I40IW_QUERY_FPM_MAX_PE_SDS_SHIFT 32
#define I40IW_QUERY_FPM_MAX_PE_SDS_MASK \
	(0x3fffULL << I40IW_QUERY_FPM_MAX_PE_SDS_SHIFT)

#define I40IW_QUERY_FPM_MAX_QPS_SHIFT 0
#define I40IW_QUERY_FPM_MAX_QPS_MASK    \
	(0x7ffffUL << I40IW_QUERY_FPM_MAX_QPS_SHIFT)

#define I40IW_QUERY_FPM_MAX_CQS_SHIFT 0
#define I40IW_QUERY_FPM_MAX_CQS_MASK    \
	(0x3ffffUL << I40IW_QUERY_FPM_MAX_CQS_SHIFT)

#define I40IW_QUERY_FPM_MAX_CEQS_SHIFT 0
#define I40IW_QUERY_FPM_MAX_CEQS_MASK   \
	(0xffUL << I40IW_QUERY_FPM_MAX_CEQS_SHIFT)

#define I40IW_QUERY_FPM_XFBLOCKSIZE_SHIFT 32
#define I40IW_QUERY_FPM_XFBLOCKSIZE_MASK        \
	(0xffffffffULL << I40IW_QUERY_FPM_XFBLOCKSIZE_SHIFT)

#define I40IW_QUERY_FPM_Q1BLOCKSIZE_SHIFT 32
#define I40IW_QUERY_FPM_Q1BLOCKSIZE_MASK        \
	(0xffffffffULL << I40IW_QUERY_FPM_Q1BLOCKSIZE_SHIFT)

#define I40IW_QUERY_FPM_HTMULTIPLIER_SHIFT 16
#define I40IW_QUERY_FPM_HTMULTIPLIER_MASK       \
	(0xfUL << I40IW_QUERY_FPM_HTMULTIPLIER_SHIFT)

#define I40IW_QUERY_FPM_TIMERBUCKET_SHIFT 32
#define I40IW_QUERY_FPM_TIMERBUCKET_MASK        \
	(0xffFFULL << I40IW_QUERY_FPM_TIMERBUCKET_SHIFT)

/* Static HMC pages allocated buf */
#define I40IW_SHMC_PAGE_ALLOCATED_HMC_FN_ID_SHIFT 0
#define I40IW_SHMC_PAGE_ALLOCATED_HMC_FN_ID_MASK        \
	(0x3fUL << I40IW_SHMC_PAGE_ALLOCATED_HMC_FN_ID_SHIFT)

#define I40IW_HW_PAGE_SIZE	4096
#define I40IW_DONE_COUNT	1000
#define I40IW_SLEEP_COUNT	10

enum {
	I40IW_QUEUES_ALIGNMENT_MASK =		(128 - 1),
	I40IW_AEQ_ALIGNMENT_MASK =		(256 - 1),
	I40IW_Q2_ALIGNMENT_MASK =		(256 - 1),
	I40IW_CEQ_ALIGNMENT_MASK =		(256 - 1),
	I40IW_CQ0_ALIGNMENT_MASK =		(256 - 1),
	I40IW_HOST_CTX_ALIGNMENT_MASK =		(4 - 1),
	I40IW_SHADOWAREA_MASK =			(128 - 1),
	I40IW_FPM_QUERY_BUF_ALIGNMENT_MASK =	(4 - 1),
	I40IW_FPM_COMMIT_BUF_ALIGNMENT_MASK =	(4 - 1)
};

enum i40iw_alignment {
	I40IW_CQP_ALIGNMENT =		0x200,
	I40IW_AEQ_ALIGNMENT =		0x100,
	I40IW_CEQ_ALIGNMENT =		0x100,
	I40IW_CQ0_ALIGNMENT =		0x100,
	I40IW_SD_BUF_ALIGNMENT =	0x80
};

#define I40IW_WQE_SIZE_64	64

#define I40IW_QP_WQE_MIN_SIZE	32
#define I40IW_QP_WQE_MAX_SIZE	128

#define I40IW_CQE_QTYPE_RQ 0
#define I40IW_CQE_QTYPE_SQ 1

#define I40IW_RING_INIT(_ring, _size) \
	{ \
		(_ring).head = 0; \
		(_ring).tail = 0; \
		(_ring).size = (_size); \
	}
#define I40IW_RING_GETSIZE(_ring) ((_ring).size)
#define I40IW_RING_GETCURRENT_HEAD(_ring) ((_ring).head)
#define I40IW_RING_GETCURRENT_TAIL(_ring) ((_ring).tail)

#define I40IW_RING_MOVE_HEAD(_ring, _retcode) \
	{ \
		register u32 size; \
		size = (_ring).size;  \
		if (!I40IW_RING_FULL_ERR(_ring)) { \
			(_ring).head = ((_ring).head + 1) % size; \
			(_retcode) = 0; \
		} else { \
			(_retcode) = I40IW_ERR_RING_FULL; \
		} \
	}

#define I40IW_RING_MOVE_HEAD_BY_COUNT(_ring, _count, _retcode) \
	{ \
		register u32 size; \
		size = (_ring).size; \
		if ((I40IW_RING_WORK_AVAILABLE(_ring) + (_count)) < size) { \
			(_ring).head = ((_ring).head + (_count)) % size; \
			(_retcode) = 0; \
		} else { \
			(_retcode) = I40IW_ERR_RING_FULL; \
		} \
	}

#define I40IW_RING_MOVE_TAIL(_ring) \
	(_ring).tail = ((_ring).tail + 1) % (_ring).size

#define I40IW_RING_MOVE_HEAD_NOCHECK(_ring) \
	(_ring).head = ((_ring).head + 1) % (_ring).size

#define I40IW_RING_MOVE_TAIL_BY_COUNT(_ring, _count) \
	(_ring).tail = ((_ring).tail + (_count)) % (_ring).size

#define I40IW_RING_SET_TAIL(_ring, _pos) \
	(_ring).tail = (_pos) % (_ring).size

#define I40IW_RING_FULL_ERR(_ring) \
	( \
		(I40IW_RING_WORK_AVAILABLE(_ring) == ((_ring).size - 1))  \
	)

#define I40IW_ERR_RING_FULL2(_ring) \
	( \
		(I40IW_RING_WORK_AVAILABLE(_ring) == ((_ring).size - 2))  \
	)

#define I40IW_ERR_RING_FULL3(_ring) \
	( \
		(I40IW_RING_WORK_AVAILABLE(_ring) == ((_ring).size - 3))  \
	)

#define I40IW_RING_MORE_WORK(_ring) \
	( \
		(I40IW_RING_WORK_AVAILABLE(_ring) != 0) \
	)

#define I40IW_RING_WORK_AVAILABLE(_ring) \
	( \
		(((_ring).head + (_ring).size - (_ring).tail) % (_ring).size) \
	)

#define I40IW_RING_GET_WQES_AVAILABLE(_ring) \
	( \
		((_ring).size - I40IW_RING_WORK_AVAILABLE(_ring) - 1) \
	)

#define I40IW_ATOMIC_RING_MOVE_HEAD(_ring, index, _retcode) \
	{ \
		index = I40IW_RING_GETCURRENT_HEAD(_ring); \
		I40IW_RING_MOVE_HEAD(_ring, _retcode); \
	}

/* Async Events codes */
#define I40IW_AE_AMP_UNALLOCATED_STAG                                   0x0102
#define I40IW_AE_AMP_INVALID_STAG                                       0x0103
#define I40IW_AE_AMP_BAD_QP                                             0x0104
#define I40IW_AE_AMP_BAD_PD                                             0x0105
#define I40IW_AE_AMP_BAD_STAG_KEY                                       0x0106
#define I40IW_AE_AMP_BAD_STAG_INDEX                                     0x0107
#define I40IW_AE_AMP_BOUNDS_VIOLATION                                   0x0108
#define I40IW_AE_AMP_RIGHTS_VIOLATION                                   0x0109
#define I40IW_AE_AMP_TO_WRAP                                            0x010a
#define I40IW_AE_AMP_FASTREG_SHARED                                     0x010b
#define I40IW_AE_AMP_FASTREG_VALID_STAG                                 0x010c
#define I40IW_AE_AMP_FASTREG_MW_STAG                                    0x010d
#define I40IW_AE_AMP_FASTREG_INVALID_RIGHTS                             0x010e
#define I40IW_AE_AMP_FASTREG_PBL_TABLE_OVERFLOW                         0x010f
#define I40IW_AE_AMP_FASTREG_INVALID_LENGTH                             0x0110
#define I40IW_AE_AMP_INVALIDATE_SHARED                                  0x0111
#define I40IW_AE_AMP_INVALIDATE_NO_REMOTE_ACCESS_RIGHTS                 0x0112
#define I40IW_AE_AMP_INVALIDATE_MR_WITH_BOUND_WINDOWS                   0x0113
#define I40IW_AE_AMP_MWBIND_VALID_STAG                                  0x0114
#define I40IW_AE_AMP_MWBIND_OF_MR_STAG                                  0x0115
#define I40IW_AE_AMP_MWBIND_TO_ZERO_BASED_STAG                          0x0116
#define I40IW_AE_AMP_MWBIND_TO_MW_STAG                                  0x0117
#define I40IW_AE_AMP_MWBIND_INVALID_RIGHTS                              0x0118
#define I40IW_AE_AMP_MWBIND_INVALID_BOUNDS                              0x0119
#define I40IW_AE_AMP_MWBIND_TO_INVALID_PARENT                           0x011a
#define I40IW_AE_AMP_MWBIND_BIND_DISABLED                               0x011b
#define I40IW_AE_UDA_XMIT_DGRAM_TOO_LONG                                0x0132
#define I40IW_AE_UDA_XMIT_DGRAM_TOO_SHORT                               0x0134
#define I40IW_AE_BAD_CLOSE                                              0x0201
#define I40IW_AE_RDMAP_ROE_BAD_LLP_CLOSE                                0x0202
#define I40IW_AE_CQ_OPERATION_ERROR                                     0x0203
#define I40IW_AE_PRIV_OPERATION_DENIED                                  0x011c
#define I40IW_AE_RDMA_READ_WHILE_ORD_ZERO                               0x0205
#define I40IW_AE_STAG_ZERO_INVALID                                      0x0206
#define I40IW_AE_IB_RREQ_AND_Q1_FULL                                    0x0207
#define I40IW_AE_WQE_UNEXPECTED_OPCODE                                  0x020a
#define I40IW_AE_WQE_INVALID_PARAMETER                                  0x020b
#define I40IW_AE_WQE_LSMM_TOO_LONG                                      0x0220
#define I40IW_AE_DDP_INVALID_MSN_GAP_IN_MSN                             0x0301
#define I40IW_AE_DDP_UBE_DDP_MESSAGE_TOO_LONG_FOR_AVAILABLE_BUFFER      0x0303
#define I40IW_AE_DDP_UBE_INVALID_DDP_VERSION                            0x0304
#define I40IW_AE_DDP_UBE_INVALID_MO                                     0x0305
#define I40IW_AE_DDP_UBE_INVALID_MSN_NO_BUFFER_AVAILABLE                0x0306
#define I40IW_AE_DDP_UBE_INVALID_QN                                     0x0307
#define I40IW_AE_DDP_NO_L_BIT                                           0x0308
#define I40IW_AE_RDMAP_ROE_INVALID_RDMAP_VERSION                        0x0311
#define I40IW_AE_RDMAP_ROE_UNEXPECTED_OPCODE                            0x0312
#define I40IW_AE_ROE_INVALID_RDMA_READ_REQUEST                          0x0313
#define I40IW_AE_ROE_INVALID_RDMA_WRITE_OR_READ_RESP                    0x0314
#define I40IW_AE_INVALID_ARP_ENTRY                                      0x0401
#define I40IW_AE_INVALID_TCP_OPTION_RCVD                                0x0402
#define I40IW_AE_STALE_ARP_ENTRY                                        0x0403
#define I40IW_AE_INVALID_MAC_ENTRY                                      0x0405
#define I40IW_AE_LLP_CLOSE_COMPLETE                                     0x0501
#define I40IW_AE_LLP_CONNECTION_RESET                                   0x0502
#define I40IW_AE_LLP_FIN_RECEIVED                                       0x0503
#define I40IW_AE_LLP_RECEIVED_MPA_CRC_ERROR                             0x0505
#define I40IW_AE_LLP_SEGMENT_TOO_LARGE                                  0x0506
#define I40IW_AE_LLP_SEGMENT_TOO_SMALL                                  0x0507
#define I40IW_AE_LLP_SYN_RECEIVED                                       0x0508
#define I40IW_AE_LLP_TERMINATE_RECEIVED                                 0x0509
#define I40IW_AE_LLP_TOO_MANY_RETRIES                                   0x050a
#define I40IW_AE_LLP_TOO_MANY_KEEPALIVE_RETRIES                         0x050b
#define I40IW_AE_LLP_DOUBT_REACHABILITY                                 0x050c
#define I40IW_AE_LLP_RX_VLAN_MISMATCH                                   0x050d
#define I40IW_AE_RESOURCE_EXHAUSTION                                    0x0520
#define I40IW_AE_RESET_SENT                                             0x0601
#define I40IW_AE_TERMINATE_SENT                                         0x0602
#define I40IW_AE_RESET_NOT_SENT                                         0x0603
#define I40IW_AE_LCE_QP_CATASTROPHIC                                    0x0700
#define I40IW_AE_LCE_FUNCTION_CATASTROPHIC                              0x0701
#define I40IW_AE_LCE_CQ_CATASTROPHIC                                    0x0702
#define I40IW_AE_QP_SUSPEND_COMPLETE                                    0x0900

#define OP_DELETE_LOCAL_MAC_IPADDR_ENTRY        1
#define OP_CEQ_DESTROY                          2
#define OP_AEQ_DESTROY                          3
#define OP_DELETE_ARP_CACHE_ENTRY               4
#define OP_MANAGE_APBVT_ENTRY                   5
#define OP_CEQ_CREATE                           6
#define OP_AEQ_CREATE                           7
#define OP_ALLOC_LOCAL_MAC_IPADDR_ENTRY         8
#define OP_ADD_LOCAL_MAC_IPADDR_ENTRY           9
#define OP_MANAGE_QHASH_TABLE_ENTRY             10
#define OP_QP_MODIFY                            11
#define OP_QP_UPLOAD_CONTEXT                    12
#define OP_CQ_CREATE                            13
#define OP_CQ_DESTROY                           14
#define OP_QP_CREATE                            15
#define OP_QP_DESTROY                           16
#define OP_ALLOC_STAG                           17
#define OP_MR_REG_NON_SHARED                    18
#define OP_DEALLOC_STAG                         19
#define OP_MW_ALLOC                             20
#define OP_QP_FLUSH_WQES                        21
#define OP_ADD_ARP_CACHE_ENTRY                  22
#define OP_MANAGE_PUSH_PAGE                     23
#define OP_UPDATE_PE_SDS                        24
#define OP_MANAGE_HMC_PM_FUNC_TABLE             25
#define OP_SUSPEND                              26
#define OP_RESUME                               27
#define OP_MANAGE_VF_PBLE_BP                    28
#define OP_QUERY_FPM_VALUES                     29
#define OP_COMMIT_FPM_VALUES                    30
#define OP_REQUESTED_COMMANDS                   31
#define OP_COMPLETED_COMMANDS                   32
#define OP_GEN_AE                               33
#define OP_SIZE_CQP_STAT_ARRAY                  34

#endif
