/*
*        Copyright (c) 2010-2018, Oracle and/or its affiliates. All rights reserved.
*        DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
*
*        This code is free software; you can redistribute it and/or modify it
*        under the terms of the GNU General Public License version 2 only, as
*        published by the Free Software Foundation.  Oracle designates this
*        particular file as subject to the "Classpath" exception as provided
*        by Oracle in the LICENSE file that accompanied this code.
*
*        This code is distributed in the hope that it will be useful, but WITHOUT
*        ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
*        FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
*        version 2 for more details (a copy is included in the LICENSE file that
*        accompanied this code).
*
*        You should have received a copy of the GNU General Public License version
*        2 along with this work; if not, write to the Free Software Foundation,
*        Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
*
*        Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
*        or visit www.oracle.com if you need additional information or have any
*        questions.
*    
*
*        Copyright (c) 2018 Intel Corporation
*        Copyright (c) 2017 Intel Deutschland GmbH
*        Copyright (c) 2016 MAVinci GmbH | A Part of Intel
*
*        This program is free software: you can redistribute it and/or modify
*        it under the terms of the GNU General Public License as published by
*        the Free Software Foundation, either version 3 of the License, or
*        (at your option) any later version.
*
*        Linking this library statically or dynamically with other modules is
*        making a combined work based on this library. Thus, the terms and conditions
*        of the GNU General Public License cover the whole combination.
*
*        As a special exception, the copyright holders of this library give you
*        permission to link this library with independent modules to produce an
*        executable, regardless of the license terms of these independent modules,
*        and to copy and distribute the resulting executable under terms of your
*        choice, provided that you also meet, for each linked independent module,
*        the terms and conditions of the license of that module. An independent module
*        is a module which is not derived from or based on this library. If you modify
*        this library, you may extend this exception to your version of the library,
*        but you are not obliged to do so. If you do not wish to do so, delete this
*        exception statement from your version.
*
*        This program is distributed in the hope that it will be useful,
*        but WITHOUT ANY WARRANTY; without even the implied warranty of
*        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*        GNU General Public License for more details.
*
*        You should have received a copy of the GNU General Public License
*        along with this program.  If not, see https://www.gnu.org/licenses.
*    */

package com.intel.missioncontrol.collections;

import com.intel.missioncontrol.PublishSource;
import com.intel.missioncontrol.beans.AsyncObservable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Executor;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.util.Callback;
import org.checkerframework.checker.nullness.qual.NonNull;


public final class FXAsyncCollections {

    private FXAsyncCollections() {}

    public static <E> AsyncObservableList<E> emptyObservableList() {
        return new UnmodifiableAsyncObservableListWrapper<>(new ArrayList<>());
    }

    public static <E> AsyncObservableList<E> unmodifiableObservableList(List<E> list) {
        return new UnmodifiableAsyncObservableListWrapper<>(list);
    }

    public static <E> AsyncObservableList<E> unmodifiableObservableList(AsyncObservableList<E> list) {
        return new UnmodifiableAsyncObservableListWrapper<>(list);
    }

    public static <E> AsyncObservableList<E> observableArrayList() {
        return observableList(new ArrayList<>());
    }

    public static <E> AsyncObservableList<E> observableArrayList(Callback<E, AsyncObservable[]> extractor) {
        return observableList(new ArrayList<>(), extractor);
    }

    public static <E> AsyncObservableList<E> observableList(List<E> list) {
        return new AsyncObservableListWrapper<>(list);
    }

    public static <E> AsyncObservableList<E> observableList(List<E> list, Callback<E, AsyncObservable[]> extractor) {
        return new AsyncObservableListWrapper<>(list, extractor);
    }

    public static <E> AsyncObservableSet<E> emptyObservableSet() {
        return new UnmodifiableAsyncObservableSetWrapper<>(new ArraySet<>());
    }

    public static <E> AsyncObservableSet<E> unmodifiableObservableSet(Set<E> set) {
        return new UnmodifiableAsyncObservableSetWrapper<>(set);
    }

    public static <E> AsyncObservableSet<E> observableHashSet() {
        return new AsyncObservableSetWrapper<>(new HashSet<>());
    }

    public static <E> AsyncObservableSet<E> observableArraySet() {
        return new AsyncObservableSetWrapper<>(new ArraySet<>());
    }

    public static <E> AsyncObservableSet<E> observableSet(Set<E> set) {
        return new AsyncObservableSetWrapper<>(set);
    }

    private static class UnmodifiableAsyncObservableListWrapper<E> implements AsyncObservableList<E>, RandomAccess {
        private AsyncObservableListWrapper<E> backingList;

        UnmodifiableAsyncObservableListWrapper(List<E> backingList) {
            this.backingList = new AsyncObservableListWrapper<>(backingList);
        }

        UnmodifiableAsyncObservableListWrapper(AsyncObservableList<E> backingList) {
            this.backingList = new AsyncObservableListWrapper<>(backingList);
        }

        @Override
        public E get(int index) {
            return backingList.get(index);
        }

        @Override
        public boolean isEmpty() {
            return backingList.isEmpty();
        }

        @Override
        public LockedList<E> lock() {
            return backingList.lockUnmodifiable();
        }

        @Override
        public boolean add(E e) {
            throw fail();
        }

        @Override
        public void add(int index, E element) {
            throw fail();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw fail();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw fail();
        }

        @Override
        public boolean addAll(E... elements) {
            throw fail();
        }

        @Override
        public E set(int index, E element) {
            throw fail();
        }

        @Override
        public boolean setAll(Collection<? extends E> col) {
            throw fail();
        }

        @Override
        public boolean setAll(E... elements) {
            throw fail();
        }

        @Override
        public void remove(int from, int to) {
            throw fail();
        }

        @Override
        public boolean remove(Object o) {
            throw fail();
        }

        @Override
        public E remove(int index) {
            throw fail();
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> c) {
            throw fail();
        }

        @Override
        public boolean removeAll(E... elements) {
            throw fail();
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> c) {
            throw fail();
        }

        @Override
        public boolean retainAll(E... elements) {
            throw fail();
        }

        @Override
        public void clear() {
            throw fail();
        }

        @Override
        public int indexOf(Object o) {
            return backingList.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return backingList.lastIndexOf(o);
        }

        @Override
        public Iterator<E> iterator() {
            return backingList.iteratorUnmodifiable();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return backingList.listIteratorUnmodifiable(index);
        }

        @Override
        public ListIterator<E> listIterator() {
            return backingList.listIteratorUnmodifiable();
        }

        @Override
        public void addListener(ListChangeListener<? super E> listener, Executor executor) {
            backingList.addListener(listener, executor);
        }

        @Override
        public void addListener(InvalidationListener listener, Executor executor) {
            backingList.addListener(listener, executor);
        }

        @Override
        public void addListener(ListChangeListener<? super E> listener) {
            backingList.addListener(listener);
        }

        @Override
        public void addListener(InvalidationListener listener) {
            backingList.addListener(listener);
        }

        @Override
        public void removeListener(ListChangeListener<? super E> listener) {
            backingList.removeListener(listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            backingList.removeListener(listener);
        }

        @Override
        public Object[] toArray() {
            return backingList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return backingList.toArray(a);
        }

        @Override
        public int size() {
            return backingList.size();
        }

        @Override
        public boolean contains(Object o) {
            return backingList.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return backingList.containsAll(c);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return backingList.subList(fromIndex, toIndex);
        }

        private IllegalStateException fail() {
            return new IllegalStateException("The list cannot be modified.");
        }
    }

    private static class UnmodifiableAsyncObservableSetWrapper<E> extends AsyncObservableSetWrapper<E>
            implements RandomAccess {
        UnmodifiableAsyncObservableSetWrapper(Set<E> set) {
            super(set);
        }

        @Override
        public boolean add(E e) {
            throw fail();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw fail();
        }

        @Override
        public boolean remove(Object o) {
            throw fail();
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> c) {
            throw fail();
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> c) {
            throw fail();
        }

        private IllegalStateException fail() {
            return new IllegalStateException("The set cannot be modified.");
        }
    }

}
