#!/bin/bash
# sup_dir=$(dirname "${BASH_SOURCE[0]}")
sup_dir=$(pwd)
all_dimm="$*"
echo Enter the number of the update option according to the following followed by Enter:
echo 1. Update BIOS, BMC, ME, FRUSDR, DCPMM DIMMs- DCPMM DIMM ID must be passed as an arguement
echo 2. Update BIOS, BMC, ME, FRUSDR only
echo 3. Update AEP DIMMs only- DCPMM DIMM ID must be passed as an argument
echo "[ENTER 1/2/3]"
read option
if [ "$option" == "1" ]
then
    echo "Starting updates for BIOS, BMC, ME, FRUSDR and DCPMM DIMM firmware."
    ofu_dir="/usr/bin/flashupdt"
    if [ -d "$ofu_dir" ]; then
        echo "Flashupdt found to be installed. Updates will start now..."
        cd $ofu_dir
        ./flashupdt -u $sup_dir/flashupdt.cfg
        echo "Update completed for BIOS, BMC, ME, FRUSDR. Updates for DCPMM DIMM firmware will start now..."
        which ipmctl
        status_aps=$?
        if [ $status_aps -eq 0 ]; then
            echo "DCPMM Driver found to be installed. DCPMM DIMM firmware update will continue."
            SubsystemRevisionID=$(ipmctl show -d SubsystemRevisionID -dimm | grep "SubsystemRevisionID" | head -1)
            echo $SubsystemRevisionID
            if [ $SubsystemRevisionID == "SubsystemRevisionID=0x0000" ]; then
                echo "EKV Controller Rev Code is A0. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0010" ]; then
                echo "EKV Controller Rev Code is S0. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0011" ]; then
                echo "EKV Controller Rev Code is S1. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0012" ]; then
                echo "EKV Controller Rev Code is S1b rev 46. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0013" ]; then
                echo "EKV Controller Rev Code is S1 rev89. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0014" ]; then
                echo "EKV Controller Rev Code is S1b IOPSS Bin2. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0015" ]; then
                echo "EKV Controller Rev Code is S1b IOPSS Bin1. No binary available to update the firmware."
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0016" ]; then
                echo "EKV Controller Rev Code is B0: PO, VIS."
                ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0017" ]; then
                echo "EKV Controller Rev Code is B0:preQS."
                ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0018" ]; then
                echo "EKV Controller Rev Code is B0: QS."
                ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
            elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0019" ]; then
                echo "EKV Controller Rev Code is B0: HVM."
                ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
            else
                echo "EKV Controller Rev Code is unknown or DIMM not installed."
            fi
        else
            echo "DCPMM driver missing. Kindly install the driver to update the DCPMM firmware."
            exit 1
    	fi
    else
        echo "Flashupdt utility is missing. Kindly install it."
        exit 1
    fi

elif [ "$option" == "2" ]
then
    echo "Starting updates for BIOS, BMC, ME and FRUSDR only."
    ofu_dir="/usr/bin/flashupdt"
    if [ -d "$ofu_dir" ]; then
        echo "Flashupdt found to be installed. Updates for BIOS, BMC, ME, FRUSDR will start now..."
        cd $ofu_dir
        ./flashupdt -u $sup_dir/flashupdt.cfg
    else
        echo "Flashupdt utility is missing. Kindly install it to proceed."
        exit 1
    fi

elif [ "$option" == "3" ]
then
    echo "Starting updates for DCPMM firmware only."
    which ipmctl
    status_aps=$?
    if [ $status_aps -eq 0 ]; then
        echo "DCPMM Driver found. Firmware update will continue."
        SubsystemRevisionID=$(ipmctl show -d SubsystemRevisionID -dimm | grep "SubsystemRevisionID" | head -1)
        echo $SubsystemRevisionID
        if [ $SubsystemRevisionID == "SubsystemRevisionID=0x0000" ]; then
            echo "EKV Controller Rev Code is A0. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0010" ]; then
            echo "EKV Controller Rev Code is S0. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0011" ]; then
            echo "EKV Controller Rev Code is S1. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0012" ]; then
            echo "EKV Controller Rev Code is S1b rev 46. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0013" ]; then
            echo "EKV Controller Rev Code is S1 rev89. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0014" ]; then
            echo "EKV Controller Rev Code is S1b IOPSS Bin2. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0015" ]; then
            echo "EKV Controller Rev Code is S1b IOPSS Bin1. No binary available to update the firmware."
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0016" ]; then
            echo "EKV Controller Rev Code is B0: PO, VIS."
            ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0017" ]; then
            echo "EKV Controller Rev Code is B0:preQS."
            ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0018" ]; then
            echo "EKV Controller Rev Code is B0: QS."
            ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
        elif [ $SubsystemRevisionID == "SubsystemRevisionID=0x0019" ]; then
            echo "EKV Controller Rev Code is B0: HVM."
            ipmctl load -f -source $sup_dir/fw_ekvb0_1.2.0.5346_encrypt_signed_strip.bin -dimm $all_dimm
        else
            echo "EKV Controller Rev Code is unknown or DIMM is not installed."
        fi
    else
        echo "DCPMM Driver missing. Kindly install the driver to update the DCPMM firmware."
        exit 1
    fi
else
    echo "Invalid input."
    exit 1
fi
