#!/bin/bash
which ipmctl
status_aps=$?
echo "This helper script will help find the DIMM IDs, which is required as an input arguement for Linux_update.sh"
if [ $status_aps -eq 0 ]; then
    echo "======================================================"
    echo "======================================================"
    dimm_ids=$(ipmctl show -d DIMMID -dimm)
    echo $dimm_ids
    echo "======================================================"
    echo "======================================================"
    echo "Use the DIMM IDs and pass it to the Linux_update.sh as comma-seperated arguments."
    echo "Example- If the output of this script is:"
    echo "---DimmID=0x0020---"
    echo "---DimmID=0x0120---"
    echo "---DimmID=0x1020---"
    echo "---DimmID=0x1120---"
    echo "Then the DIMM IDs of the installed DCPMM DIMMs are: 0x0020,0x0120,0x1020,0x1120"
    echo "Use this to pass as comma-seperated arguements to the script:"
    echo "Linux: Linux_update.sh 0x0020,0x0120,0x1020,0x1120"
fi