/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Range;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.PieDataset3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.PiePlot3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.category.AreaRenderer3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import com.orsoncharts.renderer.category.LineRenderer3D;
import com.orsoncharts.renderer.category.StackedBarRenderer3D;
import com.orsoncharts.renderer.xyz.BarXYZRenderer;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;

public class Chart3DFactory {
    private Chart3DFactory() {
    }

    public static Chart3D createPieChart(String title, String subtitle, PieDataset3D dataset) {
        PiePlot3D plot = new PiePlot3D(dataset);
        return new Chart3D(title, subtitle, plot);
    }

    public static Chart3D createBarChart(String title, String subtitle, CategoryDataset3D dataset, String rowAxisLabel, String columnAxisLabel, String valueAxisLabel) {
        StandardCategoryAxis3D rowAxis = new StandardCategoryAxis3D(rowAxisLabel);
        StandardCategoryAxis3D columnAxis = new StandardCategoryAxis3D(columnAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel, new Range(0.0, 1.0));
        BarRenderer3D renderer = new BarRenderer3D();
        CategoryPlot3D plot = new CategoryPlot3D(dataset, renderer, rowAxis, columnAxis, valueAxis);
        return new Chart3D(title, subtitle, plot);
    }

    public static Chart3D createStackedBarChart(String title, String subtitle, CategoryDataset3D dataset, String rowAxisLabel, String columnAxisLabel, String valueAxisLabel) {
        StandardCategoryAxis3D rowAxis = new StandardCategoryAxis3D(rowAxisLabel);
        StandardCategoryAxis3D columnAxis = new StandardCategoryAxis3D(columnAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel, new Range(0.0, 1.0));
        StackedBarRenderer3D renderer = new StackedBarRenderer3D();
        CategoryPlot3D plot = new CategoryPlot3D(dataset, renderer, rowAxis, columnAxis, valueAxis);
        return new Chart3D(title, subtitle, plot);
    }

    public static Chart3D createAreaChart(String title, String subtitle, CategoryDataset3D dataset, String rowAxisLabel, String columnAxisLabel, String valueAxisLabel) {
        StandardCategoryAxis3D rowAxis = new StandardCategoryAxis3D(rowAxisLabel);
        StandardCategoryAxis3D columnAxis = new StandardCategoryAxis3D(columnAxisLabel);
        columnAxis.setFirstCategoryHalfWidth(true);
        columnAxis.setLastCategoryHalfWidth(true);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel, new Range(0.0, 1.0));
        AreaRenderer3D renderer = new AreaRenderer3D();
        CategoryPlot3D plot = new CategoryPlot3D(dataset, renderer, rowAxis, columnAxis, valueAxis);
        return new Chart3D(title, subtitle, plot);
    }

    public static Chart3D createLineChart(String title, String subtitle, CategoryDataset3D dataset, String rowAxisLabel, String columnAxisLabel, String valueAxisLabel) {
        StandardCategoryAxis3D rowAxis = new StandardCategoryAxis3D(rowAxisLabel);
        StandardCategoryAxis3D columnAxis = new StandardCategoryAxis3D(columnAxisLabel);
        columnAxis.setFirstCategoryHalfWidth(true);
        columnAxis.setLastCategoryHalfWidth(true);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel, new Range(0.0, 1.0));
        LineRenderer3D renderer = new LineRenderer3D();
        CategoryPlot3D plot = new CategoryPlot3D(dataset, renderer, rowAxis, columnAxis, valueAxis);
        return new Chart3D(title, subtitle, plot);
    }

    public static Chart3D createScatterChart(String title, String subtitle, XYZDataset dataset, String xAxisLabel, String yAxisLabel, String zAxisLabel) {
        NumberAxis3D xAxis = new NumberAxis3D(xAxisLabel);
        NumberAxis3D yAxis = new NumberAxis3D(yAxisLabel);
        NumberAxis3D zAxis = new NumberAxis3D(zAxisLabel);
        ScatterXYZRenderer renderer = new ScatterXYZRenderer();
        XYZPlot plot = new XYZPlot(dataset, renderer, xAxis, yAxis, zAxis);
        return new Chart3D(title, subtitle, plot);
    }

    public static Chart3D createXYZBarChart(String title, String subtitle, XYZDataset dataset, String xAxisLabel, String yAxisLabel, String zAxisLabel) {
        NumberAxis3D xAxis = new NumberAxis3D(xAxisLabel);
        NumberAxis3D yAxis = new NumberAxis3D(yAxisLabel);
        NumberAxis3D zAxis = new NumberAxis3D(zAxisLabel);
        BarXYZRenderer renderer = new BarXYZRenderer();
        XYZPlot plot = new XYZPlot(dataset, renderer, xAxis, yAxis, zAxis);
        return new Chart3D(title, subtitle, plot);
    }
}

