/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.axis;

import com.orsoncharts.axis.Axis3D;
import com.orsoncharts.axis.Axis3DChangeEvent;
import com.orsoncharts.axis.Axis3DChangeListener;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.SerialUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.event.EventListenerList;

public abstract class AbstractAxis3D
implements Axis3D,
Serializable {
    private String label;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Stroke lineStroke;
    private Color lineColor;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private transient Paint tickLabelPaint;
    private transient EventListenerList listenerList;

    public AbstractAxis3D(String label) {
        this.label = label;
        this.labelFont = new Font("SansSerif", 1, 12);
        this.labelPaint = Color.BLACK;
        this.lineStroke = new BasicStroke(1.0f);
        this.lineColor = Color.GRAY;
        this.tickLabelsVisible = true;
        this.tickLabelFont = new Font("SansSerif", 0, 12);
        this.tickLabelPaint = Color.BLACK;
        this.listenerList = new EventListenerList();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireChangeEvent();
    }

    @Override
    public Font getLabelFont() {
        return this.labelFont;
    }

    @Override
    public void setLabelFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.labelFont = font;
        this.fireChangeEvent();
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.labelPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.lineStroke = stroke;
        this.fireChangeEvent();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        ArgChecks.nullNotPermitted(color, "color");
        this.lineColor = color;
        this.fireChangeEvent();
    }

    public boolean getTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean visible) {
        this.tickLabelsVisible = visible;
        this.fireChangeEvent();
    }

    @Override
    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    @Override
    public void setTickLabelFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.tickLabelFont = font;
        this.fireChangeEvent();
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.tickLabelPaint = paint;
        this.fireChangeEvent();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractAxis3D)) {
            return false;
        }
        AbstractAxis3D that = (AbstractAxis3D)obj;
        if (!Objects.equals(this.label, that.label)) {
            return false;
        }
        if (!this.labelFont.equals(that.labelFont)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.labelPaint, that.labelPaint)) {
            return false;
        }
        if (!this.lineStroke.equals(that.lineStroke)) {
            return false;
        }
        if (!this.lineColor.equals(that.lineColor)) {
            return false;
        }
        if (this.tickLabelsVisible != that.tickLabelsVisible) {
            return false;
        }
        if (!this.tickLabelFont.equals(that.tickLabelFont)) {
            return false;
        }
        return ObjectUtils.equalsPaint(this.tickLabelPaint, that.tickLabelPaint);
    }

    @Override
    public void addChangeListener(Axis3DChangeListener listener) {
        this.listenerList.add(Axis3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Axis3DChangeListener listener) {
        this.listenerList.remove(Axis3DChangeListener.class, listener);
    }

    public void notifyListeners(Axis3DChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Axis3DChangeListener.class) continue;
            ((Axis3DChangeListener)listeners[i + 1]).axisChanged(event);
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Axis3DChangeEvent(this));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.labelPaint, stream);
        SerialUtils.writePaint(this.tickLabelPaint, stream);
        SerialUtils.writeStroke(this.lineStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.labelPaint = SerialUtils.readPaint(stream);
        this.tickLabelPaint = SerialUtils.readPaint(stream);
        this.lineStroke = SerialUtils.readStroke(stream);
    }
}

