/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.axis;

import com.orsoncharts.Range;
import com.orsoncharts.axis.AbstractAxis3D;
import com.orsoncharts.axis.NumberTickSelector;
import com.orsoncharts.axis.TickData;
import com.orsoncharts.axis.TickSelector;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.SerialUtils;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NumberAxis3D
extends AbstractAxis3D
implements ValueAxis3D,
Serializable {
    private boolean visible = true;
    private Range range;
    private boolean autoAdjustRange;
    private double lowerMargin;
    private double upperMargin;
    private boolean autoRangeIncludesZero;
    private boolean autoRangeStickyZero;
    private Range defaultAutoRange;
    private TickSelector tickSelector;
    private double tickSize;
    private Format tickLabelFormatter;
    private double tickLabelFactor;
    private double tickLabelOffset;
    private double tickMarkLength;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint;

    public NumberAxis3D(String label) {
        this(label, new Range(0.0, 1.0));
    }

    public NumberAxis3D(String label, Range range) {
        super(label);
        this.range = range;
        this.autoAdjustRange = true;
        this.lowerMargin = 0.05;
        this.upperMargin = 0.05;
        this.autoRangeIncludesZero = false;
        this.autoRangeStickyZero = true;
        this.defaultAutoRange = new Range(0.0, 1.0);
        this.tickSelector = new NumberTickSelector();
        this.tickLabelFactor = 1.4;
        this.tickSize = range.getLength() / 10.0;
        this.tickLabelFormatter = new DecimalFormat("0.00");
        this.tickLabelOffset = 5.0;
        this.tickMarkLength = 3.0;
        this.tickMarkStroke = new BasicStroke(0.5f);
        this.tickMarkPaint = Color.GRAY;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireChangeEvent();
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setRange(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        if (range.getLength() <= 0.0) {
            throw new IllegalArgumentException("Requires a range with length > 0");
        }
        this.range = range;
        this.fireChangeEvent();
    }

    @Override
    public void setRange(double min, double max) {
        this.setRange(new Range(min, max));
    }

    public boolean isAutoAdjustRange() {
        return this.autoAdjustRange;
    }

    public void setAutoAdjustRange(boolean autoAdjust) {
        this.autoAdjustRange = autoAdjust;
        this.fireChangeEvent();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.fireChangeEvent();
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.fireChangeEvent();
    }

    public boolean getAutoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludeZero(boolean include) {
        this.autoRangeIncludesZero = include;
        this.fireChangeEvent();
    }

    public boolean getAutoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean sticky) {
        this.autoRangeStickyZero = sticky;
        this.fireChangeEvent();
    }

    public Range getDefaultAutoRange() {
        return this.defaultAutoRange;
    }

    public void setDefaultAutoRange(Range range) {
        this.defaultAutoRange = range;
        this.fireChangeEvent();
    }

    public TickSelector getTickSelector() {
        return this.tickSelector;
    }

    public void setTickSelector(TickSelector selector) {
        this.tickSelector = selector;
        this.fireChangeEvent();
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(double tickSize) {
        this.tickSize = tickSize;
        this.fireChangeEvent();
    }

    public Format getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public void setTickLabelFormatter(Format formatter) {
        ArgChecks.nullNotPermitted(formatter, "formatter");
        this.tickLabelFormatter = formatter;
        this.fireChangeEvent();
    }

    public double getTickLabelFactor() {
        return this.tickLabelFactor;
    }

    public void setTickLabelFactor(double factor) {
        this.tickLabelFactor = factor;
        this.fireChangeEvent();
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double offset) {
        this.tickLabelOffset = offset;
    }

    public double getTickMarkLength() {
        return this.tickMarkLength;
    }

    public void setTickMarkLength(double length) {
        this.tickMarkLength = length;
        this.fireChangeEvent();
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.tickMarkStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.tickMarkPaint = paint;
        this.fireChangeEvent();
    }

    private Range adjustedDataRange(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        double lm = range.getLength() * this.lowerMargin;
        double um = range.getLength() * this.upperMargin;
        double lowerBound = range.getMin() - lm;
        double upperBound = range.getMax() + um;
        if (this.autoRangeStickyZero) {
            if (0.0 <= range.getMin() && 0.0 > lowerBound) {
                lowerBound = 0.0;
            }
            if (0.0 >= range.getMax() && 0.0 < upperBound) {
                upperBound = 0.0;
            }
        }
        return new Range(lowerBound, upperBound);
    }

    @Override
    public void configureAsValueAxis(CategoryPlot3D plot) {
        if (this.autoAdjustRange) {
            Range valueRange = plot.getRenderer().findValueRange(plot.getDataset());
            this.range = valueRange != null ? this.adjustedDataRange(valueRange) : this.defaultAutoRange;
        }
    }

    @Override
    public void configureAsXAxis(XYZPlot plot) {
        if (this.autoAdjustRange) {
            Range xRange = plot.getRenderer().findXRange(plot.getDataset());
            this.range = xRange != null ? this.adjustedDataRange(xRange) : this.defaultAutoRange;
        }
    }

    @Override
    public void configureAsYAxis(XYZPlot plot) {
        if (this.autoAdjustRange) {
            Range yRange = plot.getRenderer().findYRange(plot.getDataset());
            this.range = yRange != null ? this.adjustedDataRange(yRange) : this.defaultAutoRange;
        }
    }

    @Override
    public void configureAsZAxis(XYZPlot plot) {
        if (this.autoAdjustRange) {
            Range zRange = plot.getRenderer().findZRange(plot.getDataset());
            this.range = zRange != null ? this.adjustedDataRange(zRange) : this.defaultAutoRange;
        }
    }

    @Override
    public void draw(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt, boolean labels, List<TickData> tickData) {
        if (!this.isVisible()) {
            return;
        }
        g2.setStroke(this.getLineStroke());
        g2.setPaint(this.getLineColor());
        Line2D.Float axisLine = new Line2D.Float(pt0, pt1);
        g2.draw(axisLine);
        double maxTickLabelWidth = 0.0;
        for (TickData t : tickData) {
            Line2D perpLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), this.tickMarkLength + this.tickLabelOffset, opposingPt);
            if (this.tickMarkLength > 0.0) {
                Line2D tickLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), this.tickMarkLength, opposingPt);
                g2.setPaint(this.tickMarkPaint);
                g2.setStroke(this.tickMarkStroke);
                g2.draw(tickLine);
            }
            if (!this.getTickLabelsVisible()) continue;
            double theta = Utils2D.calculateTheta(axisLine);
            double thetaAdj = theta + 1.5707963267948966;
            if (thetaAdj < -1.5707963267948966) {
                thetaAdj += Math.PI;
            }
            if (thetaAdj > 1.5707963267948966) {
                thetaAdj -= Math.PI;
            }
            double perpTheta = Utils2D.calculateTheta(perpLine);
            TextAnchor textAnchor = TextAnchor.CENTER_LEFT;
            if (Math.abs(perpTheta) > 1.5707963267948966) {
                textAnchor = TextAnchor.CENTER_RIGHT;
            }
            g2.setFont(this.getTickLabelFont());
            g2.setPaint(this.getTickLabelPaint());
            String tickLabel = this.tickLabelFormatter.format(t.getDataValue());
            maxTickLabelWidth = Math.max(maxTickLabelWidth, (double)g2.getFontMetrics().stringWidth(tickLabel));
            TextUtils.drawRotatedString(tickLabel, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, thetaAdj, textAnchor);
        }
        if (this.getLabel() != null) {
            g2.setFont(this.getLabelFont());
            g2.setPaint(this.getLabelPaint());
            Line2D labelPosLine = Utils2D.createPerpendicularLine((Line2D)axisLine, 0.5, this.tickMarkLength + this.tickLabelOffset + maxTickLabelWidth + 10.0, opposingPt);
            double theta = Utils2D.calculateTheta(axisLine);
            if (theta < -1.5707963267948966) {
                theta += Math.PI;
            }
            if (theta > 1.5707963267948966) {
                theta -= Math.PI;
            }
            TextUtils.drawRotatedString(this.getLabel(), g2, (float)labelPosLine.getX2(), (float)labelPosLine.getY2(), TextAnchor.CENTER, theta, TextAnchor.CENTER);
        }
    }

    @Override
    public double translateToWorld(double value, double length) {
        return length * (value - this.range.getMin()) / this.range.getLength();
    }

    @Override
    public double selectTick(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt) {
        if (this.tickSelector == null) {
            return this.tickSize;
        }
        double length = pt0.distance(pt1);
        g2.setFont(this.getTickLabelFont());
        int height = g2.getFontMetrics(this.getTickLabelFont()).getHeight();
        int maxTicks = (int)(length / ((double)height * this.tickLabelFactor));
        if (maxTicks > 2 && this.tickSelector != null) {
            this.tickSelector.select(this.range.getLength() / 2.0);
            int tickCount = (int)(this.range.getLength() / this.tickSelector.getCurrentTickSize());
            while (tickCount < maxTicks) {
                this.tickSelector.previous();
                tickCount = (int)(this.range.getLength() / this.tickSelector.getCurrentTickSize());
            }
            this.tickSelector.next();
            this.tickSize = this.tickSelector.getCurrentTickSize();
            this.tickLabelFormatter = this.tickSelector.getCurrentTickLabelFormat();
        } else {
            this.tickSize = Double.NaN;
        }
        return this.tickSize;
    }

    @Override
    public List<TickData> generateTickData(double tickUnit) {
        ArrayList<TickData> result = new ArrayList<TickData>();
        if (Double.isNaN(tickUnit)) {
            result.add(new TickData(0.0, this.getRange().getMin()));
            result.add(new TickData(1.0, this.getRange().getMax()));
        } else {
            for (double x = tickUnit * Math.ceil(this.range.getMin() / tickUnit); x <= this.range.getMax(); x += tickUnit) {
                result.add(new TickData(this.range.percent(x), x));
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberAxis3D)) {
            return false;
        }
        NumberAxis3D that = (NumberAxis3D)obj;
        if (this.visible != that.visible) {
            return false;
        }
        if (!this.range.equals(that.range)) {
            return false;
        }
        if (this.autoAdjustRange != that.autoAdjustRange) {
            return false;
        }
        if (this.lowerMargin != that.lowerMargin) {
            return false;
        }
        if (this.upperMargin != that.upperMargin) {
            return false;
        }
        if (this.autoRangeIncludesZero != that.autoRangeIncludesZero) {
            return false;
        }
        if (this.autoRangeStickyZero != that.autoRangeStickyZero) {
            return false;
        }
        if (!this.defaultAutoRange.equals(that.defaultAutoRange)) {
            return false;
        }
        if (this.tickSize != that.tickSize) {
            return false;
        }
        if (!ObjectUtils.equals(this.tickSelector, that.tickSelector)) {
            return false;
        }
        if (!this.tickLabelFormatter.equals(that.tickLabelFormatter)) {
            return false;
        }
        if (this.tickLabelFactor != that.tickLabelFactor) {
            return false;
        }
        if (this.tickLabelOffset != that.tickLabelOffset) {
            return false;
        }
        if (this.tickMarkLength != that.tickMarkLength) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.tickMarkPaint, that.tickMarkPaint)) {
            return false;
        }
        if (!this.tickMarkStroke.equals(that.tickMarkStroke)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.range);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.tickSize) ^ Double.doubleToLongBits(this.tickSize) >>> 32);
        hash = 59 * hash + Objects.hashCode(this.tickLabelFormatter);
        return hash;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.tickMarkPaint, stream);
        SerialUtils.writeStroke(this.tickMarkStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.tickMarkPaint = SerialUtils.readPaint(stream);
        this.tickMarkStroke = SerialUtils.readStroke(stream);
    }
}

