/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.DefaultKeyedValues2D;
import com.orsoncharts.data.KeyedValues3D;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class DefaultKeyedValues3D<V>
implements KeyedValues3D,
Serializable {
    private List<Comparable> seriesKeys = new ArrayList<Comparable>();
    private List<Comparable> rowKeys = new ArrayList<Comparable>();
    private List<Comparable> columnKeys = new ArrayList<Comparable>();
    private List<DefaultKeyedValues2D<V>> data = new ArrayList<DefaultKeyedValues2D<V>>();

    @Override
    public Comparable getSeriesKey(int seriesIndex) {
        return this.seriesKeys.get(seriesIndex);
    }

    @Override
    public Comparable getRowKey(int rowIndex) {
        return this.rowKeys.get(rowIndex);
    }

    @Override
    public Comparable getColumnKey(int columnIndex) {
        return this.columnKeys.get(columnIndex);
    }

    @Override
    public int getSeriesIndex(Comparable seriesKey) {
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        return this.seriesKeys.indexOf(seriesKey);
    }

    @Override
    public int getRowIndex(Comparable rowKey) {
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        return this.rowKeys.indexOf(rowKey);
    }

    @Override
    public int getColumnIndex(Comparable columnKey) {
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        return this.columnKeys.indexOf(columnKey);
    }

    @Override
    public List<Comparable> getSeriesKeys() {
        return new ArrayList<Comparable>(this.seriesKeys);
    }

    @Override
    public List<Comparable> getRowKeys() {
        return new ArrayList<Comparable>(this.rowKeys);
    }

    @Override
    public List<Comparable> getColumnKeys() {
        return new ArrayList<Comparable>(this.columnKeys);
    }

    @Override
    public int getSeriesCount() {
        return this.seriesKeys.size();
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public V getValue(int seriesIndex, int rowIndex, int columnIndex) {
        return this.data.get(seriesIndex).getValue(rowIndex, columnIndex);
    }

    public V getValue(Comparable seriesKey, Comparable rowKey, Comparable columnKey) {
        return this.getValue(this.getSeriesIndex(seriesKey), this.getRowIndex(rowKey), this.getColumnIndex(columnKey));
    }

    @Override
    public double getDoubleValue(int seriesIndex, int rowIndex, int columnIndex) {
        V n = this.getValue(seriesIndex, rowIndex, columnIndex);
        if (n != null && n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return Double.NaN;
    }

    public void setValue(V n, Comparable seriesKey, Comparable rowKey, Comparable columnKey) {
        DefaultKeyedValues2D<Object> d;
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        if (this.data.isEmpty()) {
            this.seriesKeys.add(seriesKey);
            this.rowKeys.add(rowKey);
            this.columnKeys.add(columnKey);
            DefaultKeyedValues2D<V> d2 = new DefaultKeyedValues2D<V>();
            d2.setValue(n, rowKey, columnKey);
            this.data.add(d2);
        }
        int seriesIndex = this.getSeriesIndex(seriesKey);
        int rowIndex = this.getRowIndex(rowKey);
        int columnIndex = this.getColumnIndex(columnKey);
        if (rowIndex < 0) {
            this.rowKeys.add(rowKey);
        }
        if (columnIndex < 0) {
            this.columnKeys.add(columnKey);
        }
        if (rowIndex < 0 || columnIndex < 0) {
            for (DefaultKeyedValues2D<V> d3 : this.data) {
                d3.setValue(null, rowKey, columnKey);
            }
        }
        if (seriesIndex >= 0) {
            d = this.data.get(seriesIndex);
            d.setValue(n, rowKey, columnKey);
        } else {
            this.seriesKeys.add(seriesKey);
            d = new DefaultKeyedValues2D(this.rowKeys, this.columnKeys);
            d.setValue(n, rowKey, columnKey);
            this.data.add(d);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValues3D)) {
            return false;
        }
        DefaultKeyedValues3D that = (DefaultKeyedValues3D)obj;
        if (!this.seriesKeys.equals(that.seriesKeys)) {
            return false;
        }
        if (!this.rowKeys.equals(that.rowKeys)) {
            return false;
        }
        if (!this.columnKeys.equals(that.columnKeys)) {
            return false;
        }
        return this.data.equals(that.data);
    }
}

