/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import java.io.Serializable;

public final class Dimension3D
implements Serializable {
    private double width;
    private double height;
    private double depth;

    public Dimension3D(double width, double height, double depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getDiagonalLength() {
        return Math.sqrt(this.depth * this.depth + this.height * this.height + this.width * this.width);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dimension3D other = (Dimension3D)obj;
        if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
            return false;
        }
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        return Double.doubleToLongBits(this.depth) == Double.doubleToLongBits(other.depth);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.width) ^ Double.doubleToLongBits(this.width) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.height) ^ Double.doubleToLongBits(this.height) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.depth) ^ Double.doubleToLongBits(this.depth) >>> 32);
        return hash;
    }

    public String toString() {
        return "[" + this.width + ", " + this.height + ", " + this.depth + "]";
    }
}

