/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.graphics3d.Face;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Object3D {
    private List<Point3D> vertices = new ArrayList<Point3D>();
    private List<Face> faces = new ArrayList<Face>();

    public int getVertexCount() {
        return this.vertices.size();
    }

    public void addVertex(double x, double y, double z) {
        this.addVertex(new Point3D(x, y, z));
    }

    public void addVertex(Point3D vertex) {
        ArgChecks.nullNotPermitted(vertex, "vertex");
        this.vertices.add(vertex);
    }

    public int getFaceCount() {
        return this.faces.size();
    }

    public void addFace(int[] vertices, Color color, boolean outline) {
        this.addFace(new Face(vertices, color, outline));
    }

    public void addFace(Face face) {
        ArgChecks.nullNotPermitted(face, "face");
        this.faces.add(face);
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public Point2D[] calculateProjectedPoints(ViewPoint3D viewPoint, float d) {
        ArgChecks.nullNotPermitted(viewPoint, "viewPoint");
        Point2D[] result = new Point2D[this.vertices.size()];
        int vertexCount = this.vertices.size();
        for (int i = 0; i < vertexCount; ++i) {
            Point3D p = this.vertices.get(i);
            result[i] = viewPoint.worldToScreen(p, d);
        }
        return result;
    }

    public Point3D[] calculateEyeCoordinates(ViewPoint3D viewPoint) {
        ArgChecks.nullNotPermitted(viewPoint, "viewPoint");
        Point3D[] result = new Point3D[this.vertices.size()];
        int i = 0;
        for (Point3D vertex : this.vertices) {
            result[i] = viewPoint.worldToEye(vertex);
            ++i;
        }
        return result;
    }

    public static Object3D createYSheet(double size, double x, double y, double z, Color color, boolean invert) {
        ArgChecks.nullNotPermitted(color, "color");
        Object3D sheet = new Object3D();
        double delta = size / 2.0;
        sheet.addVertex(new Point3D(x + delta, y, z - delta));
        sheet.addVertex(new Point3D(x + delta, y, z + delta));
        sheet.addVertex(new Point3D(x - delta, y, z + delta));
        sheet.addVertex(new Point3D(x - delta, y, z - delta));
        if (invert) {
            sheet.addFace(new Face(new int[]{3, 2, 1, 0}, color, false));
        } else {
            sheet.addFace(new Face(new int[]{0, 1, 2, 3}, color, false));
        }
        return sheet;
    }

    public static Object3D createZSheet(double size, double x, double y, double z, Color color) {
        Object3D sheet = new Object3D();
        double delta = size / 2.0;
        sheet.addVertex(new Point3D(x + delta, y - delta, z));
        sheet.addVertex(new Point3D(x + delta, y + delta, z));
        sheet.addVertex(new Point3D(x - delta, y + delta, z));
        sheet.addVertex(new Point3D(x - delta, y - delta, z));
        sheet.addFace(new Face(new int[]{0, 1, 2, 3}, color, false));
        return sheet;
    }

    public static Object3D createCube(double size, double xOffset, double yOffset, double zOffset, Color color) {
        return Object3D.createBox(xOffset, size, yOffset, size, zOffset, size, color);
    }

    public static Object3D createBox(double x, double xdim, double y, double ydim, double z, double zdim, Color color) {
        Object3D box = new Object3D();
        double xdelta = xdim / 2.0;
        double ydelta = ydim / 2.0;
        double zdelta = zdim / 2.0;
        box.addVertex(new Point3D(x - xdelta, y - ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y - ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y - ydelta, z + zdelta));
        box.addVertex(new Point3D(x - xdelta, y - ydelta, z + zdelta));
        box.addVertex(new Point3D(x - xdelta, y + ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y + ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y + ydelta, z + zdelta));
        box.addVertex(new Point3D(x - xdelta, y + ydelta, z + zdelta));
        box.addFace(new Face(new int[]{4, 5, 1, 0}, color, false));
        box.addFace(new Face(new int[]{5, 6, 2, 1}, color, false));
        box.addFace(new Face(new int[]{6, 7, 3, 2}, color, false));
        box.addFace(new Face(new int[]{3, 7, 4, 0}, color, false));
        box.addFace(new Face(new int[]{7, 6, 5, 4}, color, false));
        box.addFace(new Face(new int[]{0, 1, 2, 3}, color, false));
        return box;
    }

    public static Object3D createTetrahedron(double size, double xOffset, double yOffset, double zOffset, Color color) {
        Object3D tetra = new Object3D();
        tetra.addVertex(new Point3D(size + xOffset, -size + yOffset, -size + zOffset));
        tetra.addVertex(new Point3D(-size + xOffset, size + yOffset, -size + zOffset));
        tetra.addVertex(new Point3D(size + xOffset, size + yOffset, size + zOffset));
        tetra.addVertex(new Point3D(-size + xOffset, -size + yOffset, size + zOffset));
        tetra.addFace(new Face(new int[]{0, 1, 2}, color, false));
        tetra.addFace(new Face(new int[]{1, 3, 2}, color, false));
        tetra.addFace(new Face(new int[]{0, 3, 1}, color, false));
        tetra.addFace(new Face(new int[]{0, 2, 3}, color, false));
        return tetra;
    }

    public static Object3D createOctahedron(double size, double xOffset, double yOffset, double zOffset, Color color) {
        Object3D octa = new Object3D();
        octa.addVertex(new Point3D(size + xOffset, 0.0 + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, size + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(-size + xOffset, 0.0 + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, -size + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, 0.0 + yOffset, -size + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, 0.0 + yOffset, size + zOffset));
        octa.addFace(new Face(new int[]{0, 1, 5}, color, false));
        octa.addFace(new Face(new int[]{1, 2, 5}, color, false));
        octa.addFace(new Face(new int[]{2, 3, 5}, color, false));
        octa.addFace(new Face(new int[]{3, 0, 5}, color, false));
        octa.addFace(new Face(new int[]{1, 0, 4}, color, false));
        octa.addFace(new Face(new int[]{2, 1, 4}, color, false));
        octa.addFace(new Face(new int[]{3, 2, 4}, color, false));
        octa.addFace(new Face(new int[]{0, 3, 4}, color, false));
        return octa;
    }

    public static Object3D createSphere(double radius, int n, double x, double y, double z, Color extColor, Color intColor) {
        Object3D sphere = new Object3D();
        double theta = Math.PI / (double)n;
        Point3D[] prevLayer = new Point3D[n * 2 + 1];
        for (int i = 0; i <= n * 2; ++i) {
            prevLayer[i] = new Point3D(x, y + radius, z);
            if (i == n * 2) continue;
            sphere.addVertex(prevLayer[i]);
        }
        for (int layer = 1; layer < n; ++layer) {
            Point3D[] currLayer = new Point3D[n * 2 + 1];
            for (int i = 0; i <= n * 2; ++i) {
                double xx = radius * Math.cos((double)i * theta) * Math.sin((double)layer * theta);
                double yy = radius * Math.cos((double)layer * theta);
                double zz = radius * Math.sin((double)i * theta) * Math.sin((double)layer * theta);
                currLayer[i] = new Point3D(x + xx, y + yy, z + zz);
                if (i != n * 2) {
                    sphere.addVertex(currLayer[i]);
                }
                if (i <= 0 || layer <= 1) continue;
                if (i != n * 2) {
                    Face f = new Face(new int[]{(layer - 1) * n * 2 + i - 1, (layer - 1) * n * 2 + i, layer * n * 2 + i, layer * n * 2 + i - 1}, extColor, false);
                    sphere.addFace(f);
                    f = new Face(new int[]{layer * n * 2 + i - 1, layer * n * 2 + i, (layer - 1) * n * 2 + i, (layer - 1) * n * 2 + i - 1}, intColor, false);
                    sphere.addFace(f);
                    continue;
                }
                sphere.addFace(new Face(new int[]{(layer - 1) * n * 2 + i - 1, (layer - 1) * n * 2, layer * n * 2, layer * n * 2 + i - 1}, extColor, false));
                sphere.addFace(new Face(new int[]{layer * n * 2 + i - 1, layer * n * 2, (layer - 1) * n * 2, (layer - 1) * n * 2 + i - 1}, intColor, false));
            }
            prevLayer = currLayer;
        }
        return sphere;
    }

    public static Object3D createPieSegment(double radius, double explodeRadius, double base, double height, double angle1, double angle2, double inc, Color color) {
        Object3D segment = new Object3D();
        double angleCentre = (angle1 + angle2) / 2.0;
        Point3D centre = new Point3D(explodeRadius * Math.cos(angleCentre), base, explodeRadius * Math.sin(angleCentre));
        float cx = (float)centre.x;
        float cz = (float)centre.z;
        segment.addVertex(new Point3D((double)cx + 0.0, base, (double)cz + 0.0));
        segment.addVertex(new Point3D((double)cx + 0.0, base + height, (double)cz + 0.0));
        Point3D v0 = new Point3D((double)cx + radius * Math.cos(angle1), base, (double)cz + radius * Math.sin(angle1));
        Point3D v1 = new Point3D((double)cx + radius * Math.cos(angle1), base + height, (double)cz + radius * Math.sin(angle1));
        segment.addVertex(v0);
        segment.addVertex(v1);
        segment.addFace(new Face(new int[]{1, 3, 2, 0}, color, false));
        int vc = 4;
        for (double theta = angle1 + inc; theta < angle2; theta += inc) {
            Point3D v2 = new Point3D((double)cx + radius * Math.cos(theta), base, (double)cz + radius * Math.sin(theta));
            Point3D v3 = new Point3D((double)cx + radius * Math.cos(theta), base + height, (double)cz + radius * Math.sin(theta));
            segment.addVertex(v2);
            segment.addVertex(v3);
            segment.addFace(new Face(new int[]{(vc += 2) - 2, vc - 4, vc - 3, vc - 1}, color, true));
            segment.addFace(new Face(new int[]{0, vc - 4, vc - 2, 0}, color, true));
            segment.addFace(new Face(new int[]{1, vc - 1, vc - 3, 1}, color, true));
        }
        v0 = new Point3D((double)cx + radius * Math.cos(angle2), base, (double)cz + radius * Math.sin(angle2));
        v1 = new Point3D((double)cx + radius * Math.cos(angle2), base + height, (double)cz + radius * Math.sin(angle2));
        segment.addVertex(v0);
        segment.addVertex(v1);
        segment.addFace(new Face(new int[]{(vc += 2) - 2, vc - 4, vc - 3, vc - 1}, color, true));
        segment.addFace(new Face(new int[]{0, vc - 4, vc - 2, 0}, color, true));
        segment.addFace(new Face(new int[]{1, vc - 1, vc - 3, 1}, color, true));
        segment.addFace(new Face(new int[]{1, 0, vc - 2, vc - 1}, color, false));
        double j = angle1;
        return segment;
    }

    public static List<Object3D> createPieLabelMarkers(double radius, double explodeRadius, double base, double height, double angle1, double angle2) {
        ArrayList<Object3D> result = new ArrayList<Object3D>();
        double angle = (angle1 + angle2) / 2.0;
        Point3D centre = new Point3D(explodeRadius * Math.cos(angle), base, explodeRadius * Math.sin(angle));
        float cx = (float)centre.x;
        float cz = (float)centre.z;
        double r = radius * 0.9;
        Point3D v0 = new Point3D((double)cx + r * Math.cos(angle), base, (double)cz + r * Math.sin(angle));
        Point3D v1 = new Point3D((double)cx + r * Math.cos(angle), base + height, (double)cz + r * Math.sin(angle));
        result.add(Object3D.createYSheet(2.0, v0.x, v0.y, v0.z, Color.RED, false));
        result.add(Object3D.createYSheet(2.0, v1.x, v1.y, v1.z, Color.BLUE, true));
        return result;
    }

    public static Object3D createBar(double xWidth, double zWidth, double x, double y, double z, double zero, Color barColor, Color baseColor, Color topColor, boolean inverted) {
        ArgChecks.nullNotPermitted(barColor, "barColor");
        Color c0 = baseColor;
        Color c1 = topColor;
        if (inverted) {
            Color cc = c1;
            c1 = c0;
            c0 = cc;
        }
        if (c0 == null) {
            c0 = barColor;
        }
        if (c1 == null) {
            c1 = barColor;
        }
        Object3D bar = new Object3D();
        double xdelta = xWidth / 2.0;
        double zdelta = zWidth / 2.0;
        bar.addVertex(new Point3D(x - xdelta, zero, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, zero, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, zero, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, zero, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, y, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, y, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, y, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, y, z + zdelta));
        bar.addFace(new Face(new int[]{0, 1, 5, 4}, barColor, false));
        bar.addFace(new Face(new int[]{4, 5, 1, 0}, barColor, false));
        bar.addFace(new Face(new int[]{1, 2, 6, 5}, barColor, false));
        bar.addFace(new Face(new int[]{5, 6, 2, 1}, barColor, false));
        bar.addFace(new Face(new int[]{2, 3, 7, 6}, barColor, false));
        bar.addFace(new Face(new int[]{6, 7, 3, 2}, barColor, false));
        bar.addFace(new Face(new int[]{0, 4, 7, 3}, barColor, false));
        bar.addFace(new Face(new int[]{3, 7, 4, 0}, barColor, false));
        bar.addFace(new Face(new int[]{4, 5, 6, 7}, barColor, false));
        bar.addFace(new Face(new int[]{3, 2, 1, 0}, barColor, false));
        bar.addFace(new Face(new int[]{7, 6, 5, 4}, c1, false));
        bar.addFace(new Face(new int[]{0, 1, 2, 3}, c0, false));
        return bar;
    }
}

