/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import java.io.Serializable;

public final class Point3D
implements Serializable {
    public static final Point3D ORIGIN = new Point3D(0.0, 0.0, 0.0);
    public static final Point3D UNIT_X = new Point3D(1.0, 0.0, 0.0);
    public static final Point3D UNIT_Y = new Point3D(0.0, 1.0, 0.0);
    public static final Point3D UNIT_Z = new Point3D(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public static Point3D createPoint3D(double theta, double phi, double rho) {
        double x = rho * Math.sin(phi) * Math.cos(theta);
        double y = rho * Math.sin(phi) * Math.sin(theta);
        double z = rho * Math.cos(phi);
        return new Point3D(x, y, z);
    }

    public Point3D(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getTheta() {
        return Math.atan2(this.y, this.x);
    }

    public double getPhi() {
        return Math.acos(this.z / this.getRho());
    }

    public double getRho() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Point3D)) {
            return false;
        }
        Point3D that = (Point3D)obj;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        return this.z == that.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

