/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.plot;

import com.orsoncharts.data.Dataset3DChangeEvent;
import com.orsoncharts.data.Dataset3DChangeListener;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.plot.Plot3DChangeEvent;
import com.orsoncharts.plot.Plot3DChangeListener;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public abstract class AbstractPlot3D
implements Plot3D,
Dataset3DChangeListener,
Serializable {
    protected Dimension3D dimensions = new Dimension3D(1.0, 1.0, 1.0);
    protected boolean autoAdjustDimensions = true;
    private transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractPlot3D() {
    }

    @Override
    public Dimension3D getDimensions() {
        return this.dimensions;
    }

    public boolean isAutoAdjustDimensions() {
        return this.autoAdjustDimensions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractPlot3D)) {
            return false;
        }
        AbstractPlot3D that = (AbstractPlot3D)obj;
        return this.dimensions.equals(that.dimensions);
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void addChangeListener(Plot3DChangeListener listener) {
        this.listenerList.add(Plot3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Plot3DChangeListener listener) {
        this.listenerList.remove(Plot3DChangeListener.class, listener);
    }

    public void notifyListeners(Plot3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Plot3DChangeListener.class) continue;
            ((Plot3DChangeListener)listeners[i + 1]).plotChanged(event);
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Plot3DChangeEvent(this, this));
    }

    @Override
    public void datasetChanged(Dataset3DChangeEvent event) {
        this.notifyListeners(new Plot3DChangeEvent(event, this));
    }
}

