/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class Licences {
    public static final String GPL = "GNU GENERAL PUBLIC LICENSE\n";
    public static final String LGPL = "GNU LESSER GENERAL PUBLIC LICENSE\n";
    private static Licences singleton;

    public static Licences getInstance() {
        if (singleton == null) {
            singleton = new Licences();
        }
        return singleton;
    }

    public String getGPL() {
        return this.readStringResource("gpl-2.0.txt");
    }

    public String getLGPL() {
        return this.readStringResource("lgpl-2.1.txt");
    }

    private String readStringResource(String name) {
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = this.getClass().getResourceAsStream(name);
             InputStreamReader streamReader = new InputStreamReader(inputStream, "UTF-8");){
            String line;
            BufferedReader in = new BufferedReader(streamReader);
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }
}

