/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class PIFData
extends HashMap<String, String> {
    static final long serialVersionUID = 3086795680582315773L;
    private static Pattern pifRecordPattern = Pattern.compile("\\d+ +([^=]+)=(.*)");
    private Long sizeObject = null;

    public Long getSize() {
        return this.sizeObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PIFData(InputStream inputStream) throws TarMalformatException, IOException {
        Object object;
        try {
            object = new InputStreamReader(inputStream, "UTF-8");
            Throwable throwable = null;
            try (BufferedReader bufferedReader = new BufferedReader((Reader)object);){
                String string;
                int n = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    ++n;
                    Matcher matcher = pifRecordPattern.matcher(string);
                    if (!matcher.matches()) {
                        throw new TarMalformatException(RB.pif_malformat.getString(n, string));
                    }
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    if (string3 == null || string3.length() < 1) {
                        this.remove(string2);
                        continue;
                    }
                    this.put(string2, string3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStreamReader)object).close();
                    }
                }
            }
        }
        finally {
            inputStream.close();
        }
        object = (String)this.get("size");
        if (object != null) {
            try {
                this.sizeObject = Long.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TarMalformatException(RB.pif_malformat_size.getString(new String[]{object}));
            }
        }
    }
}

