/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.graphics2d.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.jfree.graphics2d.GradientPaintKey;
import org.jfree.graphics2d.GraphicsUtils;
import org.jfree.graphics2d.RadialGradientPaintKey;
import org.jfree.graphics2d.svg.ImageElement;
import org.jfree.graphics2d.svg.SVGGraphicsConfiguration;
import org.jfree.graphics2d.svg.SVGHints;

public final class SVGGraphics2D
extends Graphics2D {
    private RenderingHints hints;
    private int width;
    private int height;
    private int transformDP;
    private DecimalFormat transformFormat = new DecimalFormat("0.######");
    private int geometryDP;
    private DecimalFormat geometryFormat = new DecimalFormat("0.##");
    private StringBuilder sb;
    private Map<GradientPaintKey, String> gradientPaints = new HashMap<GradientPaintKey, String>();
    private Map<RadialGradientPaintKey, String> radialGradientPaints = new HashMap<RadialGradientPaintKey, String>();
    private List<String> clipPaths = new ArrayList<String>();
    private List<ImageElement> imageElements;
    private Shape clip;
    private String clipRef;
    private AffineTransform transform = new AffineTransform();
    private Paint paint = Color.BLACK;
    private Color color = Color.BLACK;
    private Composite composite = AlphaComposite.getInstance(3, 1.0f);
    private Stroke stroke = new BasicStroke(1.0f);
    private Font font = new Font("SansSerif", 0, 12);
    private Color background = Color.BLACK;
    private BufferedImage fmImage = new BufferedImage(10, 10, 1);
    private Line2D line;
    Rectangle2D rect;
    private RoundRectangle2D roundRect;
    private Ellipse2D oval;
    private Arc2D arc;
    private String gradientPaintRef = null;
    private GraphicsConfiguration deviceConfiguration;
    private static final double EPSILON = 1.0E-8;

    public SVGGraphics2D(int width, int height) {
        this.width = width;
        this.height = height;
        this.clip = null;
        this.imageElements = new ArrayList<ImageElement>();
        this.sb = new StringBuilder();
        this.hints = new RenderingHints(SVGHints.KEY_IMAGE_HANDLING, SVGHints.VALUE_IMAGE_HANDLING_EMBED);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTransformDP() {
        return this.transformDP;
    }

    public void setTransformDP(int dp) {
        this.transformDP = dp;
        if (dp < 1 || dp > 10) {
            this.transformFormat = null;
            return;
        }
        this.transformFormat = new DecimalFormat("0." + "##########".substring(0, dp));
    }

    public int getGeometryDP() {
        return this.geometryDP;
    }

    public void setGeometryDP(int dp) {
        this.geometryDP = dp;
        if (dp < 1 || dp > 10) {
            this.geometryFormat = null;
            return;
        }
        this.geometryFormat = new DecimalFormat("0." + "##########".substring(0, dp));
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        if (this.deviceConfiguration == null) {
            this.deviceConfiguration = new SVGGraphicsConfiguration(this.width, this.height);
        }
        return this.deviceConfiguration;
    }

    @Override
    public Graphics create() {
        SVGGraphics2D copy = new SVGGraphics2D(this.width, this.height);
        copy.setRenderingHints(this.getRenderingHints());
        copy.setClip(this.getClip());
        copy.setPaint(this.getPaint());
        copy.setColor(this.getColor());
        copy.setComposite(this.getComposite());
        copy.setStroke(this.getStroke());
        copy.setFont(this.getFont());
        copy.setTransform(this.getTransform());
        copy.setBackground(this.getBackground());
        return copy;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        RadialGradientPaint rgp;
        RadialGradientPaintKey key;
        String ref;
        if (paint == null) {
            return;
        }
        this.paint = paint;
        this.gradientPaintRef = null;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            GradientPaintKey key2 = new GradientPaintKey(gp);
            String ref2 = this.gradientPaints.get(key2);
            if (ref2 == null) {
                int count = this.gradientPaints.keySet().size();
                this.gradientPaints.put(key2, "gp" + count);
                this.gradientPaintRef = "gp" + count;
            } else {
                this.gradientPaintRef = ref2;
            }
        } else if (paint instanceof RadialGradientPaint && (ref = this.radialGradientPaints.get(key = new RadialGradientPaintKey(rgp = (RadialGradientPaint)paint))) == null) {
            int count = this.radialGradientPaints.keySet().size();
            this.radialGradientPaints.put(key, "rgp" + count);
            this.gradientPaintRef = "rgp" + count;
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        if (c == null) {
            return;
        }
        this.color = c;
        this.paint = c;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setComposite(Composite comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Null 'comp' argument.");
        }
        this.composite = comp;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke s) {
        if (s == null) {
            throw new IllegalArgumentException("Null 's' argument.");
        }
        this.stroke = s;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.clear();
        this.addRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    @Override
    public void draw(Shape s) {
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            this.sb.append("<line x1=\"").append(this.geomDP(l.getX1())).append("\" y1=\"").append(this.geomDP(l.getY1())).append("\" x2=\"").append(this.geomDP(l.getX2())).append("\" y2=\"").append(this.geomDP(l.getY2())).append("\" ");
            this.sb.append("style=\"").append(this.strokeStyle()).append("\" ");
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            this.sb.append(this.getClipPathRef());
            this.sb.append("/>");
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.sb.append("<rect x=\"").append(this.geomDP(r.getX())).append("\" y=\"").append(this.geomDP(r.getY())).append("\" width=\"").append(this.geomDP(r.getWidth())).append("\" height=\"").append(this.geomDP(r.getHeight())).append("\" ");
            this.sb.append("style=\"").append(this.strokeStyle()).append("; fill: none").append("\" ");
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            this.sb.append(this.getClipPathRef());
            this.sb.append("/>");
        } else if (s instanceof Path2D) {
            Path2D path = (Path2D)s;
            this.sb.append("<g style=\"").append(this.strokeStyle()).append("; fill: none").append("\" ");
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            this.sb.append(this.getClipPathRef());
            this.sb.append(">");
            this.sb.append("<path ").append(this.getSVGPathData(path)).append("/>");
            this.sb.append("</g>");
        } else {
            this.draw(new GeneralPath(s));
        }
    }

    @Override
    public void fill(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (r.isEmpty()) {
                return;
            }
            this.sb.append("<rect x=\"").append(this.geomDP(r.getX())).append("\" y=\"").append(this.geomDP(r.getY())).append("\" width=\"").append(this.geomDP(r.getWidth())).append("\" height=\"").append(this.geomDP(r.getHeight())).append("\" ");
            this.sb.append("style=\"").append(this.getSVGFillStyle()).append("\" ");
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            this.sb.append(this.getClipPathRef());
            this.sb.append("/>");
        } else if (s instanceof Path2D) {
            Path2D path = (Path2D)s;
            this.sb.append("<g style=\"").append(this.getSVGFillStyle());
            this.sb.append("; stroke: none").append("\" ");
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            this.sb.append(this.getClipPathRef());
            this.sb.append(">");
            this.sb.append("<path ").append(this.getSVGPathData(path)).append("/>");
            this.sb.append("</g>");
        } else {
            this.fill(new GeneralPath(s));
        }
    }

    private String getSVGPathData(Path2D path) {
        StringBuilder b = new StringBuilder("d=\"");
        float[] coords = new float[6];
        double[] closePt = null;
        boolean first = true;
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            if (!first) {
                b.append(" ");
            }
            first = false;
            switch (type) {
                case 0: {
                    closePt = new double[]{coords[0], coords[1]};
                    b.append("M ").append(this.geomDP(coords[0])).append(" ").append(this.geomDP(coords[1]));
                    break;
                }
                case 1: {
                    b.append("L ").append(this.geomDP(coords[0])).append(" ").append(this.geomDP(coords[1]));
                    break;
                }
                case 2: {
                    b.append("Q ").append(this.geomDP(coords[0])).append(" ").append(this.geomDP(coords[1])).append(" ").append(this.geomDP(coords[2])).append(" ").append(this.geomDP(coords[3]));
                    break;
                }
                case 3: {
                    b.append("C ").append(this.geomDP(coords[0])).append(" ").append(this.geomDP(coords[1])).append(" ").append(this.geomDP(coords[2])).append(" ").append(this.geomDP(coords[3])).append(" ").append(this.geomDP(coords[4])).append(" ").append(this.geomDP(coords[5]));
                    break;
                }
                case 4: {
                    if (closePt == null) break;
                    b.append("M ").append(this.geomDP(closePt[0])).append(" ").append(this.geomDP(closePt[1]));
                    break;
                }
            }
            iterator.next();
        }
        return b.append("\"").toString();
    }

    private float getAlpha() {
        float alpha = 1.0f;
        if (this.composite instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)this.composite;
            alpha = ac.getAlpha();
        }
        return alpha;
    }

    private String getSVGColor() {
        String result = "black;";
        if (this.paint instanceof Color) {
            return this.getSVGColor((Color)this.paint);
        }
        if (this.paint instanceof GradientPaint || this.paint instanceof RadialGradientPaint) {
            return "url(#" + this.gradientPaintRef + ")";
        }
        return result;
    }

    private String getSVGColor(Color c) {
        StringBuilder b = new StringBuilder("rgb(");
        b.append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue()).append(")");
        return b.toString();
    }

    private String strokeStyle() {
        float strokeWidth = 1.0f;
        float[] dashArray = new float[]{};
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            strokeWidth = bs.getLineWidth();
            dashArray = bs.getDashArray();
        }
        StringBuilder b = new StringBuilder();
        b.append("stroke-width: ").append(strokeWidth).append(";");
        b.append("stroke: ").append(this.getSVGColor()).append(";");
        b.append("stroke-opacity: ").append(this.getAlpha()).append(";");
        if (dashArray != null && dashArray.length != 0) {
            b.append("stroke-dasharray: ");
            for (int i = 0; i < dashArray.length; ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(dashArray[i]);
            }
            b.append(";");
        }
        return b.toString();
    }

    private String getSVGFillStyle() {
        StringBuilder b = new StringBuilder();
        b.append("fill: ").append(this.getSVGColor()).append(";");
        b.append("fill-opacity: ").append(this.getAlpha());
        return b.toString();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
    }

    private String getSVGFontStyle() {
        StringBuilder b = new StringBuilder();
        b.append("fill: ").append(this.getSVGColor()).append("; ");
        b.append("font-family: ").append(this.font.getFamily()).append("; ");
        b.append("font-size: ").append(this.font.getSize()).append("px; ");
        if (this.font.isBold()) {
            b.append("font-weight: bold; ");
        }
        if (this.font.isItalic()) {
            b.append("font-style: italic; ");
        }
        return b.toString();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.fmImage.createGraphics().getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fmImage.createGraphics().getFontRenderContext();
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        this.sb.append("<g ");
        this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\">");
        this.sb.append("<text x=\"").append(this.geomDP(x)).append("\" y=\"").append(this.geomDP(y)).append("\"");
        this.sb.append(" style=\"").append(this.getSVGFontStyle()).append("\"");
        String textRenderValue = "auto";
        Object hintValue = this.getRenderingHint(SVGHints.KEY_TEXT_RENDERING);
        if (hintValue != null) {
            textRenderValue = hintValue.toString();
        }
        this.sb.append(" text-rendering=\"").append(textRenderValue).append("\" ");
        this.sb.append(this.getClipPathRef());
        this.sb.append(">");
        this.sb.append(str).append("</text>");
        this.sb.append("</g>");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        Set<AttributedCharacterIterator.Attribute> s = iterator.getAllAttributeKeys();
        if (!s.isEmpty()) {
            TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
            layout.draw(this, x, y);
        } else {
            StringBuilder strb = new StringBuilder();
            iterator.first();
            for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
                strb.append(iterator.current());
                iterator.next();
            }
            this.drawString(strb.toString(), x, y);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    @Override
    public void translate(int tx, int ty) {
        this.translate((double)tx, (double)ty);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform t = this.getTransform();
        t.translate(tx, ty);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform t = this.getTransform();
        t.rotate(theta);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform t = this.getTransform();
        t.scale(sx, sy);
        this.setTransform(t);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    @Override
    public void transform(AffineTransform t) {
        AffineTransform tx = this.getTransform();
        tx.concatenate(t);
        this.setTransform(tx);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.transform = t == null ? new AffineTransform() : new AffineTransform(t);
        this.clipRef = null;
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape ts = onStroke ? this.transform.createTransformedShape(this.stroke.createStrokedShape(s)) : this.transform.createTransformedShape(s);
        if (!rect.getBounds2D().intersects(ts.getBounds2D())) {
            return false;
        }
        Area a1 = new Area(rect);
        Area a2 = new Area(ts);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c) {
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        try {
            AffineTransform inv = this.transform.createInverse();
            return inv.createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = this.transform.createTransformedShape(shape);
        this.clipRef = null;
    }

    private String registerClip(Shape clip) {
        if (clip == null) {
            this.clipRef = null;
            return null;
        }
        String pathStr = this.getSVGPathData(new Path2D.Double(clip));
        int index = this.clipPaths.indexOf(pathStr);
        if (index < 0) {
            this.clipPaths.add(pathStr);
            index = this.clipPaths.size() - 1;
        }
        return "clip-" + index;
    }

    private String transformDP(double d) {
        if (this.transformFormat != null) {
            return this.transformFormat.format(d);
        }
        return String.valueOf(d);
    }

    private String geomDP(double d) {
        if (this.geometryFormat != null) {
            return this.geometryFormat.format(d);
        }
        return String.valueOf(d);
    }

    private String getSVGTransform(AffineTransform t) {
        StringBuilder b = new StringBuilder("matrix(");
        b.append(this.transformDP(t.getScaleX())).append(",");
        b.append(this.transformDP(t.getShearY())).append(",");
        b.append(this.transformDP(t.getShearX())).append(",");
        b.append(this.transformDP(t.getScaleY())).append(",");
        b.append(this.transformDP(t.getTranslateX())).append(",");
        b.append(this.transformDP(t.getTranslateY())).append(")");
        return b.toString();
    }

    @Override
    public void clip(Shape s) {
        if (this.clip == null) {
            this.setClip(s);
            return;
        }
        Shape ts = this.transform.createTransformedShape(s);
        if (!ts.intersects(this.clip.getBounds2D())) {
            this.setClip(new Rectangle2D.Double());
        } else {
            Area a1 = new Area(ts);
            Area a2 = new Area(this.clip);
            a1.intersect(a2);
            this.clip = new Path2D.Double(a1);
        }
        this.clipRef = null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.clip(this.rect);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.setClip(this.rect);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.line == null) {
            this.line = new Line2D.Double(x1, y1, x2, y2);
        } else {
            this.line.setLine(x1, y1, x2, y2);
        }
        this.draw(this.line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.fill(this.rect);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() == null) {
            return;
        }
        Paint saved = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.draw(this.roundRect);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.fill(this.roundRect);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.draw(this.oval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.fill(this.oval);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.draw(this.arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.fill(this.arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, false);
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill(p);
    }

    private byte[] getPNGBytes(Image img) {
        RenderedImage ri;
        if (img instanceof RenderedImage) {
            ri = (RenderedImage)((Object)img);
        } else {
            BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D g2 = bi.createGraphics();
            g2.drawImage(img, 0, 0, null);
            ri = bi;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write(ri, "png", baos);
        }
        catch (IOException ex) {
            Logger.getLogger(SVGGraphics2D.class.getName()).log(Level.SEVERE, "IOException while writing PNG data.", ex);
        }
        return baos.toByteArray();
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        int w = img.getWidth(observer);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(observer);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        Object hint = this.getRenderingHint(SVGHints.KEY_IMAGE_HANDLING);
        if (SVGHints.VALUE_IMAGE_HANDLING_EMBED.equals(hint)) {
            this.sb.append("<image preserveAspectRatio=\"none\" ");
            this.sb.append("xlink:href=\"data:image/png;base64,");
            this.sb.append(DatatypeConverter.printBase64Binary((byte[])this.getPNGBytes(img)));
            this.sb.append("\" ");
            this.sb.append(this.getClipPathRef()).append(" ");
            this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
            this.sb.append("x=\"").append(this.geomDP(x)).append("\" y=\"").append(this.geomDP(y)).append("\" ");
            this.sb.append("width=\"").append(this.geomDP(w)).append("\" height=\"").append(this.geomDP(h)).append("\"/>\n");
            return true;
        }
        int count = this.imageElements.size();
        String fileName = "image-" + count + ".png";
        ImageElement imageElement = new ImageElement(fileName, img);
        this.imageElements.add(imageElement);
        this.sb.append("<image xlink:href=\"");
        this.sb.append(fileName).append("\" ");
        this.sb.append(this.getClipPathRef()).append(" ");
        this.sb.append("transform=\"").append(this.getSVGTransform(this.transform)).append("\" ");
        this.sb.append("x=\"").append(this.geomDP(x)).append("\" y=\"").append(this.geomDP(y)).append("\" ");
        this.sb.append("width=\"").append(this.geomDP(w)).append("\" height=\"").append(this.geomDP(h)).append("\"/>\n");
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(x, y, w, h);
        this.setPaint(saved);
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int w = dx2 - dx1;
        int h = dy2 - dy1;
        BufferedImage img2 = new BufferedImage(2, w, h);
        Graphics2D g2 = img2.createGraphics();
        g2.drawImage(img, 0, 0, w, h, sx1, sy1, sx2, sy2, null);
        return this.drawImage((Image)img2, dx1, dx2, null);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.setPaint(saved);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage bi = GraphicsUtils.convertRenderedImage(img);
        this.drawImage(bi, xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        RenderedImage ri = img.createDefaultRendering();
        this.drawRenderedImage(ri, xform);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform savedTransform = this.getTransform();
        this.transform(xform);
        boolean result = this.drawImage(img, 0, 0, obs);
        this.setTransform(savedTransform);
        return result;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage imageToDraw = op.filter(img, null);
        this.drawImage(imageToDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void dispose() {
    }

    public String getSVGElement() {
        StringBuilder svg = new StringBuilder("<svg ").append("xmlns=\"http://www.w3.org/2000/svg\" ").append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" ").append("width=\"").append(this.width).append("\" height=\"").append(this.height).append("\">\n");
        StringBuilder defs = new StringBuilder("<defs>");
        for (GradientPaintKey gradientPaintKey : this.gradientPaints.keySet()) {
            defs.append(this.getLinearGradientElement(this.gradientPaints.get(gradientPaintKey), gradientPaintKey.getPaint()));
            defs.append("\n");
        }
        for (RadialGradientPaintKey radialGradientPaintKey : this.radialGradientPaints.keySet()) {
            defs.append(this.getRadialGradientElement(this.radialGradientPaints.get(radialGradientPaintKey), radialGradientPaintKey.getPaint()));
            defs.append("\n");
        }
        for (int i = 0; i < this.clipPaths.size(); ++i) {
            StringBuilder stringBuilder = new StringBuilder("<clipPath id=\"clip-").append(i).append("\">");
            stringBuilder.append("<path ").append(this.clipPaths.get(i)).append("/>");
            stringBuilder.append("</clipPath>").append("\n");
            defs.append(stringBuilder.toString());
        }
        defs.append("</defs>\n");
        svg.append((CharSequence)defs);
        svg.append((CharSequence)this.sb);
        svg.append("</svg>");
        return svg.toString();
    }

    public String getSVGDocument() {
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\"?>\n");
        b.append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.0//EN\" ");
        b.append("\"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">\n");
        b.append(this.getSVGElement());
        return b.append("\n").toString();
    }

    public List<ImageElement> getSVGImages() {
        return this.imageElements;
    }

    private String getLinearGradientElement(String id, GradientPaint paint) {
        StringBuilder b = new StringBuilder("<linearGradient id=\"").append(id).append("\" ");
        Point2D p1 = paint.getPoint1();
        Point2D p2 = paint.getPoint2();
        boolean h = Math.abs(p1.getX() - p2.getX()) > 1.0E-8;
        boolean v = Math.abs(p1.getY() - p2.getY()) > 1.0E-8;
        b.append("x1=\"").append(h ? "0%" : "50%").append("\" ");
        b.append("y1=\"").append(v ? "0%" : "50%").append("\" ");
        b.append("x2=\"").append(h ? "100%" : "50%").append("\" ");
        b.append("y2=\"").append(v ? "100%" : "50%").append("\">");
        b.append("<stop offset=\"0%\" style=\"stop-color: ").append(this.getSVGColor(paint.getColor1())).append(";\"/>");
        b.append("<stop offset=\"100%\" style=\"stop-color: ").append(this.getSVGColor(paint.getColor2())).append(";\"/>");
        return b.append("</linearGradient>").toString();
    }

    private String getRadialGradientElement(String id, RadialGradientPaint rgp) {
        StringBuilder b = new StringBuilder("<radialGradient id=\"").append(id).append("\" gradientUnits=\"userSpaceOnUse\" ");
        Point2D center = rgp.getCenterPoint();
        Point2D focus = rgp.getFocusPoint();
        float radius = rgp.getRadius();
        b.append("cx=\"").append(this.geomDP(center.getX())).append("\" ");
        b.append("cy=\"").append(this.geomDP(center.getY())).append("\" ");
        b.append("r=\"").append(this.geomDP(radius)).append("\" ");
        b.append("fx=\"").append(this.geomDP(focus.getX())).append("\" ");
        b.append("fy=\"").append(this.geomDP(focus.getY())).append("\">");
        Color[] colors = rgp.getColors();
        float[] fractions = rgp.getFractions();
        for (int i = 0; i < colors.length; ++i) {
            Color c = colors[i];
            float f = fractions[i];
            b.append("<stop offset=\"").append(this.geomDP(f * 100.0f)).append("%\" ");
            b.append("stop-color=\"").append(this.getSVGColor(c)).append("\"/>");
        }
        return b.append("</radialGradient>").toString();
    }

    private String getClipPathElement(String refID, Shape s) {
        StringBuilder b = new StringBuilder("<clipPath id=\"").append(refID).append("\">");
        b.append("<path ").append(this.getSVGPathData(new Path2D.Double(s))).append("/>");
        return b.append("</clipPath>").toString();
    }

    private String getClipPathRef() {
        if (this.clip == null) {
            return "";
        }
        if (this.clipRef == null) {
            this.clipRef = this.registerClip(this.getClip());
        }
        StringBuilder b = new StringBuilder();
        b.append("clip-path=\"url(#").append(this.clipRef).append(")\"");
        return b.toString();
    }

    private void setRect(int x, int y, int width, int height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double(x, y, width, height);
        } else {
            this.rect.setRect(x, y, width, height);
        }
    }

    private void setRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        } else {
            this.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    private void setArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.arc == null) {
            this.arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        } else {
            this.arc.setArc(x, y, width, height, startAngle, arcAngle, 0);
        }
    }

    private void setOval(int x, int y, int width, int height) {
        if (this.oval == null) {
            this.oval = new Ellipse2D.Double(x, y, width, height);
        } else {
            this.oval.setFrame(x, y, width, height);
        }
    }
}

