/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxBase64;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxSvgCanvas
extends mxBasicCanvas {
    protected Document document;
    private Map<String, Element> gradients = new Hashtable<String, Element>();
    private Map<String, Element> images = new Hashtable<String, Element>();
    protected Element defs = null;
    protected boolean embedded = false;

    public mxSvgCanvas() {
        this(null);
    }

    public mxSvgCanvas(Document document) {
        this.setDocument(document);
    }

    public void appendSvgElement(Element element) {
        if (this.document != null) {
            this.document.getDocumentElement().appendChild(element);
        }
    }

    protected Element getDefsElement() {
        if (this.defs == null) {
            this.defs = this.document.createElement("defs");
            Element element = this.document.getDocumentElement();
            if (element.hasChildNodes()) {
                element.insertBefore(this.defs, element.getFirstChild());
            } else {
                element.appendChild(this.defs);
            }
        }
        return this.defs;
    }

    public Element getGradientElement(String string, String string2, String string3) {
        String string4 = this.getGradientId(string, string2, string3);
        Element element = this.gradients.get(string4);
        if (element == null) {
            element = this.createGradientElement(string, string2, string3);
            element.setAttribute("id", "g" + (this.gradients.size() + 1));
            this.getDefsElement().appendChild(element);
            this.gradients.put(string4, element);
        }
        return element;
    }

    public Element getGlassGradientElement() {
        String string = "mx-glass-gradient";
        Element element = this.gradients.get(string);
        if (element == null) {
            element = this.document.createElement("linearGradient");
            element.setAttribute("x1", "0%");
            element.setAttribute("y1", "0%");
            element.setAttribute("x2", "0%");
            element.setAttribute("y2", "100%");
            Element element2 = this.document.createElement("stop");
            element2.setAttribute("offset", "0%");
            element2.setAttribute("style", "stop-color:#ffffff;stop-opacity:0.9");
            element.appendChild(element2);
            Element element3 = this.document.createElement("stop");
            element3.setAttribute("offset", "100%");
            element3.setAttribute("style", "stop-color:#ffffff;stop-opacity:0.1");
            element.appendChild(element3);
            element.setAttribute("id", "g" + (this.gradients.size() + 1));
            this.getDefsElement().appendChild(element);
            this.gradients.put(string, element);
        }
        return element;
    }

    protected Element createGradientElement(String string, String string2, String string3) {
        Element element = this.document.createElement("linearGradient");
        element.setAttribute("x1", "0%");
        element.setAttribute("y1", "0%");
        element.setAttribute("x2", "0%");
        element.setAttribute("y2", "0%");
        if (string3 == null || string3.equals("south")) {
            element.setAttribute("y2", "100%");
        } else if (string3.equals("east")) {
            element.setAttribute("x2", "100%");
        } else if (string3.equals("north")) {
            element.setAttribute("y1", "100%");
        } else if (string3.equals("west")) {
            element.setAttribute("x1", "100%");
        }
        Element element2 = this.document.createElement("stop");
        element2.setAttribute("offset", "0%");
        element2.setAttribute("style", "stop-color:" + string);
        element.appendChild(element2);
        element2 = this.document.createElement("stop");
        element2.setAttribute("offset", "100%");
        element2.setAttribute("style", "stop-color:" + string2);
        element.appendChild(element2);
        return element;
    }

    public String getGradientId(String string, String string2, String string3) {
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        String string4 = null;
        if (string3 == null || string3.equals("south")) {
            string4 = "south";
        } else if (string3.equals("east")) {
            string4 = "east";
        } else {
            String string5 = string;
            string = string2;
            string2 = string5;
            if (string3.equals("north")) {
                string4 = "south";
            } else if (string3.equals("west")) {
                string4 = "east";
            }
        }
        return "mx-gradient-" + string + "-" + string2 + "-" + string4;
    }

    protected boolean isImageResource(String string) {
        return string != null && (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".jpg") || string.toLowerCase().endsWith(".gif"));
    }

    protected InputStream getResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new URL(string).openStream());
        }
        catch (Exception exception) {
            inputStream = this.getClass().getResourceAsStream(string);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createDataUrl(String string) throws IOException {
        InputStream inputStream;
        String string2 = null;
        InputStream inputStream2 = inputStream = this.isImageResource(string) ? this.getResource(string) : null;
        if (inputStream != null) {
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                byte[] byArray = new byte[512];
                while ((n = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                String string3 = "png";
                int n2 = string.lastIndexOf(46);
                if (n2 > 0 && n2 < string.length()) {
                    string3 = string.substring(n2 + 1);
                }
                string2 = "data:image/" + string3 + ";base64," + mxBase64.encodeToString(byteArrayOutputStream.toByteArray(), false);
            }
            finally {
                inputStream.close();
            }
        }
        return string2;
    }

    protected Element getEmbeddedImageElement(String string) {
        Element element = this.images.get(string);
        if (element == null) {
            element = this.document.createElement("svg");
            element.setAttribute("width", "100%");
            element.setAttribute("height", "100%");
            Element element2 = this.document.createElement("image");
            element2.setAttribute("width", "100%");
            element2.setAttribute("height", "100%");
            this.images.put(string, element);
            if (!string.startsWith("data:image/")) {
                try {
                    String string2 = this.createDataUrl(string);
                    if (string2 != null) {
                        string = string2;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            element2.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", string);
            element.appendChild(element2);
            element.setAttribute("id", "i" + this.images.size());
            this.getDefsElement().appendChild(element);
        }
        return element;
    }

    protected Element createImageElement(double d, double d2, double d3, double d4, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Element element = null;
        if (bl4) {
            element = this.document.createElement("use");
            Element element2 = this.getEmbeddedImageElement(string);
            element.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", "#" + element2.getAttribute("id"));
        } else {
            element = this.document.createElement("image");
            element.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", string);
        }
        element.setAttribute("x", String.valueOf(d));
        element.setAttribute("y", String.valueOf(d2));
        element.setAttribute("width", String.valueOf(d3));
        element.setAttribute("height", String.valueOf(d4));
        if (bl) {
            element.setAttribute("preserveAspectRatio", "xMidYMid");
        } else {
            element.setAttribute("preserveAspectRatio", "none");
        }
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 0.0;
        double d8 = 0.0;
        if (bl2) {
            d5 *= -1.0;
            d7 = -d3 - 2.0 * d;
        }
        if (bl3) {
            d6 *= -1.0;
            d8 = -d4 - 2.0 * d2;
        }
        String string2 = "";
        if (d5 != 1.0 || d6 != 1.0) {
            string2 = string2 + "scale(" + d5 + " " + d6 + ") ";
        }
        if (d7 != 0.0 || d8 != 0.0) {
            string2 = string2 + "translate(" + d7 + " " + d8 + ") ";
        }
        if (string2.length() > 0) {
            element.setAttribute("transform", string2);
        }
        return element;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    @Override
    public Object drawCell(mxCellState mxCellState2) {
        Map<String, Object> map = mxCellState2.getStyle();
        Element element = null;
        if (mxCellState2.getAbsolutePointCount() > 1) {
            List<mxPoint> list = mxCellState2.getAbsolutePoints();
            if (list == null) {
                throw new IllegalArgumentException("state has no points.");
            }
            list = mxUtils.translatePoints(list, this.translate.getX(), this.translate.getY());
            element = this.drawLine(list, map);
            float f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
            float f2 = mxUtils.getFloat(map, mxConstants.STYLE_FILL_OPACITY, 100.0f);
            float f3 = mxUtils.getFloat(map, mxConstants.STYLE_STROKE_OPACITY, 100.0f);
            if (f != 100.0f || f2 != 100.0f || f3 != 100.0f) {
                String string = String.valueOf(f * f2 / 10000.0f);
                String string2 = String.valueOf(f * f3 / 10000.0f);
                element.setAttribute("fill-opacity", string);
                element.setAttribute("stroke-opacity", string2);
            }
        } else {
            int n = (int)(mxCellState2.getX() + this.translate.getX());
            int n2 = (int)(mxCellState2.getY() + this.translate.getY());
            int n3 = (int)mxCellState2.getWidth();
            int n4 = (int)mxCellState2.getHeight();
            if (!mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                element = this.drawShape(n, n2, n3, n4, map);
            } else {
                int n5 = (int)Math.round((double)mxUtils.getInt(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>(map);
                hashtable.remove(mxConstants.STYLE_FILLCOLOR);
                hashtable.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true)) {
                    element = this.drawShape(n, n2, n3, n5, map);
                    this.drawShape(n, n2 + n5, n3, n4 - n5, hashtable);
                } else {
                    element = this.drawShape(n, n2, n5, n4, map);
                    this.drawShape(n + n5, n2, n3 - n5, n4, hashtable);
                }
            }
        }
        return element;
    }

    @Override
    public Object drawLabel(String string, mxCellState mxCellState2, boolean bl) {
        mxRectangle mxRectangle2 = mxCellState2.getLabelBounds();
        if (this.drawLabels && mxRectangle2 != null) {
            int n = (int)(mxRectangle2.getX() + this.translate.getX());
            int n2 = (int)(mxRectangle2.getY() + this.translate.getY());
            int n3 = (int)mxRectangle2.getWidth();
            int n4 = (int)mxRectangle2.getHeight();
            Map<String, Object> map = mxCellState2.getStyle();
            return this.drawText(string, n, n2, n3, n4, map);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element drawShape(int n, int n2, int n3, int n4, Map<String, Object> map) {
        Object object;
        Element element;
        String string = mxUtils.getString(map, mxConstants.STYLE_FILLCOLOR, "none");
        String string2 = mxUtils.getString(map, mxConstants.STYLE_GRADIENTCOLOR, "none");
        String string3 = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR, "none");
        float f = (float)((double)mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        float f2 = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
        float f3 = mxUtils.getFloat(map, mxConstants.STYLE_FILL_OPACITY, 100.0f);
        float f4 = mxUtils.getFloat(map, mxConstants.STYLE_STROKE_OPACITY, 100.0f);
        String string4 = mxUtils.getString(map, mxConstants.STYLE_SHAPE, "");
        Element element2 = null;
        Element element3 = null;
        if (string4.equals("image")) {
            String string5 = this.getImageForStyle(map);
            if (string5 == null) throw new IllegalArgumentException("style has no img defined.");
            boolean bl = mxUtils.isTrue(map, mxConstants.STYLE_IMAGE_FLIPH, false);
            boolean bl2 = mxUtils.isTrue(map, mxConstants.STYLE_IMAGE_FLIPV, false);
            element2 = this.createImageElement(n, n2, n3, n4, string5, PRESERVE_IMAGE_ASPECT, bl, bl2, this.isEmbedded());
        } else if (string4.equals("line")) {
            int n5;
            String string6 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "east");
            String string7 = null;
            if (string6.equals("east") || string6.equals("west")) {
                n5 = n2 + n4 / 2;
                string7 = "M " + n + " " + n5 + " L " + (n + n3) + " " + n5;
            } else {
                n5 = n + n3 / 2;
                string7 = "M " + n5 + " " + n2 + " L " + n5 + " " + (n2 + n4);
            }
            element2 = this.document.createElement("path");
            element2.setAttribute("d", string7 + " Z");
        } else if (string4.equals("ellipse")) {
            element2 = this.document.createElement("ellipse");
            element2.setAttribute("cx", String.valueOf(n + n3 / 2));
            element2.setAttribute("cy", String.valueOf(n2 + n4 / 2));
            element2.setAttribute("rx", String.valueOf(n3 / 2));
            element2.setAttribute("ry", String.valueOf(n4 / 2));
        } else if (string4.equals("doubleEllipse")) {
            element2 = this.document.createElement("g");
            element3 = this.document.createElement("ellipse");
            element3.setAttribute("cx", String.valueOf(n + n3 / 2));
            element3.setAttribute("cy", String.valueOf(n2 + n4 / 2));
            element3.setAttribute("rx", String.valueOf(n3 / 2));
            element3.setAttribute("ry", String.valueOf(n4 / 2));
            element2.appendChild(element3);
            int n6 = (int)((double)(3.0f + f) * this.scale);
            Element element4 = this.document.createElement("ellipse");
            element4.setAttribute("fill", "none");
            element4.setAttribute("stroke", string3);
            element4.setAttribute("stroke-width", String.valueOf(f));
            element4.setAttribute("cx", String.valueOf(n + n3 / 2));
            element4.setAttribute("cy", String.valueOf(n2 + n4 / 2));
            element4.setAttribute("rx", String.valueOf(n3 / 2 - n6));
            element4.setAttribute("ry", String.valueOf(n4 / 2 - n6));
            element2.appendChild(element4);
        } else if (string4.equals("rhombus")) {
            element2 = this.document.createElement("path");
            String string8 = "M " + (n + n3 / 2) + " " + n2 + " L " + (n + n3) + " " + (n2 + n4 / 2) + " L " + (n + n3 / 2) + " " + (n2 + n4) + " L " + n + " " + (n2 + n4 / 2);
            element2.setAttribute("d", string8 + " Z");
        } else if (string4.equals("triangle")) {
            element2 = this.document.createElement("path");
            String string9 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "");
            String string10 = null;
            string10 = string9.equals("north") ? "M " + n + " " + (n2 + n4) + " L " + (n + n3 / 2) + " " + n2 + " L " + (n + n3) + " " + (n2 + n4) : (string9.equals("south") ? "M " + n + " " + n2 + " L " + (n + n3 / 2) + " " + (n2 + n4) + " L " + (n + n3) + " " + n2 : (string9.equals("west") ? "M " + (n + n3) + " " + n2 + " L " + n + " " + (n2 + n4 / 2) + " L " + (n + n3) + " " + (n2 + n4) : "M " + n + " " + n2 + " L " + (n + n3) + " " + (n2 + n4 / 2) + " L " + n + " " + (n2 + n4)));
            element2.setAttribute("d", string10 + " Z");
        } else if (string4.equals("hexagon")) {
            element2 = this.document.createElement("path");
            String string11 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "");
            String string12 = null;
            string12 = string11.equals("north") || string11.equals("south") ? "M " + ((double)n + 0.5 * (double)n3) + " " + n2 + " L " + (n + n3) + " " + ((double)n2 + 0.25 * (double)n4) + " L " + (n + n3) + " " + ((double)n2 + 0.75 * (double)n4) + " L " + ((double)n + 0.5 * (double)n3) + " " + (n2 + n4) + " L " + n + " " + ((double)n2 + 0.75 * (double)n4) + " L " + n + " " + ((double)n2 + 0.25 * (double)n4) : "M " + ((double)n + 0.25 * (double)n3) + " " + n2 + " L " + ((double)n + 0.75 * (double)n3) + " " + n2 + " L " + (n + n3) + " " + ((double)n2 + 0.5 * (double)n4) + " L " + ((double)n + 0.75 * (double)n3) + " " + (n2 + n4) + " L " + ((double)n + 0.25 * (double)n3) + " " + (n2 + n4) + " L " + n + " " + ((double)n2 + 0.5 * (double)n4);
            element2.setAttribute("d", string12 + " Z");
        } else if (string4.equals("cloud")) {
            element2 = this.document.createElement("path");
            String string13 = "M " + ((double)n + 0.25 * (double)n3) + " " + ((double)n2 + 0.25 * (double)n4) + " C " + ((double)n + 0.05 * (double)n3) + " " + ((double)n2 + 0.25 * (double)n4) + " " + n + " " + ((double)n2 + 0.5 * (double)n4) + " " + ((double)n + 0.16 * (double)n3) + " " + ((double)n2 + 0.55 * (double)n4) + " C " + n + " " + ((double)n2 + 0.66 * (double)n4) + " " + ((double)n + 0.18 * (double)n3) + " " + ((double)n2 + 0.9 * (double)n4) + " " + ((double)n + 0.31 * (double)n3) + " " + ((double)n2 + 0.8 * (double)n4) + " C " + ((double)n + 0.4 * (double)n3) + " " + (n2 + n4) + " " + ((double)n + 0.7 * (double)n3) + " " + (n2 + n4) + " " + ((double)n + 0.8 * (double)n3) + " " + ((double)n2 + 0.8 * (double)n4) + " C " + (n + n3) + " " + ((double)n2 + 0.8 * (double)n4) + " " + (n + n3) + " " + ((double)n2 + 0.6 * (double)n4) + " " + ((double)n + 0.875 * (double)n3) + " " + ((double)n2 + 0.5 * (double)n4) + " C " + (n + n3) + " " + ((double)n2 + 0.3 * (double)n4) + " " + ((double)n + 0.8 * (double)n3) + " " + ((double)n2 + 0.1 * (double)n4) + " " + ((double)n + 0.625 * (double)n3) + " " + ((double)n2 + 0.2 * (double)n4) + " C " + ((double)n + 0.5 * (double)n3) + " " + ((double)n2 + 0.05 * (double)n4) + " " + ((double)n + 0.3 * (double)n3) + " " + ((double)n2 + 0.05 * (double)n4) + " " + ((double)n + 0.25 * (double)n3) + " " + ((double)n2 + 0.25 * (double)n4);
            element2.setAttribute("d", string13 + " Z");
        } else if (string4.equals("actor")) {
            element2 = this.document.createElement("path");
            double d = n3 / 3;
            String string14 = " M " + n + " " + (n2 + n4) + " C " + n + " " + (n2 + 3 * n4 / 5) + " " + n + " " + (n2 + 2 * n4 / 5) + " " + (n + n3 / 2) + " " + (n2 + 2 * n4 / 5) + " C " + ((double)(n + n3 / 2) - d) + " " + (n2 + 2 * n4 / 5) + " " + ((double)(n + n3 / 2) - d) + " " + n2 + " " + (n + n3 / 2) + " " + n2 + " C " + ((double)(n + n3 / 2) + d) + " " + n2 + " " + ((double)(n + n3 / 2) + d) + " " + (n2 + 2 * n4 / 5) + " " + (n + n3 / 2) + " " + (n2 + 2 * n4 / 5) + " C " + (n + n3) + " " + (n2 + 2 * n4 / 5) + " " + (n + n3) + " " + (n2 + 3 * n4 / 5) + " " + (n + n3) + " " + (n2 + n4);
            element2.setAttribute("d", string14 + " Z");
        } else if (string4.equals("cylinder")) {
            element2 = this.document.createElement("g");
            element3 = this.document.createElement("path");
            double d = Math.min(40.0, Math.floor(n4 / 5));
            String string15 = " M " + n + " " + ((double)n2 + d) + " C " + n + " " + ((double)n2 - d / 3.0) + " " + (n + n3) + " " + ((double)n2 - d / 3.0) + " " + (n + n3) + " " + ((double)n2 + d) + " L " + (n + n3) + " " + ((double)(n2 + n4) - d) + " C " + (n + n3) + " " + ((double)(n2 + n4) + d / 3.0) + " " + n + " " + ((double)(n2 + n4) + d / 3.0) + " " + n + " " + ((double)(n2 + n4) - d);
            element3.setAttribute("d", string15 + " Z");
            element2.appendChild(element3);
            element = this.document.createElement("path");
            string15 = "M " + n + " " + ((double)n2 + d) + " C " + n + " " + ((double)n2 + 2.0 * d) + " " + (n + n3) + " " + ((double)n2 + 2.0 * d) + " " + (n + n3) + " " + ((double)n2 + d);
            element.setAttribute("d", string15);
            element.setAttribute("fill", "none");
            element.setAttribute("stroke", string3);
            element.setAttribute("stroke-width", String.valueOf(f));
            element2.appendChild(element);
        } else {
            String string16;
            element2 = element3 = this.document.createElement("rect");
            element2.setAttribute("x", String.valueOf(n));
            element2.setAttribute("y", String.valueOf(n2));
            element2.setAttribute("width", String.valueOf(n3));
            element2.setAttribute("height", String.valueOf(n4));
            if (mxUtils.isTrue(map, mxConstants.STYLE_ROUNDED, false)) {
                string16 = String.valueOf(Math.min((double)n3 * mxConstants.RECTANGLE_ROUNDING_FACTOR, (double)n4 * mxConstants.RECTANGLE_ROUNDING_FACTOR));
                element2.setAttribute("rx", string16);
                element2.setAttribute("ry", string16);
            }
            if (string4.equals("label")) {
                string16 = this.getImageForStyle(map);
                if (string16 != null) {
                    String string17 = mxUtils.getString(map, mxConstants.STYLE_IMAGE_ALIGN, "left");
                    String string18 = mxUtils.getString(map, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "middle");
                    int n7 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE) * this.scale);
                    int n8 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE) * this.scale);
                    int n9 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_SPACING, 2) * this.scale);
                    object = new mxRectangle(n, n2, n3, n4);
                    if (string17.equals("center")) {
                        ((mxPoint)object).setX(((mxPoint)object).getX() + (((mxRectangle)object).getWidth() - (double)n7) / 2.0);
                    } else if (string17.equals("right")) {
                        ((mxPoint)object).setX(((mxPoint)object).getX() + ((mxRectangle)object).getWidth() - (double)n7 - (double)n9 - 2.0);
                    } else {
                        ((mxPoint)object).setX(((mxPoint)object).getX() + (double)n9 + 4.0);
                    }
                    if (string18.equals("top")) {
                        ((mxPoint)object).setY(((mxPoint)object).getY() + (double)n9);
                    } else if (string18.equals("bottom")) {
                        ((mxPoint)object).setY(((mxPoint)object).getY() + ((mxRectangle)object).getHeight() - (double)n8 - (double)n9);
                    } else {
                        ((mxPoint)object).setY(((mxPoint)object).getY() + (((mxRectangle)object).getHeight() - (double)n8) / 2.0);
                    }
                    ((mxRectangle)object).setWidth(n7);
                    ((mxRectangle)object).setHeight(n8);
                    element2 = this.document.createElement("g");
                    element2.appendChild(element3);
                    Element element5 = this.createImageElement(((mxPoint)object).getX(), ((mxPoint)object).getY(), ((mxRectangle)object).getWidth(), ((mxRectangle)object).getHeight(), string16, false, false, false, this.isEmbedded());
                    if (f2 != 100.0f || f3 != 100.0f) {
                        String string19 = String.valueOf(f2 * f3 / 10000.0f);
                        element5.setAttribute("opacity", string19);
                    }
                    element2.appendChild(element5);
                }
                if (mxUtils.isTrue(map, mxConstants.STYLE_GLASS, false)) {
                    double d = 0.4;
                    element = this.document.createElement("path");
                    element.setAttribute("fill", "url(#" + this.getGlassGradientElement().getAttribute("id") + ")");
                    String string20 = "m " + ((float)n - f) + "," + ((float)n2 - f) + " L " + ((float)n - f) + "," + ((double)n2 + (double)n4 * d) + " Q " + ((double)n + (double)n3 * 0.5) + "," + ((double)n2 + (double)n4 * 0.7) + " " + ((float)(n + n3) + f) + "," + ((double)n2 + (double)n4 * d) + " L " + ((float)(n + n3) + f) + "," + ((float)n2 - f) + " z";
                    element.setAttribute("stroke-width", String.valueOf(f / 2.0f));
                    element.setAttribute("d", string20);
                    element2.appendChild(element);
                }
            }
        }
        double d = mxUtils.getDouble(map, mxConstants.STYLE_ROTATION);
        int n10 = n + n3 / 2;
        int n11 = n2 + n4 / 2;
        Element element6 = element3;
        if (element6 == null) {
            element6 = element2;
        }
        if (!element6.getNodeName().equalsIgnoreCase("use") && !element6.getNodeName().equalsIgnoreCase("image")) {
            if (!string.equalsIgnoreCase("none") && !string2.equalsIgnoreCase("none")) {
                String string21 = mxUtils.getString(map, mxConstants.STYLE_GRADIENT_DIRECTION);
                object = this.getGradientElement(string, string2, string21);
                if (object != null) {
                    element6.setAttribute("fill", "url(#" + object.getAttribute("id") + ")");
                }
            } else {
                element6.setAttribute("fill", string);
            }
            element6.setAttribute("stroke", string3);
            element6.setAttribute("stroke-width", String.valueOf(f));
            Element element7 = null;
            if (mxUtils.isTrue(map, mxConstants.STYLE_SHADOW, false) && !string.equals("none")) {
                element7 = (Element)element6.cloneNode(true);
                element7.setAttribute("transform", mxConstants.SVG_SHADOWTRANSFORM);
                element7.setAttribute("fill", mxConstants.W3C_SHADOWCOLOR);
                element7.setAttribute("stroke", mxConstants.W3C_SHADOWCOLOR);
                element7.setAttribute("stroke-width", String.valueOf(f));
                if (d != 0.0) {
                    element7.setAttribute("transform", "rotate(" + d + "," + n10 + "," + n11 + ") " + mxConstants.SVG_SHADOWTRANSFORM);
                }
                if (f2 != 100.0f) {
                    object = String.valueOf(f2 / 100.0f);
                    element7.setAttribute("fill-opacity", (String)object);
                    element7.setAttribute("stroke-opacity", (String)object);
                }
                this.appendSvgElement(element7);
            }
        }
        if (d != 0.0) {
            element2.setAttribute("transform", element2.getAttribute("transform") + " rotate(" + d + "," + n10 + "," + n11 + ")");
        }
        if (f2 != 100.0f || f3 != 100.0f || f4 != 100.0f) {
            String string22 = String.valueOf(f2 * f3 / 10000.0f);
            object = String.valueOf(f2 * f4 / 10000.0f);
            element2.setAttribute("fill-opacity", string22);
            element2.setAttribute("stroke-opacity", (String)object);
        }
        if (mxUtils.isTrue(map, mxConstants.STYLE_DASHED)) {
            String string23 = mxUtils.getString(map, mxConstants.STYLE_DASH_PATTERN, "3, 3");
            element2.setAttribute("stroke-dasharray", string23);
        }
        this.appendSvgElement(element2);
        return element2;
    }

    public Element drawLine(List<mxPoint> list, Map<String, Object> map) {
        Element element = this.document.createElement("g");
        Element element2 = this.document.createElement("path");
        boolean bl = mxUtils.isTrue(map, mxConstants.STYLE_ROUNDED, false);
        String string = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR);
        float f = mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f);
        float f2 = (float)((double)f * this.scale);
        if (string != null && f2 > 0.0f) {
            double d;
            double d2;
            Object object = map.get(mxConstants.STYLE_STARTARROW);
            mxPoint mxPoint2 = list.get(1);
            mxPoint mxPoint3 = list.get(0);
            mxPoint mxPoint4 = null;
            if (object != null) {
                float f3 = mxUtils.getFloat(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE);
                mxPoint4 = this.drawMarker(element, object, mxPoint2, mxPoint3, f3, f, string);
            } else {
                double d3 = mxPoint2.getX() - mxPoint3.getX();
                double d4 = mxPoint2.getY() - mxPoint3.getY();
                double d5 = Math.max(1.0, Math.sqrt(d3 * d3 + d4 * d4));
                d2 = d3 * (double)f2 / d5;
                d = d4 * (double)f2 / d5;
                mxPoint4 = new mxPoint(d2 / 2.0, d / 2.0);
            }
            if (mxPoint4 != null) {
                mxPoint3 = (mxPoint)mxPoint3.clone();
                mxPoint3.setX(mxPoint3.getX() + mxPoint4.getX());
                mxPoint3.setY(mxPoint3.getY() + mxPoint4.getY());
                mxPoint4 = null;
            }
            object = map.get(mxConstants.STYLE_ENDARROW);
            mxPoint2 = list.get(list.size() - 2);
            mxPoint mxPoint5 = list.get(list.size() - 1);
            if (object != null) {
                float f4 = mxUtils.getFloat(map, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE);
                mxPoint4 = this.drawMarker(element, object, mxPoint2, mxPoint5, f4, f, string);
            } else {
                double d6 = mxPoint2.getX() - mxPoint3.getX();
                double d7 = mxPoint2.getY() - mxPoint3.getY();
                double d8 = Math.max(1.0, Math.sqrt(d6 * d6 + d7 * d7));
                double d9 = d6 * (double)f2 / d8;
                double d10 = d7 * (double)f2 / d8;
                mxPoint4 = new mxPoint(d9 / 2.0, d10 / 2.0);
            }
            if (mxPoint4 != null) {
                mxPoint5 = (mxPoint)mxPoint5.clone();
                mxPoint5.setX(mxPoint5.getX() + mxPoint4.getX());
                mxPoint5.setY(mxPoint5.getY() + mxPoint4.getY());
                mxPoint4 = null;
            }
            double d11 = mxConstants.LINE_ARCSIZE * this.scale;
            mxPoint2 = mxPoint3;
            String string2 = "M " + mxPoint2.getX() + " " + mxPoint2.getY();
            for (int i = 1; i < list.size() - 1; ++i) {
                mxPoint mxPoint6 = list.get(i);
                d2 = mxPoint2.getX() - mxPoint6.getX();
                d = mxPoint2.getY() - mxPoint6.getY();
                if (bl && i < list.size() - 1 && (d2 != 0.0 || d != 0.0)) {
                    double d12 = Math.sqrt(d2 * d2 + d * d);
                    double d13 = d2 * Math.min(d11, d12 / 2.0) / d12;
                    double d14 = d * Math.min(d11, d12 / 2.0) / d12;
                    double d15 = mxPoint6.getX() + d13;
                    double d16 = mxPoint6.getY() + d14;
                    string2 = string2 + " L " + d15 + " " + d16;
                    mxPoint mxPoint7 = list.get(i + 1);
                    d2 = mxPoint7.getX() - mxPoint6.getX();
                    d = mxPoint7.getY() - mxPoint6.getY();
                    d12 = Math.max(1.0, Math.sqrt(d2 * d2 + d * d));
                    double d17 = d2 * Math.min(d11, d12 / 2.0) / d12;
                    double d18 = d * Math.min(d11, d12 / 2.0) / d12;
                    double d19 = mxPoint6.getX() + d17;
                    double d20 = mxPoint6.getY() + d18;
                    string2 = string2 + " Q " + mxPoint6.getX() + " " + mxPoint6.getY() + " " + d19 + " " + d20;
                    mxPoint6 = new mxPoint(d19, d20);
                } else {
                    string2 = string2 + " L " + mxPoint6.getX() + " " + mxPoint6.getY();
                }
                mxPoint2 = mxPoint6;
            }
            string2 = string2 + " L " + mxPoint5.getX() + " " + mxPoint5.getY();
            element2.setAttribute("d", string2);
            element2.setAttribute("stroke", string);
            element2.setAttribute("fill", "none");
            element2.setAttribute("stroke-width", String.valueOf(f2));
            if (mxUtils.isTrue(map, mxConstants.STYLE_DASHED)) {
                String string3 = mxUtils.getString(map, mxConstants.STYLE_DASH_PATTERN, "3, 3");
                element2.setAttribute("stroke-dasharray", string3);
            }
            element.appendChild(element2);
            this.appendSvgElement(element);
        }
        return element;
    }

    public mxPoint drawMarker(Element element, Object object, mxPoint mxPoint2, mxPoint mxPoint3, float f, float f2, String string) {
        mxPoint mxPoint4 = null;
        double d = mxPoint3.getX() - mxPoint2.getX();
        double d2 = mxPoint3.getY() - mxPoint2.getY();
        double d3 = Math.max(1.0, Math.sqrt(d * d + d2 * d2));
        double d4 = (double)f * this.scale;
        double d5 = d * d4 / d3;
        double d6 = d2 * d4 / d3;
        mxPoint3 = (mxPoint)mxPoint3.clone();
        mxPoint3.setX(mxPoint3.getX() - d5 * (double)f2 / (double)(2.0f * f));
        mxPoint3.setY(mxPoint3.getY() - d6 * (double)f2 / (double)(2.0f * f));
        d5 *= 0.5 + (double)(f2 / 2.0f);
        d6 *= 0.5 + (double)(f2 / 2.0f);
        Element element2 = this.document.createElement("path");
        element2.setAttribute("stroke-width", String.valueOf((double)f2 * this.scale));
        element2.setAttribute("stroke", string);
        element2.setAttribute("fill", string);
        String string2 = null;
        if (object.equals("classic") || object.equals("block")) {
            string2 = "M " + mxPoint3.getX() + " " + mxPoint3.getY() + " L " + (mxPoint3.getX() - d5 - d6 / 2.0) + " " + (mxPoint3.getY() - d6 + d5 / 2.0) + (!object.equals("classic") ? "" : " L " + (mxPoint3.getX() - d5 * 3.0 / 4.0) + " " + (mxPoint3.getY() - d6 * 3.0 / 4.0)) + " L " + (mxPoint3.getX() + d6 / 2.0 - d5) + " " + (mxPoint3.getY() - d6 - d5 / 2.0) + " z";
        } else if (object.equals("open")) {
            string2 = "M " + (mxPoint3.getX() - (d5 *= 1.2) - (d6 *= 1.2) / 2.0) + " " + (mxPoint3.getY() - d6 + d5 / 2.0) + " L " + (mxPoint3.getX() - d5 / 6.0) + " " + (mxPoint3.getY() - d6 / 6.0) + " L " + (mxPoint3.getX() + d6 / 2.0 - d5) + " " + (mxPoint3.getY() - d6 - d5 / 2.0) + " M " + mxPoint3.getX() + " " + mxPoint3.getY();
            element2.setAttribute("fill", "none");
        } else if (object.equals("oval")) {
            string2 = "M " + (mxPoint3.getX() - (d6 *= 1.2) / 2.0) + " " + (mxPoint3.getY() + (d5 *= 1.2) / 2.0) + " a " + (d4 *= 1.2) / 2.0 + " " + d4 / 2.0 + " 0  1,1 " + d5 / 8.0 + " " + d6 / 8.0 + " z";
        } else if (object.equals("diamond")) {
            string2 = "M " + (mxPoint3.getX() + d5 / 2.0) + " " + (mxPoint3.getY() + d6 / 2.0) + " L " + (mxPoint3.getX() - d6 / 2.0) + " " + (mxPoint3.getY() + d5 / 2.0) + " L " + (mxPoint3.getX() - d5 / 2.0) + " " + (mxPoint3.getY() - d6 / 2.0) + " L " + (mxPoint3.getX() + d6 / 2.0) + " " + (mxPoint3.getY() - d5 / 2.0) + " z";
        }
        if (string2 != null) {
            element2.setAttribute("d", string2);
            element.appendChild(element2);
        }
        return mxPoint4;
    }

    public Object drawText(String string, int n, int n2, int n3, int n4, Map<String, Object> map) {
        Element element = null;
        String string2 = mxUtils.getString(map, mxConstants.STYLE_FONTCOLOR, "black");
        String string3 = mxUtils.getString(map, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
        int n5 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * this.scale);
        if (string != null && string.length() > 0) {
            String string4;
            float f = (float)((double)mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
            float f2 = mxUtils.getFloat(map, mxConstants.STYLE_TEXT_OPACITY, 100.0f);
            String string5 = mxUtils.getString(map, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
            String string6 = mxUtils.getString(map, mxConstants.STYLE_LABEL_BORDERCOLOR);
            String string7 = null;
            if (!mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true)) {
                double d = n + n3 / 2;
                double d2 = n2 + n4 / 2;
                string7 = "rotate(270 " + d + " " + d2 + ")";
            }
            if (string5 != null || string6 != null) {
                Element element2 = this.document.createElement("rect");
                element2.setAttribute("x", String.valueOf(n));
                element2.setAttribute("y", String.valueOf(n2));
                element2.setAttribute("width", String.valueOf(n3));
                element2.setAttribute("height", String.valueOf(n4));
                if (string5 != null) {
                    element2.setAttribute("fill", string5);
                } else {
                    element2.setAttribute("fill", "none");
                }
                if (string6 != null) {
                    element2.setAttribute("stroke", string6);
                } else {
                    element2.setAttribute("stroke", "none");
                }
                element2.setAttribute("stroke-width", String.valueOf(f));
                if (f2 != 100.0f) {
                    string4 = String.valueOf(f2 / 100.0f);
                    element2.setAttribute("fill-opacity", string4);
                    element2.setAttribute("stroke-opacity", string4);
                }
                if (string7 != null) {
                    element2.setAttribute("transform", string7);
                }
                this.appendSvgElement(element2);
            }
            element = this.document.createElement("text");
            int n6 = mxUtils.getInt(map, mxConstants.STYLE_FONTSTYLE);
            string4 = (n6 & 1) == 1 ? "bold" : "normal";
            element.setAttribute("font-weight", string4);
            String string8 = (n6 & 4) == 4 ? "underline" : "none";
            element.setAttribute("font-decoration", string8);
            if ((n6 & 2) == 2) {
                element.setAttribute("font-style", "italic");
            }
            element.setAttribute("font-size", String.valueOf(n5));
            element.setAttribute("font-family", string3);
            element.setAttribute("fill", string2);
            if (f2 != 100.0f) {
                String string9 = String.valueOf(f2 / 100.0f);
                element.setAttribute("fill-opacity", string9);
                element.setAttribute("stroke-opacity", string9);
            }
            int n7 = (n6 & 1) == 1 ? 1 : 0;
            n7 += (n6 & 2) == 2 ? 2 : 0;
            String[] stringArray = string.split("\n");
            n2 += n5 + (n4 - stringArray.length * (n5 + mxConstants.LINESPACING)) / 2 - 2;
            String string10 = mxUtils.getString(map, mxConstants.STYLE_ALIGN, "center");
            String string11 = "start";
            if (string10.equals("right")) {
                string11 = "end";
                n = (int)((double)n + ((double)n3 - (double)mxConstants.LABEL_INSET * this.scale));
            } else if (string10.equals("center")) {
                string11 = "middle";
                n += n3 / 2;
            } else {
                n = (int)((double)n + (double)mxConstants.LABEL_INSET * this.scale);
            }
            element.setAttribute("text-anchor", string11);
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = this.document.createElement("tspan");
                element3.setAttribute("x", String.valueOf(n));
                element3.setAttribute("y", String.valueOf(n2));
                element3.appendChild(this.document.createTextNode(stringArray[i]));
                element.appendChild(element3);
                n2 += n5 + mxConstants.LINESPACING;
            }
            if (string7 != null) {
                element.setAttribute("transform", string7);
            }
            this.appendSvgElement(element);
        }
        return element;
    }
}

