/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxVmlCanvas
extends mxBasicCanvas {
    protected Document document;

    public mxVmlCanvas() {
        this(null);
    }

    public mxVmlCanvas(Document document) {
        this.setDocument(document);
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void appendVmlElement(Element element) {
        Node node;
        if (this.document != null && (node = this.document.getDocumentElement().getFirstChild().getNextSibling()) != null) {
            node.appendChild(element);
        }
    }

    @Override
    public Object drawCell(mxCellState mxCellState2) {
        Map<String, Object> map = mxCellState2.getStyle();
        Element element = null;
        if (mxCellState2.getAbsolutePointCount() > 1) {
            List<mxPoint> list = mxCellState2.getAbsolutePoints();
            if (list == null) {
                throw new IllegalArgumentException("state has no points.");
            }
            list = mxUtils.translatePoints(list, this.translate.getX(), this.translate.getY());
            element = this.drawLine(list, map);
            Element element2 = this.document.createElement("v:stroke");
            String string = mxUtils.getString(map, mxConstants.STYLE_STARTARROW);
            String string2 = mxUtils.getString(map, mxConstants.STYLE_ENDARROW);
            if (string != null || string2 != null) {
                double d;
                String string3;
                String string4;
                if (string != null) {
                    element2.setAttribute("startarrow", string);
                    string4 = "medium";
                    string3 = "medium";
                    d = (double)mxUtils.getFloat(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE) * this.scale;
                    if (d < 6.0) {
                        string4 = "narrow";
                        string3 = "short";
                    } else if (d > 10.0) {
                        string4 = "wide";
                        string3 = "long";
                    }
                    element2.setAttribute("startarrowwidth", string4);
                    element2.setAttribute("startarrowlength", string3);
                }
                if (string2 != null) {
                    element2.setAttribute("endarrow", string2);
                    string4 = "medium";
                    string3 = "medium";
                    d = (double)mxUtils.getFloat(map, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE) * this.scale;
                    if (d < 6.0) {
                        string4 = "narrow";
                        string3 = "short";
                    } else if (d > 10.0) {
                        string4 = "wide";
                        string3 = "long";
                    }
                    element2.setAttribute("endarrowwidth", string4);
                    element2.setAttribute("endarrowlength", string3);
                }
            }
            if (mxUtils.isTrue(map, mxConstants.STYLE_DASHED)) {
                element2.setAttribute("dashstyle", "2 2");
            }
            element.appendChild(element2);
        } else {
            int n = (int)(mxCellState2.getX() + this.translate.getX());
            int n2 = (int)(mxCellState2.getY() + this.translate.getY());
            int n3 = (int)mxCellState2.getWidth();
            int n4 = (int)mxCellState2.getHeight();
            if (!mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                element = this.drawShape(n, n2, n3, n4, map);
                if (mxUtils.isTrue(map, mxConstants.STYLE_DASHED)) {
                    Element element3 = this.document.createElement("v:stroke");
                    element3.setAttribute("dashstyle", "2 2");
                    element.appendChild(element3);
                }
            } else {
                int n5 = (int)Math.round((double)mxUtils.getInt(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>(map);
                hashtable.remove(mxConstants.STYLE_FILLCOLOR);
                hashtable.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true)) {
                    element = this.drawShape(n, n2, n3, n5, map);
                    this.drawShape(n, n2 + n5, n3, n4 - n5, hashtable);
                } else {
                    element = this.drawShape(n, n2, n5, n4, map);
                    this.drawShape(n + n5, n2, n3 - n5, n4, hashtable);
                }
            }
        }
        return element;
    }

    @Override
    public Object drawLabel(String string, mxCellState mxCellState2, boolean bl) {
        mxRectangle mxRectangle2 = mxCellState2.getLabelBounds();
        if (this.drawLabels && mxRectangle2 != null) {
            int n = (int)(mxRectangle2.getX() + this.translate.getX());
            int n2 = (int)(mxRectangle2.getY() + this.translate.getY());
            int n3 = (int)mxRectangle2.getWidth();
            int n4 = (int)mxRectangle2.getHeight();
            Map<String, Object> map = mxCellState2.getStyle();
            return this.drawText(string, n, n2, n3, n4, map);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element drawShape(int n, int n2, int n3, int n4, Map<String, Object> map) {
        Element element;
        String string;
        String string2 = mxUtils.getString(map, mxConstants.STYLE_FILLCOLOR);
        String string3 = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR);
        float f = (float)((double)mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        String string4 = mxUtils.getString(map, mxConstants.STYLE_SHAPE);
        Element element2 = null;
        if (string4.equals("image")) {
            String string5 = this.getImageForStyle(map);
            if (string5 == null) throw new IllegalArgumentException("style has no img defined.");
            element2 = this.document.createElement("v:img");
            element2.setAttribute("src", string5);
        } else if (string4.equals("line")) {
            String string6 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "east");
            string = null;
            if (string6.equals("east") || string6.equals("west")) {
                int n5 = Math.round(n4 / 2);
                string = "m 0 " + n5 + " l " + n3 + " " + n5;
            } else {
                int n6 = Math.round(n3 / 2);
                string = "m " + n6 + " 0 L " + n6 + " " + n4;
            }
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            element2.setAttribute("path", string + " x e");
        } else if (string4.equals("ellipse")) {
            element2 = this.document.createElement("v:oval");
        } else if (string4.equals("doubleEllipse")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            int n7 = (int)((double)(3.0f + f) * this.scale);
            string = "ar 0 0 " + n3 + " " + n4 + " 0 " + n4 / 2 + " " + n3 / 2 + " " + n4 / 2 + " e ar " + n7 + " " + n7 + " " + (n3 - n7) + " " + (n4 - n7) + " 0 " + n4 / 2 + " " + n3 / 2 + " " + n4 / 2;
            element2.setAttribute("path", string + " x e");
        } else if (string4.equals("rhombus")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string7 = "m " + n3 / 2 + " 0 l " + n3 + " " + n4 / 2 + " l " + n3 / 2 + " " + n4 + " l 0 " + n4 / 2;
            element2.setAttribute("path", string7 + " x e");
        } else if (string4.equals("triangle")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string8 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "");
            string = null;
            string = string8.equals("north") ? "m 0 " + n4 + " l " + n3 / 2 + " 0  l " + n3 + " " + n4 : (string8.equals("south") ? "m 0 0 l " + n3 / 2 + " " + n4 + " l " + n3 + " 0" : (string8.equals("west") ? "m " + n3 + " 0 l " + n3 + " " + n4 / 2 + " l " + n3 + " " + n4 : "m 0 0 l " + n3 + " " + n4 / 2 + " l 0 " + n4));
            element2.setAttribute("path", string + " x e");
        } else if (string4.equals("hexagon")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string9 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "");
            string = null;
            string = string9.equals("north") || string9.equals("south") ? "m " + (int)(0.5 * (double)n3) + " 0 l " + n3 + " " + (int)(0.25 * (double)n4) + " l " + n3 + " " + (int)(0.75 * (double)n4) + " l " + (int)(0.5 * (double)n3) + " " + n4 + " l 0 " + (int)(0.75 * (double)n4) + " l 0 " + (int)(0.25 * (double)n4) : "m " + (int)(0.25 * (double)n3) + " 0 l " + (int)(0.75 * (double)n3) + " 0 l " + n3 + " " + (int)(0.5 * (double)n4) + " l " + (int)(0.75 * (double)n3) + " " + n4 + " l " + (int)(0.25 * (double)n3) + " " + n4 + " l 0 " + (int)(0.5 * (double)n4);
            element2.setAttribute("path", string + " x e");
        } else if (string4.equals("cloud")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            String string10 = "m " + (int)(0.25 * (double)n3) + " " + (int)(0.25 * (double)n4) + " c " + (int)(0.05 * (double)n3) + " " + (int)(0.25 * (double)n4) + " 0 " + (int)(0.5 * (double)n4) + " " + (int)(0.16 * (double)n3) + " " + (int)(0.55 * (double)n4) + " c 0 " + (int)(0.66 * (double)n4) + " " + (int)(0.18 * (double)n3) + " " + (int)(0.9 * (double)n4) + " " + (int)(0.31 * (double)n3) + " " + (int)(0.8 * (double)n4) + " c " + (int)(0.4 * (double)n3) + " " + n4 + " " + (int)(0.7 * (double)n3) + " " + n4 + " " + (int)(0.8 * (double)n3) + " " + (int)(0.8 * (double)n4) + " c " + n3 + " " + (int)(0.8 * (double)n4) + " " + n3 + " " + (int)(0.6 * (double)n4) + " " + (int)(0.875 * (double)n3) + " " + (int)(0.5 * (double)n4) + " c " + n3 + " " + (int)(0.3 * (double)n4) + " " + (int)(0.8 * (double)n3) + " " + (int)(0.1 * (double)n4) + " " + (int)(0.625 * (double)n3) + " " + (int)(0.2 * (double)n4) + " c " + (int)(0.5 * (double)n3) + " " + (int)(0.05 * (double)n4) + " " + (int)(0.3 * (double)n3) + " " + (int)(0.05 * (double)n4) + " " + (int)(0.25 * (double)n3) + " " + (int)(0.25 * (double)n4);
            element2.setAttribute("path", string10 + " x e");
        } else if (string4.equals("actor")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            double d = n3 / 3;
            String string11 = "m 0 " + n4 + " C 0 " + 3 * n4 / 5 + " 0 " + 2 * n4 / 5 + " " + n3 / 2 + " " + 2 * n4 / 5 + " c " + (int)((double)(n3 / 2) - d) + " " + 2 * n4 / 5 + " " + (int)((double)(n3 / 2) - d) + " 0 " + n3 / 2 + " 0 c " + (int)((double)(n3 / 2) + d) + " 0 " + (int)((double)(n3 / 2) + d) + " " + 2 * n4 / 5 + " " + n3 / 2 + " " + 2 * n4 / 5 + " c " + n3 + " " + 2 * n4 / 5 + " " + n3 + " " + 3 * n4 / 5 + " " + n3 + " " + n4;
            element2.setAttribute("path", string11 + " x e");
        } else if (string4.equals("cylinder")) {
            element2 = this.document.createElement("v:shape");
            element2.setAttribute("coordsize", n3 + " " + n4);
            double d = Math.min(40.0, Math.floor(n4 / 5));
            String string12 = "m 0 " + (int)d + " C 0 " + (int)(d / 3.0) + " " + n3 + " " + (int)(d / 3.0) + " " + n3 + " " + (int)d + " L " + n3 + " " + (int)((double)n4 - d) + " C " + n3 + " " + (int)((double)n4 + d / 3.0) + " 0 " + (int)((double)n4 + d / 3.0) + " 0 " + (int)((double)n4 - d) + " x e m 0 " + (int)d + " C 0 " + (int)(2.0 * d) + " " + n3 + " " + (int)(2.0 * d) + " " + n3 + " " + (int)d;
            element2.setAttribute("path", string12 + " e");
        } else if (mxUtils.isTrue(map, mxConstants.STYLE_ROUNDED, false)) {
            element2 = this.document.createElement("v:roundrect");
            element2.setAttribute("arcsize", mxConstants.RECTANGLE_ROUNDING_FACTOR * 100.0 + "%");
        } else {
            element2 = this.document.createElement("v:rect");
        }
        String string13 = "position:absolute;left:" + String.valueOf(n) + "px;top:" + String.valueOf(n2) + "px;width:" + String.valueOf(n3) + "px;height:" + String.valueOf(n4) + "px;";
        double d = mxUtils.getDouble(map, mxConstants.STYLE_ROTATION);
        if (d != 0.0) {
            string13 = string13 + "rotation:" + d + ";";
        }
        element2.setAttribute("style", string13);
        if (mxUtils.isTrue(map, mxConstants.STYLE_SHADOW, false) && string2 != null) {
            Element element3 = this.document.createElement("v:shadow");
            element3.setAttribute("on", "true");
            element3.setAttribute("color", mxConstants.W3C_SHADOWCOLOR);
            element2.appendChild(element3);
        }
        float f2 = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
        float f3 = mxUtils.getFloat(map, mxConstants.STYLE_FILL_OPACITY, 100.0f);
        float f4 = mxUtils.getFloat(map, mxConstants.STYLE_STROKE_OPACITY, 100.0f);
        if (string2 != null) {
            element = this.document.createElement("v:fill");
            element.setAttribute("color", string2);
            if (f2 != 100.0f || f3 != 100.0f) {
                element.setAttribute("opacity", String.valueOf(f2 * f3 / 10000.0f));
            }
            element2.appendChild(element);
        } else {
            element2.setAttribute("filled", "false");
        }
        if (string3 != null) {
            element2.setAttribute("strokecolor", string3);
            element = this.document.createElement("v:stroke");
            if (f2 != 100.0f || f4 != 100.0f) {
                element.setAttribute("opacity", String.valueOf(f2 * f4 / 10000.0f));
            }
            element2.appendChild(element);
        } else {
            element2.setAttribute("stroked", "false");
        }
        element2.setAttribute("strokeweight", String.valueOf(f) + "px");
        this.appendVmlElement(element2);
        return element2;
    }

    public Element drawLine(List<mxPoint> list, Map<String, Object> map) {
        String string = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR);
        float f = (float)((double)mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        Element element = this.document.createElement("v:shape");
        if (string != null && f > 0.0f) {
            mxPoint mxPoint2 = list.get(0);
            Rectangle rectangle = new Rectangle(mxPoint2.getPoint());
            StringBuilder stringBuilder = new StringBuilder("m " + Math.round(mxPoint2.getX()) + " " + Math.round(mxPoint2.getY()));
            for (int i = 1; i < list.size(); ++i) {
                mxPoint2 = list.get(i);
                stringBuilder.append(" l " + Math.round(mxPoint2.getX()) + " " + Math.round(mxPoint2.getY()));
                rectangle = rectangle.union(new Rectangle(mxPoint2.getPoint()));
            }
            String string2 = stringBuilder.toString();
            element.setAttribute("path", string2);
            element.setAttribute("filled", "false");
            element.setAttribute("strokecolor", string);
            element.setAttribute("strokeweight", String.valueOf(f) + "px");
            String string3 = "position:absolute;left:" + String.valueOf(rectangle.x) + "px;top:" + String.valueOf(rectangle.y) + "px;width:" + String.valueOf(rectangle.width) + "px;height:" + String.valueOf(rectangle.height) + "px;";
            element.setAttribute("style", string3);
            element.setAttribute("coordorigin", String.valueOf(rectangle.x) + " " + String.valueOf(rectangle.y));
            element.setAttribute("coordsize", String.valueOf(rectangle.width) + " " + String.valueOf(rectangle.height));
        }
        this.appendVmlElement(element);
        return element;
    }

    public Element drawText(String string, int n, int n2, int n3, int n4, Map<String, Object> map) {
        Element element = mxUtils.createTable(this.document, string, n, n2, n3, n4, this.scale, map);
        this.appendVmlElement(element);
        return element;
    }
}

