/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util.svg;

import com.mxgraph.util.svg.ExtendedGeneralPath;
import com.mxgraph.util.svg.ParseException;
import com.mxgraph.util.svg.PathHandler;
import com.mxgraph.util.svg.PathParser;
import com.mxgraph.util.svg.ShapeProducer;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class AWTPathProducer
implements PathHandler,
ShapeProducer {
    protected ExtendedGeneralPath path;
    protected float currentX;
    protected float currentY;
    protected float xCenter;
    protected float yCenter;
    protected int windingRule;

    public static Shape createShape(String string, int n) throws ParseException {
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(n);
        PathParser pathParser = new PathParser(aWTPathProducer);
        pathParser.parse(string);
        return aWTPathProducer.getShape();
    }

    @Override
    public void setWindingRule(int n) {
        this.windingRule = n;
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public void startPath() throws ParseException {
        this.currentX = 0.0f;
        this.currentY = 0.0f;
        this.xCenter = 0.0f;
        this.yCenter = 0.0f;
        this.path = new ExtendedGeneralPath(this.windingRule);
    }

    @Override
    public void endPath() throws ParseException {
    }

    @Override
    public void movetoRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY += f2;
        this.path.moveTo(this.currentX, this.currentY);
    }

    @Override
    public void movetoAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY = f2;
        this.path.moveTo(this.currentX, this.currentY);
    }

    @Override
    public void closePath() throws ParseException {
        this.path.closePath();
        Point2D point2D = this.path.getCurrentPoint();
        if (point2D != null) {
            this.currentX = (float)point2D.getX();
            this.currentY = (float)point2D.getY();
        }
    }

    @Override
    public void linetoRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY += f2;
        this.path.lineTo(this.currentX, this.currentY);
    }

    @Override
    public void linetoAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY = f2;
        this.path.lineTo(this.currentX, this.currentY);
    }

    @Override
    public void linetoHorizontalRel(float f) throws ParseException {
        this.xCenter = this.currentX += f;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    @Override
    public void linetoHorizontalAbs(float f) throws ParseException {
        this.xCenter = this.currentX = f;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    @Override
    public void linetoVerticalRel(float f) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY += f;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    @Override
    public void linetoVerticalAbs(float f) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY = f;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    @Override
    public void curvetoCubicRel(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.xCenter = this.currentX + f3;
        this.yCenter = this.currentY + f4;
        this.path.curveTo(this.currentX + f, this.currentY + f2, this.xCenter, this.yCenter, this.currentX += f5, this.currentY += f6);
    }

    @Override
    public void curvetoCubicAbs(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.xCenter = f3;
        this.yCenter = f4;
        this.currentX = f5;
        this.currentY = f6;
        this.path.curveTo(f, f2, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoCubicSmoothRel(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = this.currentX + f;
        this.yCenter = this.currentY + f2;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
    }

    @Override
    public void curvetoCubicSmoothAbs(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = f;
        this.yCenter = f2;
        this.currentX = f3;
        this.currentY = f4;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoQuadraticRel(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = this.currentX + f;
        this.yCenter = this.currentY + f2;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f3, this.currentY += f4);
    }

    @Override
    public void curvetoQuadraticAbs(float f, float f2, float f3, float f4) throws ParseException {
        this.xCenter = f;
        this.yCenter = f2;
        this.currentX = f3;
        this.currentY = f4;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoQuadraticSmoothRel(float f, float f2) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f, this.currentY += f2);
    }

    @Override
    public void curvetoQuadraticSmoothAbs(float f, float f2) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.currentX = f;
        this.currentY = f2;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void arcRel(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX += f4;
        this.yCenter = this.currentY += f5;
        this.path.arcTo(f, f2, f3, bl, bl2, this.currentX, this.currentY);
    }

    @Override
    public void arcAbs(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX = f4;
        this.yCenter = this.currentY = f5;
        this.path.arcTo(f, f2, f3, bl, bl2, this.currentX, this.currentY);
    }
}

