/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class OpenLinkEvent
extends EventObject {
    public static final int SAME_WINDOW_EVENT = 1;
    public static final int NEW_WINDOW_EVENT = 2;
    private final String link;
    private final int id;
    private final URL url;

    public OpenLinkEvent(IWebBrowser iWebBrowser, int n, String string) {
        super(iWebBrowser);
        this.id = n;
        this.link = string;
        this.url = string != null ? this.createURL(string) : null;
    }

    public IWebBrowser getBrowser() {
        return (IWebBrowser)this.getSource();
    }

    public int getID() {
        return this.id;
    }

    public String getLink() {
        return this.link;
    }

    public URL getURL() {
        return this.url;
    }

    private URL createURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new URL(BrowserEngineManager.instance().getActiveEngine().getFileProtocolURLPrefix() + string);
            }
            catch (MalformedURLException malformedURLException2) {
                WebBrowserUtil.trace(malformedURLException2.toString());
                return null;
            }
        }
    }
}

