/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.event.TextHelpModelEvent;
import javax.help.event.TextHelpModelListener;
import javax.help.plaf.HelpContentViewerUI;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.jdic.browser.WebBrowser;

public class BasicNativeContentViewerUI
extends HelpContentViewerUI
implements HelpModelListener,
TextHelpModelListener,
PropertyChangeListener,
Serializable {
    protected JHelpContentViewer theViewer;
    private static Dimension PREF_SIZE = new Dimension(200, 300);
    private static Dimension MIN_SIZE = new Dimension(80, 80);
    private WebBrowser html;
    private JViewport vp;
    private static final boolean debug = false;

    public static ComponentUI createUI(JComponent x) {
        BasicNativeContentViewerUI.debug("createUI");
        return new BasicNativeContentViewerUI((JHelpContentViewer)x);
    }

    public BasicNativeContentViewerUI(JHelpContentViewer b) {
        BasicNativeContentViewerUI.debug("createUI - sort of");
    }

    public void installUI(JComponent c) {
        URL url;
        BasicNativeContentViewerUI.debug("installUI");
        this.theViewer = (JHelpContentViewer)c;
        this.theViewer.setLayout(new BorderLayout());
        this.theViewer.addPropertyChangeListener(this);
        TextHelpModel model = this.theViewer.getModel();
        if (model != null) {
            model.addHelpModelListener(this);
            model.addTextHelpModelListener(this);
        }
        this.html = new WebBrowser();
        this.html.getAccessibleContext().setAccessibleName(HelpUtilities.getString(HelpUtilities.getLocale((Component)this.html), "access.contentViewer"));
        if (model != null && (url = model.getCurrentURL()) != null) {
            this.html.setURL(url);
        }
        JScrollPane scroller = new JScrollPane();
        scroller.setBorder(new BevelBorder(1, Color.white, Color.gray));
        this.vp = scroller.getViewport();
        this.vp.add((Component)this.html);
        this.vp.setBackingStoreEnabled(true);
        this.theViewer.add("Center", scroller);
    }

    public void uninstallUI(JComponent c) {
        BasicNativeContentViewerUI.debug("uninstallUI");
        JHelpContentViewer viewer = (JHelpContentViewer)c;
        viewer.removePropertyChangeListener(this);
        TextHelpModel model = viewer.getModel();
        if (model != null) {
            model.removeHelpModelListener(this);
            model.removeTextHelpModelListener(this);
        }
        viewer.setLayout(null);
        viewer.removeAll();
    }

    public Dimension getPreferredSize(JComponent c) {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID id = e.getID();
        URL url = e.getURL();
        TextHelpModel model = this.theViewer.getModel();
        BasicNativeContentViewerUI.debug("idChanged(" + e + ")");
        BasicNativeContentViewerUI.debug("  = " + id + " " + url);
        BasicNativeContentViewerUI.debug("  my helpModel: " + model);
        model.setDocumentTitle(null);
        this.html.setURL(url);
        BasicNativeContentViewerUI.debug("done with idChanged");
    }

    private void rebuild() {
        BasicNativeContentViewerUI.debug("rebuild");
        TextHelpModel model = this.theViewer.getModel();
        if (model == null) {
            BasicNativeContentViewerUI.debug("rebuild-end: model is null");
            return;
        }
        HelpSet hs = model.getHelpSet();
        if (this.theViewer.getSynch()) {
            try {
                Map.ID homeID = hs.getHomeID();
                Locale locale = hs.getLocale();
                String name = HelpUtilities.getString(locale, "history.homePage");
                model.setCurrentID(homeID, name, null);
                this.html.setURL(model.getCurrentURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BasicNativeContentViewerUI.debug("rebuild-end");
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicNativeContentViewerUI.debug("propertyChange: " + event.getPropertyName() + "\n\toldValue:" + event.getOldValue() + "\n\tnewValue:" + event.getNewValue());
        if (event.getSource() == this.theViewer) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                TextHelpModel oldModel = (TextHelpModel)event.getOldValue();
                TextHelpModel newModel = (TextHelpModel)event.getNewValue();
                if (oldModel != null) {
                    oldModel.removeHelpModelListener(this);
                    oldModel.removeTextHelpModelListener(this);
                }
                if (newModel != null) {
                    newModel.addHelpModelListener(this);
                    newModel.addTextHelpModelListener(this);
                }
                this.rebuild();
            } else if (changeName.equals("font")) {
                BasicNativeContentViewerUI.debug("font changed");
                Font font = (Font)event.getNewValue();
            } else if (!changeName.equals("clear") && changeName.equals("reload")) {
                this.html.refresh();
            }
        }
    }

    public void highlightsChanged(TextHelpModelEvent e) {
        BasicNativeContentViewerUI.debug("highlightsChanged " + e);
    }

    private static void debug(String str) {
    }
}

