/*
 * Decompiled with CFR 0.152.
 */
package javax.help.tagext;

import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.SearchView;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class SearchTOCItemTag
extends BodyTagSupport
implements SearchListener {
    private Enumeration treeEnum;
    private Vector nodes;
    private SearchView view;
    private HelpBroker hb;
    private String query;
    private MergingSearchEngine helpsearch;
    private SearchQuery searchquery;
    private boolean searchFinished;
    private static final boolean debug = false;

    public void setSearchView(SearchView view) {
        this.view = view;
    }

    public void setHelpBroker(HelpBroker hb) {
        this.hb = hb;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public synchronized int doStartTag() {
        if (this.helpsearch == null) {
            this.helpsearch = new MergingSearchEngine((NavigatorView)this.view);
            this.searchquery = this.helpsearch.createQuery();
            this.searchquery.addSearchListener((SearchListener)this);
            this.addSubHelpSets(this.view.getHelpSet());
        }
        if (this.searchquery.isActive()) {
            this.searchquery.stop();
        }
        this.searchquery.start(this.query, Locale.getDefault());
        if (!this.searchFinished) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.treeEnum.hasMoreElements()) {
            SearchTOCItem item = (SearchTOCItem)this.treeEnum.nextElement();
            this.setNodeAttributes(item);
            return 2;
        }
        return 0;
    }

    private void addSubHelpSets(HelpSet hs) {
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            HelpSet ehs = (HelpSet)e.nextElement();
            if (ehs == null) continue;
            NavigatorView[] views = ehs.getNavigatorViews();
            for (int i = 0; i < views.length; ++i) {
                if (!(views[i] instanceof SearchView)) continue;
                this.helpsearch.merge(views[i]);
            }
            this.addSubHelpSets(ehs);
        }
    }

    public int doAfterBody() throws JspException {
        BodyContent body = this.getBodyContent();
        try {
            body.writeOut((Writer)this.getPreviousOut());
        }
        catch (IOException e) {
            throw new JspTagException("SearchTOCItemTag: " + e.getMessage());
        }
        body.clearBody();
        if (this.treeEnum.hasMoreElements()) {
            SearchTOCItem item = (SearchTOCItem)this.treeEnum.nextElement();
            this.setNodeAttributes(item);
            return 2;
        }
        return 0;
    }

    private void setNodeAttributes(SearchTOCItem item) {
        this.pageContext.setAttribute("name", (Object)item.getName());
        this.pageContext.setAttribute("helpID", (Object)this.getMapID(item));
        this.pageContext.setAttribute("confidence", (Object)Double.toString(item.getConfidence()));
        this.pageContext.setAttribute("hits", (Object)Integer.toString(item.hitCount()));
        this.pageContext.setAttribute("contentURL", (Object)item.getURL().toExternalForm());
        this.pageContext.setAttribute("hitBoundries", (Object)this.getSearchHits(item));
    }

    private String getMapID(SearchTOCItem item) {
        URL url = item.getURL();
        HelpSet hs = this.hb.getHelpSet();
        Map map = hs.getCombinedMap();
        Map.ID id = map.getIDFromURL(url);
        if (id == null) {
            return "";
        }
        return id.id;
    }

    private String getSearchHits(SearchTOCItem item) {
        String retval = "{ ";
        Enumeration enum1 = item.getSearchHits();
        while (enum1.hasMoreElements()) {
            SearchHit info = (SearchHit)enum1.nextElement();
            retval = retval + "{" + info.getBegin() + "," + info.getEnd() + "}";
            if (!enum1.hasMoreElements()) continue;
            retval = retval + ", ";
        }
        retval = retval + " }";
        return retval;
    }

    public synchronized void itemsFound(SearchEvent e) {
        Enumeration itemEnum = e.getSearchItems();
        while (itemEnum != null && itemEnum.hasMoreElements()) {
            SearchTOCItem tocitem;
            URL url;
            SearchItem item = (SearchItem)itemEnum.nextElement();
            try {
                url = new URL(item.getBase(), item.getFilename());
            }
            catch (MalformedURLException me) {
                SearchTOCItemTag.debug("Failed to create URL from " + item.getBase() + "|" + item.getFilename());
                continue;
            }
            boolean foundNode = false;
            Enumeration nodesEnum = this.nodes.elements();
            while (nodesEnum.hasMoreElements()) {
                tocitem = (SearchTOCItem)nodesEnum.nextElement();
                URL testURL = tocitem.getURL();
                if (testURL == null || url == null || !url.sameFile(testURL)) continue;
                tocitem.addSearchHit(new SearchHit(item.getConfidence(), item.getBegin(), item.getEnd()));
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            tocitem = new SearchTOCItem(item);
            this.nodes.addElement(tocitem);
        }
    }

    public synchronized void searchStarted(SearchEvent e) {
        this.nodes = new Vector();
        this.searchFinished = false;
    }

    public synchronized void searchFinished(SearchEvent e) {
        this.searchFinished = true;
        this.treeEnum = this.nodes.elements();
        ((Object)((Object)this)).notifyAll();
    }

    private static void debug(String msg) {
    }
}

